/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionsByConnectionFunctionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, ListDistributionsByConnectionFunctionRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListDistributionsByConnectionFunctionRequest.getter(ListDistributionsByConnectionFunctionRequest::marker)).setter(ListDistributionsByConnectionFunctionRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").unmarshallLocationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListDistributionsByConnectionFunctionRequest.getter(ListDistributionsByConnectionFunctionRequest::maxItems)).setter(ListDistributionsByConnectionFunctionRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<String> CONNECTION_FUNCTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionFunctionIdentifier").getter(ListDistributionsByConnectionFunctionRequest.getter(ListDistributionsByConnectionFunctionRequest::connectionFunctionIdentifier)).setter(ListDistributionsByConnectionFunctionRequest.setter(Builder::connectionFunctionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ConnectionFunctionIdentifier").unmarshallLocationName("ConnectionFunctionIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD, CONNECTION_FUNCTION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDistributionsByConnectionFunctionRequest.memberNameToFieldInitializer();
    private final String marker;
    private final Integer maxItems;
    private final String connectionFunctionIdentifier;

    private ListDistributionsByConnectionFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.connectionFunctionIdentifier = builder.connectionFunctionIdentifier;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String connectionFunctionIdentifier() {
        return this.connectionFunctionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByConnectionFunctionRequest)) {
            return false;
        }
        ListDistributionsByConnectionFunctionRequest other = (ListDistributionsByConnectionFunctionRequest)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.connectionFunctionIdentifier(), other.connectionFunctionIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ListDistributionsByConnectionFunctionRequest").add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).add("ConnectionFunctionIdentifier", (Object)this.connectionFunctionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "ConnectionFunctionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("ConnectionFunctionIdentifier", CONNECTION_FUNCTION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByConnectionFunctionRequest, T> g) {
        return obj -> g.apply((ListDistributionsByConnectionFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String marker;
        private Integer maxItems;
        private String connectionFunctionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByConnectionFunctionRequest model) {
            super(model);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
            this.connectionFunctionIdentifier(model.connectionFunctionIdentifier);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getConnectionFunctionIdentifier() {
            return this.connectionFunctionIdentifier;
        }

        public final void setConnectionFunctionIdentifier(String connectionFunctionIdentifier) {
            this.connectionFunctionIdentifier = connectionFunctionIdentifier;
        }

        @Override
        public final Builder connectionFunctionIdentifier(String connectionFunctionIdentifier) {
            this.connectionFunctionIdentifier = connectionFunctionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByConnectionFunctionRequest build() {
            return new ListDistributionsByConnectionFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDistributionsByConnectionFunctionRequest> {
        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder connectionFunctionIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

