/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.internal.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.cloudfront.internal.auth.PemObject;
import software.amazon.awssdk.services.cloudfront.internal.auth.PemObjectType;
import software.amazon.awssdk.services.cloudfront.internal.auth.Rsa;
import software.amazon.awssdk.services.cloudfront.internal.utils.SigningUtils;

@SdkInternalApi
public final class Pem {
    private static final String BEGIN_MARKER = "-----BEGIN ";
    private static final Pattern BEGIN = Pattern.compile("BEGIN", 16);

    private Pem() {
    }

    public static PrivateKey readPrivateKey(InputStream is) throws InvalidKeySpecException, IOException {
        List<PemObject> objects = Pem.readPemObjects(is);
        for (PemObject object : objects) {
            switch (object.getPemObjectType()) {
                case PRIVATE_KEY_PKCS1: {
                    return Rsa.privateKeyFromPkcs1(object.getDerBytes());
                }
                case PRIVATE_KEY_PKCS8: {
                    return SigningUtils.privateKeyFromPkcs8(object.getDerBytes());
                }
            }
        }
        throw new IllegalArgumentException("Found no private key");
    }

    public static PublicKey readPublicKey(InputStream is) throws InvalidKeySpecException, IOException {
        List<PemObject> objects = Pem.readPemObjects(is);
        for (PemObject object : objects) {
            if (object.getPemObjectType() != PemObjectType.PUBLIC_KEY_X509) continue;
            return Rsa.publicKeyFrom(object.getDerBytes());
        }
        throw new IllegalArgumentException("Found no public key");
    }

    public static List<PemObject> readPemObjects(InputStream is) throws IOException {
        ArrayList<PemObject> pemContents = new ArrayList<PemObject>();
        boolean readingContent = false;
        String beginMarker = null;
        String endMarker = null;
        StringBuilder sb = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (readingContent) {
                    if (line.contains(endMarker)) {
                        pemContents.add(new PemObject(beginMarker, Base64.getDecoder().decode(sb.toString())));
                        readingContent = false;
                        continue;
                    }
                    sb.append(line.trim());
                    continue;
                }
                if (!line.contains(BEGIN_MARKER)) continue;
                readingContent = true;
                beginMarker = line.trim();
                endMarker = BEGIN.matcher(beginMarker).replaceAll("END");
                sb = new StringBuilder();
            }
            ArrayList<PemObject> arrayList = pemContents;
            return arrayList;
        }
    }
}

