/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.FunctionConfig;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionFunctionRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateConnectionFunctionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConnectionFunctionRequest.getter(CreateConnectionFunctionRequest::name)).setter(CreateConnectionFunctionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<FunctionConfig> CONNECTION_FUNCTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionFunctionConfig").getter(CreateConnectionFunctionRequest.getter(CreateConnectionFunctionRequest::connectionFunctionConfig)).setter(CreateConnectionFunctionRequest.setter(Builder::connectionFunctionConfig)).constructor(FunctionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionConfig").unmarshallLocationName("ConnectionFunctionConfig").build()}).build();
    private static final SdkField<SdkBytes> CONNECTION_FUNCTION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ConnectionFunctionCode").getter(CreateConnectionFunctionRequest.getter(CreateConnectionFunctionRequest::connectionFunctionCode)).setter(CreateConnectionFunctionRequest.setter(Builder::connectionFunctionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionFunctionCode").unmarshallLocationName("ConnectionFunctionCode").build()}).build();
    private static final SdkField<Tags> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tags").getter(CreateConnectionFunctionRequest.getter(CreateConnectionFunctionRequest::tags)).setter(CreateConnectionFunctionRequest.setter(Builder::tags)).constructor(Tags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONNECTION_FUNCTION_CONFIG_FIELD, CONNECTION_FUNCTION_CODE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectionFunctionRequest.memberNameToFieldInitializer();
    private final String name;
    private final FunctionConfig connectionFunctionConfig;
    private final SdkBytes connectionFunctionCode;
    private final Tags tags;

    private CreateConnectionFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.connectionFunctionConfig = builder.connectionFunctionConfig;
        this.connectionFunctionCode = builder.connectionFunctionCode;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final FunctionConfig connectionFunctionConfig() {
        return this.connectionFunctionConfig;
    }

    public final SdkBytes connectionFunctionCode() {
        return this.connectionFunctionCode;
    }

    public final Tags tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionFunctionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionFunctionRequest)) {
            return false;
        }
        CreateConnectionFunctionRequest other = (CreateConnectionFunctionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.connectionFunctionConfig(), other.connectionFunctionConfig()) && Objects.equals(this.connectionFunctionCode(), other.connectionFunctionCode()) && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectionFunctionRequest").add("Name", (Object)this.name()).add("ConnectionFunctionConfig", (Object)this.connectionFunctionConfig()).add("ConnectionFunctionCode", (Object)(this.connectionFunctionCode() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", (Object)this.tags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ConnectionFunctionConfig": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionConfig()));
            }
            case "ConnectionFunctionCode": {
                return Optional.ofNullable(clazz.cast(this.connectionFunctionCode()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ConnectionFunctionConfig", CONNECTION_FUNCTION_CONFIG_FIELD);
        map.put("ConnectionFunctionCode", CONNECTION_FUNCTION_CODE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionFunctionRequest, T> g) {
        return obj -> g.apply((CreateConnectionFunctionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String name;
        private FunctionConfig connectionFunctionConfig;
        private SdkBytes connectionFunctionCode;
        private Tags tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionFunctionRequest model) {
            super(model);
            this.name(model.name);
            this.connectionFunctionConfig(model.connectionFunctionConfig);
            this.connectionFunctionCode(model.connectionFunctionCode);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final FunctionConfig.Builder getConnectionFunctionConfig() {
            return this.connectionFunctionConfig != null ? this.connectionFunctionConfig.toBuilder() : null;
        }

        public final void setConnectionFunctionConfig(FunctionConfig.BuilderImpl connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig != null ? connectionFunctionConfig.build() : null;
        }

        @Override
        public final Builder connectionFunctionConfig(FunctionConfig connectionFunctionConfig) {
            this.connectionFunctionConfig = connectionFunctionConfig;
            return this;
        }

        public final ByteBuffer getConnectionFunctionCode() {
            return this.connectionFunctionCode == null ? null : this.connectionFunctionCode.asByteBuffer();
        }

        public final void setConnectionFunctionCode(ByteBuffer connectionFunctionCode) {
            this.connectionFunctionCode(connectionFunctionCode == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)connectionFunctionCode));
        }

        @Override
        public final Builder connectionFunctionCode(SdkBytes connectionFunctionCode) {
            this.connectionFunctionCode = connectionFunctionCode;
            return this;
        }

        public final Tags.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionFunctionRequest build() {
            return new CreateConnectionFunctionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectionFunctionRequest> {
        public Builder name(String var1);

        public Builder connectionFunctionConfig(FunctionConfig var1);

        default public Builder connectionFunctionConfig(Consumer<FunctionConfig.Builder> connectionFunctionConfig) {
            return this.connectionFunctionConfig((FunctionConfig)((FunctionConfig.Builder)FunctionConfig.builder().applyMutation(connectionFunctionConfig)).build());
        }

        public Builder connectionFunctionCode(SdkBytes var1);

        public Builder tags(Tags var1);

        default public Builder tags(Consumer<Tags.Builder> tags) {
            return this.tags((Tags)((Tags.Builder)Tags.builder().applyMutation(tags)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

