/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.TrustStoreConfig;
import software.amazon.awssdk.services.cloudfront.model.ViewerMtlsMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewerMtlsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewerMtlsConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ViewerMtlsConfig.getter(ViewerMtlsConfig::modeAsString)).setter(ViewerMtlsConfig.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").unmarshallLocationName("Mode").build()}).build();
    private static final SdkField<TrustStoreConfig> TRUST_STORE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrustStoreConfig").getter(ViewerMtlsConfig.getter(ViewerMtlsConfig::trustStoreConfig)).setter(ViewerMtlsConfig.setter(Builder::trustStoreConfig)).constructor(TrustStoreConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreConfig").unmarshallLocationName("TrustStoreConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, TRUST_STORE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ViewerMtlsConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final TrustStoreConfig trustStoreConfig;

    private ViewerMtlsConfig(BuilderImpl builder) {
        this.mode = builder.mode;
        this.trustStoreConfig = builder.trustStoreConfig;
    }

    public final ViewerMtlsMode mode() {
        return ViewerMtlsMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final TrustStoreConfig trustStoreConfig() {
        return this.trustStoreConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewerMtlsConfig)) {
            return false;
        }
        ViewerMtlsConfig other = (ViewerMtlsConfig)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.trustStoreConfig(), other.trustStoreConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ViewerMtlsConfig").add("Mode", (Object)this.modeAsString()).add("TrustStoreConfig", (Object)this.trustStoreConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "TrustStoreConfig": {
                return Optional.ofNullable(clazz.cast(this.trustStoreConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Mode", MODE_FIELD);
        map.put("TrustStoreConfig", TRUST_STORE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewerMtlsConfig, T> g) {
        return obj -> g.apply((ViewerMtlsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private TrustStoreConfig trustStoreConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewerMtlsConfig model) {
            this.mode(model.mode);
            this.trustStoreConfig(model.trustStoreConfig);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ViewerMtlsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final TrustStoreConfig.Builder getTrustStoreConfig() {
            return this.trustStoreConfig != null ? this.trustStoreConfig.toBuilder() : null;
        }

        public final void setTrustStoreConfig(TrustStoreConfig.BuilderImpl trustStoreConfig) {
            this.trustStoreConfig = trustStoreConfig != null ? trustStoreConfig.build() : null;
        }

        @Override
        public final Builder trustStoreConfig(TrustStoreConfig trustStoreConfig) {
            this.trustStoreConfig = trustStoreConfig;
            return this;
        }

        public ViewerMtlsConfig build() {
            return new ViewerMtlsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewerMtlsConfig> {
        public Builder mode(String var1);

        public Builder mode(ViewerMtlsMode var1);

        public Builder trustStoreConfig(TrustStoreConfig var1);

        default public Builder trustStoreConfig(Consumer<TrustStoreConfig.Builder> trustStoreConfig) {
            return this.trustStoreConfig((TrustStoreConfig)((TrustStoreConfig.Builder)TrustStoreConfig.builder().applyMutation(trustStoreConfig)).build());
        }
    }
}

