/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.EventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionAssociation> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionARN").getter(FunctionAssociation.getter(FunctionAssociation::functionARN)).setter(FunctionAssociation.setter(Builder::functionARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionARN").unmarshallLocationName("FunctionARN").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(FunctionAssociation.getter(FunctionAssociation::eventTypeAsString)).setter(FunctionAssociation.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").unmarshallLocationName("EventType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD, EVENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunctionAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String functionARN;
    private final String eventType;

    private FunctionAssociation(BuilderImpl builder) {
        this.functionARN = builder.functionARN;
        this.eventType = builder.eventType;
    }

    public final String functionARN() {
        return this.functionARN;
    }

    public final EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionAssociation)) {
            return false;
        }
        FunctionAssociation other = (FunctionAssociation)obj;
        return Objects.equals(this.functionARN(), other.functionARN()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionAssociation").add("FunctionARN", (Object)this.functionARN()).add("EventType", (Object)this.eventTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionARN": {
                return Optional.ofNullable(clazz.cast(this.functionARN()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FunctionARN", FUNCTION_ARN_FIELD);
        map.put("EventType", EVENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionAssociation, T> g) {
        return obj -> g.apply((FunctionAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionARN;
        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionAssociation model) {
            this.functionARN(model.functionARN);
            this.eventType(model.eventType);
        }

        public final String getFunctionARN() {
            return this.functionARN;
        }

        public final void setFunctionARN(String functionARN) {
            this.functionARN = functionARN;
        }

        @Override
        public final Builder functionARN(String functionARN) {
            this.functionARN = functionARN;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public FunctionAssociation build() {
            return new FunctionAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionAssociation> {
        public Builder functionARN(String var1);

        public Builder eventType(String var1);

        public Builder eventType(EventType var1);
    }
}

