/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.internal.utils;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Base64;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.cloudfront.internal.auth.Pem;
import software.amazon.awssdk.services.cloudfront.internal.auth.Rsa;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class SigningUtils {
    private SigningUtils() {
    }

    public static String buildCannedPolicy(String resourceUrl, Instant expirationDate) {
        return "{\"Statement\":[{\"Resource\":\"" + resourceUrl + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + expirationDate.getEpochSecond() + "}}}]}";
    }

    public static String buildCustomPolicy(String resourceUrl, Instant activeDate, Instant expirationDate, String ipAddress) {
        return "{\"Statement\": [{\"Resource\":\"" + resourceUrl + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + expirationDate.getEpochSecond() + "}" + (ipAddress == null ? "" : ",\"IpAddress\":{\"AWS:SourceIp\":\"" + ipAddress + "\"}") + (activeDate == null ? "" : ",\"DateGreaterThan\":{\"AWS:EpochTime\":" + activeDate.getEpochSecond() + "}") + "}}]}";
    }

    public static String makeBytesUrlSafe(byte[] bytes) {
        byte[] encoded = Base64.getEncoder().encode(bytes);
        block5: for (int i = 0; i < encoded.length; ++i) {
            switch (encoded[i]) {
                case 43: {
                    encoded[i] = 45;
                    continue block5;
                }
                case 61: {
                    encoded[i] = 95;
                    continue block5;
                }
                case 47: {
                    encoded[i] = 126;
                    continue block5;
                }
            }
        }
        return new String(encoded, StandardCharsets.UTF_8);
    }

    public static String makeStringUrlSafe(String str) {
        return SigningUtils.makeBytesUrlSafe(str.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] signWithSha1Rsa(byte[] dataToSign, PrivateKey privateKey) throws InvalidKeyException {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            SecureRandom random = new SecureRandom();
            signature.initSign(privateKey, random);
            signature.update(dataToSign);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String buildCustomPolicyForSignedUrl(String resourceUrl, Instant activeDate, Instant expirationDate, String limitToIpAddressCidr) {
        Validate.notNull((Object)expirationDate, (String)"Expiration date must be provided to sign CloudFront URLs", (Object[])new Object[0]);
        if (resourceUrl == null) {
            resourceUrl = "*";
        }
        return SigningUtils.buildCustomPolicy(resourceUrl, activeDate, expirationDate, limitToIpAddressCidr);
    }

    public static PrivateKey loadPrivateKey(Path keyFile) throws Exception {
        if (StringUtils.lowerCase((String)keyFile.toString()).endsWith(".pem")) {
            try (InputStream is = Files.newInputStream(keyFile, new OpenOption[0]);){
                PrivateKey privateKey = Pem.readPrivateKey(is);
                return privateKey;
            }
        }
        if (StringUtils.lowerCase((String)keyFile.toString()).endsWith(".der")) {
            try (InputStream is = Files.newInputStream(keyFile, new OpenOption[0]);){
                PrivateKey privateKey = Rsa.privateKeyFromPkcs8(IoUtils.toByteArray((InputStream)is));
                return privateKey;
            }
        }
        throw SdkClientException.create((String)"Unsupported file type for private key");
    }
}

