/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the Amazon S3 origin. If the origin is a custom origin or an S3 bucket
 * that is configured as a website endpoint, use the <code>CustomOriginConfig</code> element instead.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3OriginConfig implements SdkPojo, Serializable, ToCopyableBuilder<S3OriginConfig.Builder, S3OriginConfig> {
    private static final SdkField<String> ORIGIN_ACCESS_IDENTITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OriginAccessIdentity")
            .getter(getter(S3OriginConfig::originAccessIdentity))
            .setter(setter(Builder::originAccessIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessIdentity")
                    .unmarshallLocationName("OriginAccessIdentity").build()).build();

    private static final SdkField<Integer> ORIGIN_READ_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OriginReadTimeout")
            .getter(getter(S3OriginConfig::originReadTimeout))
            .setter(setter(Builder::originReadTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginReadTimeout")
                    .unmarshallLocationName("OriginReadTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCESS_IDENTITY_FIELD,
            ORIGIN_READ_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String originAccessIdentity;

    private final Integer originReadTimeout;

    private S3OriginConfig(BuilderImpl builder) {
        this.originAccessIdentity = builder.originAccessIdentity;
        this.originReadTimeout = builder.originReadTimeout;
    }

    /**
     * <p>
     * <note>
     * <p>
     * If you're using origin access control (OAC) instead of origin access identity, specify an empty
     * <code>OriginAccessIdentity</code> element. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html"
     * >Restricting access to an Amazon Web Services</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure
     * the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through CloudFront. The format
     * of the value is:
     * </p>
     * <p>
     * <code>origin-access-identity/cloudfront/ID-of-origin-access-identity</code>
     * </p>
     * <p>
     * The <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the
     * <code>ID</code> element when you created the origin access identity.
     * </p>
     * <p>
     * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an
     * empty <code>OriginAccessIdentity</code> element.
     * </p>
     * <p>
     * To delete the origin access identity from an existing distribution, update the distribution configuration and
     * include an empty <code>OriginAccessIdentity</code> element.
     * </p>
     * <p>
     * To replace the origin access identity, update the distribution configuration and specify the new origin access
     * identity.
     * </p>
     * <p>
     * For more information about the origin access identity, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * </p>
     * 
     * @return <p>
     *         If you're using origin access control (OAC) instead of origin access identity, specify an empty
     *         <code>OriginAccessIdentity</code> element. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html"
     *         >Restricting access to an Amazon Web Services</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         </note>
     *         <p>
     *         The CloudFront origin access identity to associate with the origin. Use an origin access identity to
     *         configure the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through
     *         CloudFront. The format of the value is:
     *         </p>
     *         <p>
     *         <code>origin-access-identity/cloudfront/ID-of-origin-access-identity</code>
     *         </p>
     *         <p>
     *         The <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the
     *         <code>ID</code> element when you created the origin access identity.
     *         </p>
     *         <p>
     *         If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
     *         specify an empty <code>OriginAccessIdentity</code> element.
     *         </p>
     *         <p>
     *         To delete the origin access identity from an existing distribution, update the distribution configuration
     *         and include an empty <code>OriginAccessIdentity</code> element.
     *         </p>
     *         <p>
     *         To replace the origin access identity, update the distribution configuration and specify the new origin
     *         access identity.
     *         </p>
     *         <p>
     *         For more information about the origin access identity, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final String originAccessIdentity() {
        return originAccessIdentity;
    }

    /**
     * <p>
     * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the
     * <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 120 seconds, and the default (if
     * you don't specify otherwise) is 30 seconds.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DownloadDistValuesOrigin.html#DownloadDistValuesOriginResponseTimeout"
     * >Response timeout</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as
     *         the <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 120 seconds, and the
     *         default (if you don't specify otherwise) is 30 seconds.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DownloadDistValuesOrigin.html#DownloadDistValuesOriginResponseTimeout"
     *         >Response timeout</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final Integer originReadTimeout() {
        return originReadTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originAccessIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(originReadTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OriginConfig)) {
            return false;
        }
        S3OriginConfig other = (S3OriginConfig) obj;
        return Objects.equals(originAccessIdentity(), other.originAccessIdentity())
                && Objects.equals(originReadTimeout(), other.originReadTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3OriginConfig").add("OriginAccessIdentity", originAccessIdentity())
                .add("OriginReadTimeout", originReadTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginAccessIdentity":
            return Optional.ofNullable(clazz.cast(originAccessIdentity()));
        case "OriginReadTimeout":
            return Optional.ofNullable(clazz.cast(originReadTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OriginAccessIdentity", ORIGIN_ACCESS_IDENTITY_FIELD);
        map.put("OriginReadTimeout", ORIGIN_READ_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3OriginConfig, T> g) {
        return obj -> g.apply((S3OriginConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3OriginConfig> {
        /**
         * <p>
         * <note>
         * <p>
         * If you're using origin access control (OAC) instead of origin access identity, specify an empty
         * <code>OriginAccessIdentity</code> element. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html"
         * >Restricting access to an Amazon Web Services</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * </note>
         * <p>
         * The CloudFront origin access identity to associate with the origin. Use an origin access identity to
         * configure the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through
         * CloudFront. The format of the value is:
         * </p>
         * <p>
         * <code>origin-access-identity/cloudfront/ID-of-origin-access-identity</code>
         * </p>
         * <p>
         * The <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the
         * <code>ID</code> element when you created the origin access identity.
         * </p>
         * <p>
         * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
         * specify an empty <code>OriginAccessIdentity</code> element.
         * </p>
         * <p>
         * To delete the origin access identity from an existing distribution, update the distribution configuration and
         * include an empty <code>OriginAccessIdentity</code> element.
         * </p>
         * <p>
         * To replace the origin access identity, update the distribution configuration and specify the new origin
         * access identity.
         * </p>
         * <p>
         * For more information about the origin access identity, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * </p>
         * 
         * @param originAccessIdentity
         *        <p>
         *        If you're using origin access control (OAC) instead of origin access identity, specify an empty
         *        <code>OriginAccessIdentity</code> element. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html"
         *        >Restricting access to an Amazon Web Services</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        </note>
         *        <p>
         *        The CloudFront origin access identity to associate with the origin. Use an origin access identity to
         *        configure the origin so that viewers can <i>only</i> access objects in an Amazon S3 bucket through
         *        CloudFront. The format of the value is:
         *        </p>
         *        <p>
         *        <code>origin-access-identity/cloudfront/ID-of-origin-access-identity</code>
         *        </p>
         *        <p>
         *        The <code> <i>ID-of-origin-access-identity</i> </code> is the value that CloudFront returned in the
         *        <code>ID</code> element when you created the origin access identity.
         *        </p>
         *        <p>
         *        If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
         *        specify an empty <code>OriginAccessIdentity</code> element.
         *        </p>
         *        <p>
         *        To delete the origin access identity from an existing distribution, update the distribution
         *        configuration and include an empty <code>OriginAccessIdentity</code> element.
         *        </p>
         *        <p>
         *        To replace the origin access identity, update the distribution configuration and specify the new
         *        origin access identity.
         *        </p>
         *        <p>
         *        For more information about the origin access identity, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccessIdentity(String originAccessIdentity);

        /**
         * <p>
         * Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as the
         * <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 120 seconds, and the default
         * (if you don't specify otherwise) is 30 seconds.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DownloadDistValuesOrigin.html#DownloadDistValuesOriginResponseTimeout"
         * >Response timeout</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param originReadTimeout
         *        Specifies how long, in seconds, CloudFront waits for a response from the origin. This is also known as
         *        the <i>origin response timeout</i>. The minimum timeout is 1 second, the maximum is 120 seconds, and
         *        the default (if you don't specify otherwise) is 30 seconds.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DownloadDistValuesOrigin.html#DownloadDistValuesOriginResponseTimeout"
         *        >Response timeout</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originReadTimeout(Integer originReadTimeout);
    }

    static final class BuilderImpl implements Builder {
        private String originAccessIdentity;

        private Integer originReadTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OriginConfig model) {
            originAccessIdentity(model.originAccessIdentity);
            originReadTimeout(model.originReadTimeout);
        }

        public final String getOriginAccessIdentity() {
            return originAccessIdentity;
        }

        public final void setOriginAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
        }

        @Override
        public final Builder originAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        public final Integer getOriginReadTimeout() {
            return originReadTimeout;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        @Override
        public S3OriginConfig build() {
            return new S3OriginConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
