/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionGroupResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateConnectionGroupResponse.Builder, CreateConnectionGroupResponse> {
    private static final SdkField<ConnectionGroup> CONNECTION_GROUP_FIELD = SdkField
            .<ConnectionGroup> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionGroup")
            .getter(getter(CreateConnectionGroupResponse::connectionGroup))
            .setter(setter(Builder::connectionGroup))
            .constructor(ConnectionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroup")
                    .unmarshallLocationName("ConnectionGroup").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(CreateConnectionGroupResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_GROUP_FIELD,
            E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConnectionGroup connectionGroup;

    private final String eTag;

    private CreateConnectionGroupResponse(BuilderImpl builder) {
        super(builder);
        this.connectionGroup = builder.connectionGroup;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The connection group that you created.
     * </p>
     * 
     * @return The connection group that you created.
     */
    public final ConnectionGroup connectionGroup() {
        return connectionGroup;
    }

    /**
     * <p>
     * The current version of the connection group.
     * </p>
     * 
     * @return The current version of the connection group.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionGroupResponse)) {
            return false;
        }
        CreateConnectionGroupResponse other = (CreateConnectionGroupResponse) obj;
        return Objects.equals(connectionGroup(), other.connectionGroup()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectionGroupResponse").add("ConnectionGroup", connectionGroup()).add("ETag", eTag())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionGroup":
            return Optional.ofNullable(clazz.cast(connectionGroup()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionGroup", CONNECTION_GROUP_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionGroupResponse, T> g) {
        return obj -> g.apply((CreateConnectionGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectionGroupResponse> {
        /**
         * <p>
         * The connection group that you created.
         * </p>
         * 
         * @param connectionGroup
         *        The connection group that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionGroup(ConnectionGroup connectionGroup);

        /**
         * <p>
         * The connection group that you created.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionGroup.Builder} avoiding the
         * need to create one manually via {@link ConnectionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionGroup(ConnectionGroup)}.
         * 
         * @param connectionGroup
         *        a consumer that will call methods on {@link ConnectionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionGroup(ConnectionGroup)
         */
        default Builder connectionGroup(Consumer<ConnectionGroup.Builder> connectionGroup) {
            return connectionGroup(ConnectionGroup.builder().applyMutation(connectionGroup).build());
        }

        /**
         * <p>
         * The current version of the connection group.
         * </p>
         * 
         * @param eTag
         *        The current version of the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private ConnectionGroup connectionGroup;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionGroupResponse model) {
            super(model);
            connectionGroup(model.connectionGroup);
            eTag(model.eTag);
        }

        public final ConnectionGroup.Builder getConnectionGroup() {
            return connectionGroup != null ? connectionGroup.toBuilder() : null;
        }

        public final void setConnectionGroup(ConnectionGroup.BuilderImpl connectionGroup) {
            this.connectionGroup = connectionGroup != null ? connectionGroup.build() : null;
        }

        @Override
        public final Builder connectionGroup(ConnectionGroup connectionGroup) {
            this.connectionGroup = connectionGroup;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public CreateConnectionGroupResponse build() {
            return new CreateConnectionGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
