/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateDistributionTenantWebAclResponse extends CloudFrontResponse implements
        ToCopyableBuilder<AssociateDistributionTenantWebAclResponse.Builder, AssociateDistributionTenantWebAclResponse> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(AssociateDistributionTenantWebAclResponse::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WebACLArn")
            .getter(getter(AssociateDistributionTenantWebAclResponse::webACLArn))
            .setter(setter(Builder::webACLArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLArn")
                    .unmarshallLocationName("WebACLArn").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(AssociateDistributionTenantWebAclResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, WEB_ACL_ARN_FIELD,
            E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String webACLArn;

    private final String eTag;

    private AssociateDistributionTenantWebAclResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.webACLArn = builder.webACLArn;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The ID of the distribution tenant.
     * </p>
     * 
     * @return The ID of the distribution tenant.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the WAF web ACL that you associated with the distribution tenant.
     * </p>
     * 
     * @return The ARN of the WAF web ACL that you associated with the distribution tenant.
     */
    public final String webACLArn() {
        return webACLArn;
    }

    /**
     * <p>
     * The current version of the distribution tenant.
     * </p>
     * 
     * @return The current version of the distribution tenant.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(webACLArn());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDistributionTenantWebAclResponse)) {
            return false;
        }
        AssociateDistributionTenantWebAclResponse other = (AssociateDistributionTenantWebAclResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(webACLArn(), other.webACLArn())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateDistributionTenantWebAclResponse").add("Id", id()).add("WebACLArn", webACLArn())
                .add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "WebACLArn":
            return Optional.ofNullable(clazz.cast(webACLArn()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("WebACLArn", WEB_ACL_ARN_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateDistributionTenantWebAclResponse, T> g) {
        return obj -> g.apply((AssociateDistributionTenantWebAclResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateDistributionTenantWebAclResponse> {
        /**
         * <p>
         * The ID of the distribution tenant.
         * </p>
         * 
         * @param id
         *        The ID of the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the WAF web ACL that you associated with the distribution tenant.
         * </p>
         * 
         * @param webACLArn
         *        The ARN of the WAF web ACL that you associated with the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLArn(String webACLArn);

        /**
         * <p>
         * The current version of the distribution tenant.
         * </p>
         * 
         * @param eTag
         *        The current version of the distribution tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private String id;

        private String webACLArn;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDistributionTenantWebAclResponse model) {
            super(model);
            id(model.id);
            webACLArn(model.webACLArn);
            eTag(model.eTag);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getWebACLArn() {
            return webACLArn;
        }

        public final void setWebACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
        }

        @Override
        public final Builder webACLArn(String webACLArn) {
            this.webACLArn = webACLArn;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public AssociateDistributionTenantWebAclResponse build() {
            return new AssociateDistributionTenantWebAclResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
