/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the CloudFront managed ACM certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedCertificateDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedCertificateDetails.Builder, ManagedCertificateDetails> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn")
            .getter(getter(ManagedCertificateDetails::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn")
                    .unmarshallLocationName("CertificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateStatus")
            .getter(getter(ManagedCertificateDetails::certificateStatusAsString))
            .setter(setter(Builder::certificateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateStatus")
                    .unmarshallLocationName("CertificateStatus").build()).build();

    private static final SdkField<String> VALIDATION_TOKEN_HOST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ValidationTokenHost")
            .getter(getter(ManagedCertificateDetails::validationTokenHostAsString))
            .setter(setter(Builder::validationTokenHost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationTokenHost")
                    .unmarshallLocationName("ValidationTokenHost").build()).build();

    private static final SdkField<List<ValidationTokenDetail>> VALIDATION_TOKEN_DETAILS_FIELD = SdkField
            .<List<ValidationTokenDetail>> builder(MarshallingType.LIST)
            .memberName("ValidationTokenDetails")
            .getter(getter(ManagedCertificateDetails::validationTokenDetails))
            .setter(setter(Builder::validationTokenDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationTokenDetails")
                    .unmarshallLocationName("ValidationTokenDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationTokenDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationTokenDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            CERTIFICATE_STATUS_FIELD, VALIDATION_TOKEN_HOST_FIELD, VALIDATION_TOKEN_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private final String certificateStatus;

    private final String validationTokenHost;

    private final List<ValidationTokenDetail> validationTokenDetails;

    private ManagedCertificateDetails(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateStatus = builder.certificateStatus;
        this.validationTokenHost = builder.validationTokenHost;
        this.validationTokenDetails = builder.validationTokenDetails;
    }

    /**
     * <p>
     * The ARN of the CloudFront managed ACM certificate.
     * </p>
     * 
     * @return The ARN of the CloudFront managed ACM certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The status of the CloudFront managed ACM certificate.
     * </p>
     * <note>
     * <p>
     * Your distribution tenant will be updated with the latest certificate status. When calling the <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistributionTenant.html"
     * >UpdateDistributionTenant</a> operation, use the latest value for the <code>ETag</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateStatus}
     * will return {@link ManagedCertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #certificateStatusAsString}.
     * </p>
     * 
     * @return The status of the CloudFront managed ACM certificate.</p> <note>
     *         <p>
     *         Your distribution tenant will be updated with the latest certificate status. When calling the <a
     *         href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistributionTenant.html"
     *         >UpdateDistributionTenant</a> operation, use the latest value for the <code>ETag</code>.
     *         </p>
     * @see ManagedCertificateStatus
     */
    public final ManagedCertificateStatus certificateStatus() {
        return ManagedCertificateStatus.fromValue(certificateStatus);
    }

    /**
     * <p>
     * The status of the CloudFront managed ACM certificate.
     * </p>
     * <note>
     * <p>
     * Your distribution tenant will be updated with the latest certificate status. When calling the <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistributionTenant.html"
     * >UpdateDistributionTenant</a> operation, use the latest value for the <code>ETag</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateStatus}
     * will return {@link ManagedCertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #certificateStatusAsString}.
     * </p>
     * 
     * @return The status of the CloudFront managed ACM certificate.</p> <note>
     *         <p>
     *         Your distribution tenant will be updated with the latest certificate status. When calling the <a
     *         href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistributionTenant.html"
     *         >UpdateDistributionTenant</a> operation, use the latest value for the <code>ETag</code>.
     *         </p>
     * @see ManagedCertificateStatus
     */
    public final String certificateStatusAsString() {
        return certificateStatus;
    }

    /**
     * <p>
     * Contains details about the validation token host of the specified CloudFront managed ACM certificate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode if you
     * can point the domain's DNS to CloudFront immediately.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose this mode
     * when you need to maintain current traffic flow while your certificate is being issued. You can place the
     * validation token at the well-known path on your existing web server, wait for ACM to validate and issue the
     * certificate, and then update your DNS to point to CloudFront.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This setting only affects the initial certificate request. Once the DNS points to CloudFront, all future
     * certificate renewals are automatically handled through CloudFront.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validationTokenHost} will return {@link ValidationTokenHost#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #validationTokenHostAsString}.
     * </p>
     * 
     * @return Contains details about the validation token host of the specified CloudFront managed ACM certificate.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode
     *         if you can point the domain's DNS to CloudFront immediately.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose
     *         this mode when you need to maintain current traffic flow while your certificate is being issued. You can
     *         place the validation token at the well-known path on your existing web server, wait for ACM to validate
     *         and issue the certificate, and then update your DNS to point to CloudFront.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This setting only affects the initial certificate request. Once the DNS points to CloudFront, all future
     *         certificate renewals are automatically handled through CloudFront.
     *         </p>
     * @see ValidationTokenHost
     */
    public final ValidationTokenHost validationTokenHost() {
        return ValidationTokenHost.fromValue(validationTokenHost);
    }

    /**
     * <p>
     * Contains details about the validation token host of the specified CloudFront managed ACM certificate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode if you
     * can point the domain's DNS to CloudFront immediately.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose this mode
     * when you need to maintain current traffic flow while your certificate is being issued. You can place the
     * validation token at the well-known path on your existing web server, wait for ACM to validate and issue the
     * certificate, and then update your DNS to point to CloudFront.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This setting only affects the initial certificate request. Once the DNS points to CloudFront, all future
     * certificate renewals are automatically handled through CloudFront.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validationTokenHost} will return {@link ValidationTokenHost#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #validationTokenHostAsString}.
     * </p>
     * 
     * @return Contains details about the validation token host of the specified CloudFront managed ACM certificate.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode
     *         if you can point the domain's DNS to CloudFront immediately.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose
     *         this mode when you need to maintain current traffic flow while your certificate is being issued. You can
     *         place the validation token at the well-known path on your existing web server, wait for ACM to validate
     *         and issue the certificate, and then update your DNS to point to CloudFront.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         This setting only affects the initial certificate request. Once the DNS points to CloudFront, all future
     *         certificate renewals are automatically handled through CloudFront.
     *         </p>
     * @see ValidationTokenHost
     */
    public final String validationTokenHostAsString() {
        return validationTokenHost;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationTokenDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasValidationTokenDetails() {
        return validationTokenDetails != null && !(validationTokenDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details about the validation token of the specified CloudFront managed ACM certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationTokenDetails} method.
     * </p>
     * 
     * @return Contains details about the validation token of the specified CloudFront managed ACM certificate.
     */
    public final List<ValidationTokenDetail> validationTokenDetails() {
        return validationTokenDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validationTokenHostAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationTokenDetails() ? validationTokenDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedCertificateDetails)) {
            return false;
        }
        ManagedCertificateDetails other = (ManagedCertificateDetails) obj;
        return Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(certificateStatusAsString(), other.certificateStatusAsString())
                && Objects.equals(validationTokenHostAsString(), other.validationTokenHostAsString())
                && hasValidationTokenDetails() == other.hasValidationTokenDetails()
                && Objects.equals(validationTokenDetails(), other.validationTokenDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedCertificateDetails").add("CertificateArn", certificateArn())
                .add("CertificateStatus", certificateStatusAsString()).add("ValidationTokenHost", validationTokenHostAsString())
                .add("ValidationTokenDetails", hasValidationTokenDetails() ? validationTokenDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "CertificateStatus":
            return Optional.ofNullable(clazz.cast(certificateStatusAsString()));
        case "ValidationTokenHost":
            return Optional.ofNullable(clazz.cast(validationTokenHostAsString()));
        case "ValidationTokenDetails":
            return Optional.ofNullable(clazz.cast(validationTokenDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("CertificateStatus", CERTIFICATE_STATUS_FIELD);
        map.put("ValidationTokenHost", VALIDATION_TOKEN_HOST_FIELD);
        map.put("ValidationTokenDetails", VALIDATION_TOKEN_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedCertificateDetails, T> g) {
        return obj -> g.apply((ManagedCertificateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedCertificateDetails> {
        /**
         * <p>
         * The ARN of the CloudFront managed ACM certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the CloudFront managed ACM certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The status of the CloudFront managed ACM certificate.
         * </p>
         * <note>
         * <p>
         * Your distribution tenant will be updated with the latest certificate status. When calling the <a
         * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistributionTenant.html"
         * >UpdateDistributionTenant</a> operation, use the latest value for the <code>ETag</code>.
         * </p>
         * </note>
         * 
         * @param certificateStatus
         *        The status of the CloudFront managed ACM certificate.</p> <note>
         *        <p>
         *        Your distribution tenant will be updated with the latest certificate status. When calling the <a
         *        href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistributionTenant.html"
         *        >UpdateDistributionTenant</a> operation, use the latest value for the <code>ETag</code>.
         *        </p>
         * @see ManagedCertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedCertificateStatus
         */
        Builder certificateStatus(String certificateStatus);

        /**
         * <p>
         * The status of the CloudFront managed ACM certificate.
         * </p>
         * <note>
         * <p>
         * Your distribution tenant will be updated with the latest certificate status. When calling the <a
         * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistributionTenant.html"
         * >UpdateDistributionTenant</a> operation, use the latest value for the <code>ETag</code>.
         * </p>
         * </note>
         * 
         * @param certificateStatus
         *        The status of the CloudFront managed ACM certificate.</p> <note>
         *        <p>
         *        Your distribution tenant will be updated with the latest certificate status. When calling the <a
         *        href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistributionTenant.html"
         *        >UpdateDistributionTenant</a> operation, use the latest value for the <code>ETag</code>.
         *        </p>
         * @see ManagedCertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedCertificateStatus
         */
        Builder certificateStatus(ManagedCertificateStatus certificateStatus);

        /**
         * <p>
         * Contains details about the validation token host of the specified CloudFront managed ACM certificate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode if
         * you can point the domain's DNS to CloudFront immediately.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose this
         * mode when you need to maintain current traffic flow while your certificate is being issued. You can place the
         * validation token at the well-known path on your existing web server, wait for ACM to validate and issue the
         * certificate, and then update your DNS to point to CloudFront.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This setting only affects the initial certificate request. Once the DNS points to CloudFront, all future
         * certificate renewals are automatically handled through CloudFront.
         * </p>
         * </note>
         * 
         * @param validationTokenHost
         *        Contains details about the validation token host of the specified CloudFront managed ACM
         *        certificate.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this
         *        mode if you can point the domain's DNS to CloudFront immediately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose
         *        this mode when you need to maintain current traffic flow while your certificate is being issued. You
         *        can place the validation token at the well-known path on your existing web server, wait for ACM to
         *        validate and issue the certificate, and then update your DNS to point to CloudFront.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This setting only affects the initial certificate request. Once the DNS points to CloudFront, all
         *        future certificate renewals are automatically handled through CloudFront.
         *        </p>
         * @see ValidationTokenHost
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationTokenHost
         */
        Builder validationTokenHost(String validationTokenHost);

        /**
         * <p>
         * Contains details about the validation token host of the specified CloudFront managed ACM certificate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode if
         * you can point the domain's DNS to CloudFront immediately.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose this
         * mode when you need to maintain current traffic flow while your certificate is being issued. You can place the
         * validation token at the well-known path on your existing web server, wait for ACM to validate and issue the
         * certificate, and then update your DNS to point to CloudFront.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * This setting only affects the initial certificate request. Once the DNS points to CloudFront, all future
         * certificate renewals are automatically handled through CloudFront.
         * </p>
         * </note>
         * 
         * @param validationTokenHost
         *        Contains details about the validation token host of the specified CloudFront managed ACM
         *        certificate.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this
         *        mode if you can point the domain's DNS to CloudFront immediately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose
         *        this mode when you need to maintain current traffic flow while your certificate is being issued. You
         *        can place the validation token at the well-known path on your existing web server, wait for ACM to
         *        validate and issue the certificate, and then update your DNS to point to CloudFront.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        This setting only affects the initial certificate request. Once the DNS points to CloudFront, all
         *        future certificate renewals are automatically handled through CloudFront.
         *        </p>
         * @see ValidationTokenHost
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationTokenHost
         */
        Builder validationTokenHost(ValidationTokenHost validationTokenHost);

        /**
         * <p>
         * Contains details about the validation token of the specified CloudFront managed ACM certificate.
         * </p>
         * 
         * @param validationTokenDetails
         *        Contains details about the validation token of the specified CloudFront managed ACM certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationTokenDetails(Collection<ValidationTokenDetail> validationTokenDetails);

        /**
         * <p>
         * Contains details about the validation token of the specified CloudFront managed ACM certificate.
         * </p>
         * 
         * @param validationTokenDetails
         *        Contains details about the validation token of the specified CloudFront managed ACM certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationTokenDetails(ValidationTokenDetail... validationTokenDetails);

        /**
         * <p>
         * Contains details about the validation token of the specified CloudFront managed ACM certificate.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #validationTokenDetails(List<ValidationTokenDetail>)}.
         * 
         * @param validationTokenDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.ValidationTokenDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationTokenDetails(java.util.Collection<ValidationTokenDetail>)
         */
        Builder validationTokenDetails(Consumer<ValidationTokenDetail.Builder>... validationTokenDetails);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateStatus;

        private String validationTokenHost;

        private List<ValidationTokenDetail> validationTokenDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedCertificateDetails model) {
            certificateArn(model.certificateArn);
            certificateStatus(model.certificateStatus);
            validationTokenHost(model.validationTokenHost);
            validationTokenDetails(model.validationTokenDetails);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getCertificateStatus() {
            return certificateStatus;
        }

        public final void setCertificateStatus(String certificateStatus) {
            this.certificateStatus = certificateStatus;
        }

        @Override
        public final Builder certificateStatus(String certificateStatus) {
            this.certificateStatus = certificateStatus;
            return this;
        }

        @Override
        public final Builder certificateStatus(ManagedCertificateStatus certificateStatus) {
            this.certificateStatus(certificateStatus == null ? null : certificateStatus.toString());
            return this;
        }

        public final String getValidationTokenHost() {
            return validationTokenHost;
        }

        public final void setValidationTokenHost(String validationTokenHost) {
            this.validationTokenHost = validationTokenHost;
        }

        @Override
        public final Builder validationTokenHost(String validationTokenHost) {
            this.validationTokenHost = validationTokenHost;
            return this;
        }

        @Override
        public final Builder validationTokenHost(ValidationTokenHost validationTokenHost) {
            this.validationTokenHost(validationTokenHost == null ? null : validationTokenHost.toString());
            return this;
        }

        public final List<ValidationTokenDetail.Builder> getValidationTokenDetails() {
            List<ValidationTokenDetail.Builder> result = ValidationTokenDetailListCopier
                    .copyToBuilder(this.validationTokenDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationTokenDetails(Collection<ValidationTokenDetail.BuilderImpl> validationTokenDetails) {
            this.validationTokenDetails = ValidationTokenDetailListCopier.copyFromBuilder(validationTokenDetails);
        }

        @Override
        public final Builder validationTokenDetails(Collection<ValidationTokenDetail> validationTokenDetails) {
            this.validationTokenDetails = ValidationTokenDetailListCopier.copy(validationTokenDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationTokenDetails(ValidationTokenDetail... validationTokenDetails) {
            validationTokenDetails(Arrays.asList(validationTokenDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationTokenDetails(Consumer<ValidationTokenDetail.Builder>... validationTokenDetails) {
            validationTokenDetails(Stream.of(validationTokenDetails)
                    .map(c -> ValidationTokenDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ManagedCertificateDetails build() {
            return new ManagedCertificateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
