/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainConflictsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListDomainConflictsResponse.Builder, ListDomainConflictsResponse> {
    private static final SdkField<List<DomainConflict>> DOMAIN_CONFLICTS_FIELD = SdkField
            .<List<DomainConflict>> builder(MarshallingType.LIST)
            .memberName("DomainConflicts")
            .getter(getter(ListDomainConflictsResponse::domainConflicts))
            .setter(setter(Builder::domainConflicts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainConflicts")
                    .unmarshallLocationName("DomainConflicts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DomainConflicts")
                            .memberFieldInfo(
                                    SdkField.<DomainConflict> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainConflict::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DomainConflicts").unmarshallLocationName("DomainConflicts")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(ListDomainConflictsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFLICTS_FIELD,
            NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DomainConflict> domainConflicts;

    private final String nextMarker;

    private ListDomainConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.domainConflicts = builder.domainConflicts;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainConflicts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainConflicts() {
        return domainConflicts != null && !(domainConflicts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains details about the domain conflicts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainConflicts} method.
     * </p>
     * 
     * @return Contains details about the domain conflicts.
     */
    public final List<DomainConflict> domainConflicts() {
        return domainConflicts;
    }

    /**
     * <p>
     * A token used for pagination of results returned in the response. You can use the token from the previous request
     * to define where the current request should begin.
     * </p>
     * 
     * @return A token used for pagination of results returned in the response. You can use the token from the previous
     *         request to define where the current request should begin.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainConflicts() ? domainConflicts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainConflictsResponse)) {
            return false;
        }
        ListDomainConflictsResponse other = (ListDomainConflictsResponse) obj;
        return hasDomainConflicts() == other.hasDomainConflicts() && Objects.equals(domainConflicts(), other.domainConflicts())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDomainConflictsResponse")
                .add("DomainConflicts", hasDomainConflicts() ? domainConflicts() : null).add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainConflicts":
            return Optional.ofNullable(clazz.cast(domainConflicts()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainConflicts", DOMAIN_CONFLICTS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDomainConflictsResponse, T> g) {
        return obj -> g.apply((ListDomainConflictsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainConflictsResponse> {
        /**
         * <p>
         * Contains details about the domain conflicts.
         * </p>
         * 
         * @param domainConflicts
         *        Contains details about the domain conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConflicts(Collection<DomainConflict> domainConflicts);

        /**
         * <p>
         * Contains details about the domain conflicts.
         * </p>
         * 
         * @param domainConflicts
         *        Contains details about the domain conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConflicts(DomainConflict... domainConflicts);

        /**
         * <p>
         * Contains details about the domain conflicts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.DomainConflict.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudfront.model.DomainConflict#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.DomainConflict.Builder#build()} is called immediately
         * and its result is passed to {@link #domainConflicts(List<DomainConflict>)}.
         * 
         * @param domainConflicts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.DomainConflict.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainConflicts(java.util.Collection<DomainConflict>)
         */
        Builder domainConflicts(Consumer<DomainConflict.Builder>... domainConflicts);

        /**
         * <p>
         * A token used for pagination of results returned in the response. You can use the token from the previous
         * request to define where the current request should begin.
         * </p>
         * 
         * @param nextMarker
         *        A token used for pagination of results returned in the response. You can use the token from the
         *        previous request to define where the current request should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private List<DomainConflict> domainConflicts = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainConflictsResponse model) {
            super(model);
            domainConflicts(model.domainConflicts);
            nextMarker(model.nextMarker);
        }

        public final List<DomainConflict.Builder> getDomainConflicts() {
            List<DomainConflict.Builder> result = DomainConflictsListCopier.copyToBuilder(this.domainConflicts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainConflicts(Collection<DomainConflict.BuilderImpl> domainConflicts) {
            this.domainConflicts = DomainConflictsListCopier.copyFromBuilder(domainConflicts);
        }

        @Override
        public final Builder domainConflicts(Collection<DomainConflict> domainConflicts) {
            this.domainConflicts = DomainConflictsListCopier.copy(domainConflicts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainConflicts(DomainConflict... domainConflicts) {
            domainConflicts(Arrays.asList(domainConflicts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainConflicts(Consumer<DomainConflict.Builder>... domainConflicts) {
            domainConflicts(Stream.of(domainConflicts).map(c -> DomainConflict.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListDomainConflictsResponse build() {
            return new ListDomainConflictsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
