/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex data type that includes the profile configurations specified for field-level encryption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldLevelEncryptionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldLevelEncryptionConfig.Builder, FieldLevelEncryptionConfig> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(FieldLevelEncryptionConfig::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(FieldLevelEncryptionConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<QueryArgProfileConfig> QUERY_ARG_PROFILE_CONFIG_FIELD = SdkField
            .<QueryArgProfileConfig> builder(MarshallingType.SDK_POJO)
            .memberName("QueryArgProfileConfig")
            .getter(getter(FieldLevelEncryptionConfig::queryArgProfileConfig))
            .setter(setter(Builder::queryArgProfileConfig))
            .constructor(QueryArgProfileConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArgProfileConfig")
                    .unmarshallLocationName("QueryArgProfileConfig").build()).build();

    private static final SdkField<ContentTypeProfileConfig> CONTENT_TYPE_PROFILE_CONFIG_FIELD = SdkField
            .<ContentTypeProfileConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ContentTypeProfileConfig")
            .getter(getter(FieldLevelEncryptionConfig::contentTypeProfileConfig))
            .setter(setter(Builder::contentTypeProfileConfig))
            .constructor(ContentTypeProfileConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypeProfileConfig")
                    .unmarshallLocationName("ContentTypeProfileConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD,
            COMMENT_FIELD, QUERY_ARG_PROFILE_CONFIG_FIELD, CONTENT_TYPE_PROFILE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String callerReference;

    private final String comment;

    private final QueryArgProfileConfig queryArgProfileConfig;

    private final ContentTypeProfileConfig contentTypeProfileConfig;

    private FieldLevelEncryptionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.comment = builder.comment;
        this.queryArgProfileConfig = builder.queryArgProfileConfig;
        this.contentTypeProfileConfig = builder.contentTypeProfileConfig;
    }

    /**
     * <p>
     * A unique number that ensures the request can't be replayed.
     * </p>
     * 
     * @return A unique number that ensures the request can't be replayed.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * An optional comment about the configuration. The comment cannot be longer than 128 characters.
     * </p>
     * 
     * @return An optional comment about the configuration. The comment cannot be longer than 128 characters.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex data type that specifies when to forward content if a profile isn't found and the profile that can be
     * provided as a query argument in a request.
     * </p>
     * 
     * @return A complex data type that specifies when to forward content if a profile isn't found and the profile that
     *         can be provided as a query argument in a request.
     */
    public final QueryArgProfileConfig queryArgProfileConfig() {
        return queryArgProfileConfig;
    }

    /**
     * <p>
     * A complex data type that specifies when to forward content if a content type isn't recognized and profiles to use
     * as by default in a request if a query argument doesn't specify a profile to use.
     * </p>
     * 
     * @return A complex data type that specifies when to forward content if a content type isn't recognized and
     *         profiles to use as by default in a request if a query argument doesn't specify a profile to use.
     */
    public final ContentTypeProfileConfig contentTypeProfileConfig() {
        return contentTypeProfileConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(queryArgProfileConfig());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeProfileConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLevelEncryptionConfig)) {
            return false;
        }
        FieldLevelEncryptionConfig other = (FieldLevelEncryptionConfig) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(comment(), other.comment())
                && Objects.equals(queryArgProfileConfig(), other.queryArgProfileConfig())
                && Objects.equals(contentTypeProfileConfig(), other.contentTypeProfileConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldLevelEncryptionConfig").add("CallerReference", callerReference()).add("Comment", comment())
                .add("QueryArgProfileConfig", queryArgProfileConfig())
                .add("ContentTypeProfileConfig", contentTypeProfileConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "QueryArgProfileConfig":
            return Optional.ofNullable(clazz.cast(queryArgProfileConfig()));
        case "ContentTypeProfileConfig":
            return Optional.ofNullable(clazz.cast(contentTypeProfileConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CallerReference", CALLER_REFERENCE_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("QueryArgProfileConfig", QUERY_ARG_PROFILE_CONFIG_FIELD);
        map.put("ContentTypeProfileConfig", CONTENT_TYPE_PROFILE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldLevelEncryptionConfig, T> g) {
        return obj -> g.apply((FieldLevelEncryptionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldLevelEncryptionConfig> {
        /**
         * <p>
         * A unique number that ensures the request can't be replayed.
         * </p>
         * 
         * @param callerReference
         *        A unique number that ensures the request can't be replayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * An optional comment about the configuration. The comment cannot be longer than 128 characters.
         * </p>
         * 
         * @param comment
         *        An optional comment about the configuration. The comment cannot be longer than 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex data type that specifies when to forward content if a profile isn't found and the profile that can
         * be provided as a query argument in a request.
         * </p>
         * 
         * @param queryArgProfileConfig
         *        A complex data type that specifies when to forward content if a profile isn't found and the profile
         *        that can be provided as a query argument in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryArgProfileConfig(QueryArgProfileConfig queryArgProfileConfig);

        /**
         * <p>
         * A complex data type that specifies when to forward content if a profile isn't found and the profile that can
         * be provided as a query argument in a request.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryArgProfileConfig.Builder} avoiding
         * the need to create one manually via {@link QueryArgProfileConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryArgProfileConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #queryArgProfileConfig(QueryArgProfileConfig)}.
         * 
         * @param queryArgProfileConfig
         *        a consumer that will call methods on {@link QueryArgProfileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryArgProfileConfig(QueryArgProfileConfig)
         */
        default Builder queryArgProfileConfig(Consumer<QueryArgProfileConfig.Builder> queryArgProfileConfig) {
            return queryArgProfileConfig(QueryArgProfileConfig.builder().applyMutation(queryArgProfileConfig).build());
        }

        /**
         * <p>
         * A complex data type that specifies when to forward content if a content type isn't recognized and profiles to
         * use as by default in a request if a query argument doesn't specify a profile to use.
         * </p>
         * 
         * @param contentTypeProfileConfig
         *        A complex data type that specifies when to forward content if a content type isn't recognized and
         *        profiles to use as by default in a request if a query argument doesn't specify a profile to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentTypeProfileConfig(ContentTypeProfileConfig contentTypeProfileConfig);

        /**
         * <p>
         * A complex data type that specifies when to forward content if a content type isn't recognized and profiles to
         * use as by default in a request if a query argument doesn't specify a profile to use.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentTypeProfileConfig.Builder}
         * avoiding the need to create one manually via {@link ContentTypeProfileConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentTypeProfileConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #contentTypeProfileConfig(ContentTypeProfileConfig)}.
         * 
         * @param contentTypeProfileConfig
         *        a consumer that will call methods on {@link ContentTypeProfileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentTypeProfileConfig(ContentTypeProfileConfig)
         */
        default Builder contentTypeProfileConfig(Consumer<ContentTypeProfileConfig.Builder> contentTypeProfileConfig) {
            return contentTypeProfileConfig(ContentTypeProfileConfig.builder().applyMutation(contentTypeProfileConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String callerReference;

        private String comment;

        private QueryArgProfileConfig queryArgProfileConfig;

        private ContentTypeProfileConfig contentTypeProfileConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldLevelEncryptionConfig model) {
            callerReference(model.callerReference);
            comment(model.comment);
            queryArgProfileConfig(model.queryArgProfileConfig);
            contentTypeProfileConfig(model.contentTypeProfileConfig);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final QueryArgProfileConfig.Builder getQueryArgProfileConfig() {
            return queryArgProfileConfig != null ? queryArgProfileConfig.toBuilder() : null;
        }

        public final void setQueryArgProfileConfig(QueryArgProfileConfig.BuilderImpl queryArgProfileConfig) {
            this.queryArgProfileConfig = queryArgProfileConfig != null ? queryArgProfileConfig.build() : null;
        }

        @Override
        public final Builder queryArgProfileConfig(QueryArgProfileConfig queryArgProfileConfig) {
            this.queryArgProfileConfig = queryArgProfileConfig;
            return this;
        }

        public final ContentTypeProfileConfig.Builder getContentTypeProfileConfig() {
            return contentTypeProfileConfig != null ? contentTypeProfileConfig.toBuilder() : null;
        }

        public final void setContentTypeProfileConfig(ContentTypeProfileConfig.BuilderImpl contentTypeProfileConfig) {
            this.contentTypeProfileConfig = contentTypeProfileConfig != null ? contentTypeProfileConfig.build() : null;
        }

        @Override
        public final Builder contentTypeProfileConfig(ContentTypeProfileConfig contentTypeProfileConfig) {
            this.contentTypeProfileConfig = contentTypeProfileConfig;
            return this;
        }

        @Override
        public FieldLevelEncryptionConfig build() {
            return new FieldLevelEncryptionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
