/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CustomHeaders;
import software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig;
import software.amazon.awssdk.services.cloudfront.model.OriginShield;
import software.amazon.awssdk.services.cloudfront.model.S3OriginConfig;
import software.amazon.awssdk.services.cloudfront.model.VpcOriginConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Origin
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Origin> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Origin.getter(Origin::id)).setter(Origin.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(Origin.getter(Origin::domainName)).setter(Origin.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").unmarshallLocationName("DomainName").build()}).build();
    private static final SdkField<String> ORIGIN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginPath").getter(Origin.getter(Origin::originPath)).setter(Origin.setter(Builder::originPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginPath").unmarshallLocationName("OriginPath").build()}).build();
    private static final SdkField<CustomHeaders> CUSTOM_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomHeaders").getter(Origin.getter(Origin::customHeaders)).setter(Origin.setter(Builder::customHeaders)).constructor(CustomHeaders::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomHeaders").unmarshallLocationName("CustomHeaders").build()}).build();
    private static final SdkField<S3OriginConfig> S3_ORIGIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3OriginConfig").getter(Origin.getter(Origin::s3OriginConfig)).setter(Origin.setter(Builder::s3OriginConfig)).constructor(S3OriginConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OriginConfig").unmarshallLocationName("S3OriginConfig").build()}).build();
    private static final SdkField<CustomOriginConfig> CUSTOM_ORIGIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomOriginConfig").getter(Origin.getter(Origin::customOriginConfig)).setter(Origin.setter(Builder::customOriginConfig)).constructor(CustomOriginConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomOriginConfig").unmarshallLocationName("CustomOriginConfig").build()}).build();
    private static final SdkField<VpcOriginConfig> VPC_ORIGIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOriginConfig").getter(Origin.getter(Origin::vpcOriginConfig)).setter(Origin.setter(Builder::vpcOriginConfig)).constructor(VpcOriginConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOriginConfig").unmarshallLocationName("VpcOriginConfig").build()}).build();
    private static final SdkField<Integer> CONNECTION_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionAttempts").getter(Origin.getter(Origin::connectionAttempts)).setter(Origin.setter(Builder::connectionAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAttempts").unmarshallLocationName("ConnectionAttempts").build()}).build();
    private static final SdkField<Integer> CONNECTION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConnectionTimeout").getter(Origin.getter(Origin::connectionTimeout)).setter(Origin.setter(Builder::connectionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionTimeout").unmarshallLocationName("ConnectionTimeout").build()}).build();
    private static final SdkField<OriginShield> ORIGIN_SHIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginShield").getter(Origin.getter(Origin::originShield)).setter(Origin.setter(Builder::originShield)).constructor(OriginShield::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginShield").unmarshallLocationName("OriginShield").build()}).build();
    private static final SdkField<String> ORIGIN_ACCESS_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginAccessControlId").getter(Origin.getter(Origin::originAccessControlId)).setter(Origin.setter(Builder::originAccessControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlId").unmarshallLocationName("OriginAccessControlId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DOMAIN_NAME_FIELD, ORIGIN_PATH_FIELD, CUSTOM_HEADERS_FIELD, S3_ORIGIN_CONFIG_FIELD, CUSTOM_ORIGIN_CONFIG_FIELD, VPC_ORIGIN_CONFIG_FIELD, CONNECTION_ATTEMPTS_FIELD, CONNECTION_TIMEOUT_FIELD, ORIGIN_SHIELD_FIELD, ORIGIN_ACCESS_CONTROL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Origin.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String domainName;
    private final String originPath;
    private final CustomHeaders customHeaders;
    private final S3OriginConfig s3OriginConfig;
    private final CustomOriginConfig customOriginConfig;
    private final VpcOriginConfig vpcOriginConfig;
    private final Integer connectionAttempts;
    private final Integer connectionTimeout;
    private final OriginShield originShield;
    private final String originAccessControlId;

    private Origin(BuilderImpl builder) {
        this.id = builder.id;
        this.domainName = builder.domainName;
        this.originPath = builder.originPath;
        this.customHeaders = builder.customHeaders;
        this.s3OriginConfig = builder.s3OriginConfig;
        this.customOriginConfig = builder.customOriginConfig;
        this.vpcOriginConfig = builder.vpcOriginConfig;
        this.connectionAttempts = builder.connectionAttempts;
        this.connectionTimeout = builder.connectionTimeout;
        this.originShield = builder.originShield;
        this.originAccessControlId = builder.originAccessControlId;
    }

    public final String id() {
        return this.id;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String originPath() {
        return this.originPath;
    }

    public final CustomHeaders customHeaders() {
        return this.customHeaders;
    }

    public final S3OriginConfig s3OriginConfig() {
        return this.s3OriginConfig;
    }

    public final CustomOriginConfig customOriginConfig() {
        return this.customOriginConfig;
    }

    public final VpcOriginConfig vpcOriginConfig() {
        return this.vpcOriginConfig;
    }

    public final Integer connectionAttempts() {
        return this.connectionAttempts;
    }

    public final Integer connectionTimeout() {
        return this.connectionTimeout;
    }

    public final OriginShield originShield() {
        return this.originShield;
    }

    public final String originAccessControlId() {
        return this.originAccessControlId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.customHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OriginConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.customOriginConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOriginConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.originShield());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccessControlId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.originPath(), other.originPath()) && Objects.equals(this.customHeaders(), other.customHeaders()) && Objects.equals(this.s3OriginConfig(), other.s3OriginConfig()) && Objects.equals(this.customOriginConfig(), other.customOriginConfig()) && Objects.equals(this.vpcOriginConfig(), other.vpcOriginConfig()) && Objects.equals(this.connectionAttempts(), other.connectionAttempts()) && Objects.equals(this.connectionTimeout(), other.connectionTimeout()) && Objects.equals(this.originShield(), other.originShield()) && Objects.equals(this.originAccessControlId(), other.originAccessControlId());
    }

    public final String toString() {
        return ToString.builder((String)"Origin").add("Id", (Object)this.id()).add("DomainName", (Object)this.domainName()).add("OriginPath", (Object)this.originPath()).add("CustomHeaders", (Object)this.customHeaders()).add("S3OriginConfig", (Object)this.s3OriginConfig()).add("CustomOriginConfig", (Object)this.customOriginConfig()).add("VpcOriginConfig", (Object)this.vpcOriginConfig()).add("ConnectionAttempts", (Object)this.connectionAttempts()).add("ConnectionTimeout", (Object)this.connectionTimeout()).add("OriginShield", (Object)this.originShield()).add("OriginAccessControlId", (Object)this.originAccessControlId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "OriginPath": {
                return Optional.ofNullable(clazz.cast(this.originPath()));
            }
            case "CustomHeaders": {
                return Optional.ofNullable(clazz.cast(this.customHeaders()));
            }
            case "S3OriginConfig": {
                return Optional.ofNullable(clazz.cast(this.s3OriginConfig()));
            }
            case "CustomOriginConfig": {
                return Optional.ofNullable(clazz.cast(this.customOriginConfig()));
            }
            case "VpcOriginConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcOriginConfig()));
            }
            case "ConnectionAttempts": {
                return Optional.ofNullable(clazz.cast(this.connectionAttempts()));
            }
            case "ConnectionTimeout": {
                return Optional.ofNullable(clazz.cast(this.connectionTimeout()));
            }
            case "OriginShield": {
                return Optional.ofNullable(clazz.cast(this.originShield()));
            }
            case "OriginAccessControlId": {
                return Optional.ofNullable(clazz.cast(this.originAccessControlId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("OriginPath", ORIGIN_PATH_FIELD);
        map.put("CustomHeaders", CUSTOM_HEADERS_FIELD);
        map.put("S3OriginConfig", S3_ORIGIN_CONFIG_FIELD);
        map.put("CustomOriginConfig", CUSTOM_ORIGIN_CONFIG_FIELD);
        map.put("VpcOriginConfig", VPC_ORIGIN_CONFIG_FIELD);
        map.put("ConnectionAttempts", CONNECTION_ATTEMPTS_FIELD);
        map.put("ConnectionTimeout", CONNECTION_TIMEOUT_FIELD);
        map.put("OriginShield", ORIGIN_SHIELD_FIELD);
        map.put("OriginAccessControlId", ORIGIN_ACCESS_CONTROL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Origin, T> g) {
        return obj -> g.apply((Origin)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String domainName;
        private String originPath;
        private CustomHeaders customHeaders;
        private S3OriginConfig s3OriginConfig;
        private CustomOriginConfig customOriginConfig;
        private VpcOriginConfig vpcOriginConfig;
        private Integer connectionAttempts;
        private Integer connectionTimeout;
        private OriginShield originShield;
        private String originAccessControlId;

        private BuilderImpl() {
        }

        private BuilderImpl(Origin model) {
            this.id(model.id);
            this.domainName(model.domainName);
            this.originPath(model.originPath);
            this.customHeaders(model.customHeaders);
            this.s3OriginConfig(model.s3OriginConfig);
            this.customOriginConfig(model.customOriginConfig);
            this.vpcOriginConfig(model.vpcOriginConfig);
            this.connectionAttempts(model.connectionAttempts);
            this.connectionTimeout(model.connectionTimeout);
            this.originShield(model.originShield);
            this.originAccessControlId(model.originAccessControlId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getOriginPath() {
            return this.originPath;
        }

        public final void setOriginPath(String originPath) {
            this.originPath = originPath;
        }

        @Override
        public final Builder originPath(String originPath) {
            this.originPath = originPath;
            return this;
        }

        public final CustomHeaders.Builder getCustomHeaders() {
            return this.customHeaders != null ? this.customHeaders.toBuilder() : null;
        }

        public final void setCustomHeaders(CustomHeaders.BuilderImpl customHeaders) {
            this.customHeaders = customHeaders != null ? customHeaders.build() : null;
        }

        @Override
        public final Builder customHeaders(CustomHeaders customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final S3OriginConfig.Builder getS3OriginConfig() {
            return this.s3OriginConfig != null ? this.s3OriginConfig.toBuilder() : null;
        }

        public final void setS3OriginConfig(S3OriginConfig.BuilderImpl s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig != null ? s3OriginConfig.build() : null;
        }

        @Override
        public final Builder s3OriginConfig(S3OriginConfig s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig;
            return this;
        }

        public final CustomOriginConfig.Builder getCustomOriginConfig() {
            return this.customOriginConfig != null ? this.customOriginConfig.toBuilder() : null;
        }

        public final void setCustomOriginConfig(CustomOriginConfig.BuilderImpl customOriginConfig) {
            this.customOriginConfig = customOriginConfig != null ? customOriginConfig.build() : null;
        }

        @Override
        public final Builder customOriginConfig(CustomOriginConfig customOriginConfig) {
            this.customOriginConfig = customOriginConfig;
            return this;
        }

        public final VpcOriginConfig.Builder getVpcOriginConfig() {
            return this.vpcOriginConfig != null ? this.vpcOriginConfig.toBuilder() : null;
        }

        public final void setVpcOriginConfig(VpcOriginConfig.BuilderImpl vpcOriginConfig) {
            this.vpcOriginConfig = vpcOriginConfig != null ? vpcOriginConfig.build() : null;
        }

        @Override
        public final Builder vpcOriginConfig(VpcOriginConfig vpcOriginConfig) {
            this.vpcOriginConfig = vpcOriginConfig;
            return this;
        }

        public final Integer getConnectionAttempts() {
            return this.connectionAttempts;
        }

        public final void setConnectionAttempts(Integer connectionAttempts) {
            this.connectionAttempts = connectionAttempts;
        }

        @Override
        public final Builder connectionAttempts(Integer connectionAttempts) {
            this.connectionAttempts = connectionAttempts;
            return this;
        }

        public final Integer getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public final void setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        @Override
        public final Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public final OriginShield.Builder getOriginShield() {
            return this.originShield != null ? this.originShield.toBuilder() : null;
        }

        public final void setOriginShield(OriginShield.BuilderImpl originShield) {
            this.originShield = originShield != null ? originShield.build() : null;
        }

        @Override
        public final Builder originShield(OriginShield originShield) {
            this.originShield = originShield;
            return this;
        }

        public final String getOriginAccessControlId() {
            return this.originAccessControlId;
        }

        public final void setOriginAccessControlId(String originAccessControlId) {
            this.originAccessControlId = originAccessControlId;
        }

        @Override
        public final Builder originAccessControlId(String originAccessControlId) {
            this.originAccessControlId = originAccessControlId;
            return this;
        }

        public Origin build() {
            return new Origin(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Origin> {
        public Builder id(String var1);

        public Builder domainName(String var1);

        public Builder originPath(String var1);

        public Builder customHeaders(CustomHeaders var1);

        default public Builder customHeaders(Consumer<CustomHeaders.Builder> customHeaders) {
            return this.customHeaders((CustomHeaders)((CustomHeaders.Builder)CustomHeaders.builder().applyMutation(customHeaders)).build());
        }

        public Builder s3OriginConfig(S3OriginConfig var1);

        default public Builder s3OriginConfig(Consumer<S3OriginConfig.Builder> s3OriginConfig) {
            return this.s3OriginConfig((S3OriginConfig)((S3OriginConfig.Builder)S3OriginConfig.builder().applyMutation(s3OriginConfig)).build());
        }

        public Builder customOriginConfig(CustomOriginConfig var1);

        default public Builder customOriginConfig(Consumer<CustomOriginConfig.Builder> customOriginConfig) {
            return this.customOriginConfig((CustomOriginConfig)((CustomOriginConfig.Builder)CustomOriginConfig.builder().applyMutation(customOriginConfig)).build());
        }

        public Builder vpcOriginConfig(VpcOriginConfig var1);

        default public Builder vpcOriginConfig(Consumer<VpcOriginConfig.Builder> vpcOriginConfig) {
            return this.vpcOriginConfig((VpcOriginConfig)((VpcOriginConfig.Builder)VpcOriginConfig.builder().applyMutation(vpcOriginConfig)).build());
        }

        public Builder connectionAttempts(Integer var1);

        public Builder connectionTimeout(Integer var1);

        public Builder originShield(OriginShield var1);

        default public Builder originShield(Consumer<OriginShield.Builder> originShield) {
            return this.originShield((OriginShield)((OriginShield.Builder)OriginShield.builder().applyMutation(originShield)).build());
        }

        public Builder originAccessControlId(String var1);
    }
}

