/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionGroupRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateConnectionGroupRequest.Builder, UpdateConnectionGroupRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateConnectionGroupRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Boolean> IPV6_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Ipv6Enabled")
            .getter(getter(UpdateConnectionGroupRequest::ipv6Enabled))
            .setter(setter(Builder::ipv6Enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Enabled")
                    .unmarshallLocationName("Ipv6Enabled").build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateConnectionGroupRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnycastIpListId")
            .getter(getter(UpdateConnectionGroupRequest::anycastIpListId))
            .setter(setter(Builder::anycastIpListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId")
                    .unmarshallLocationName("AnycastIpListId").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(UpdateConnectionGroupRequest::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IPV6_ENABLED_FIELD,
            IF_MATCH_FIELD, ANYCAST_IP_LIST_ID_FIELD, ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final Boolean ipv6Enabled;

    private final String ifMatch;

    private final String anycastIpListId;

    private final Boolean enabled;

    private UpdateConnectionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ipv6Enabled = builder.ipv6Enabled;
        this.ifMatch = builder.ifMatch;
        this.anycastIpListId = builder.anycastIpListId;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The ID of the connection group.
     * </p>
     * 
     * @return The ID of the connection group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Enable IPv6 for the connection group. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesEnableIPv6"
     * >Enable IPv6</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Enable IPv6 for the connection group. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesEnableIPv6"
     *         >Enable IPv6</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final Boolean ipv6Enabled() {
        return ipv6Enabled;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header that you received when retrieving the connection group that you're
     * updating.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header that you received when retrieving the connection group that
     *         you're updating.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * <p>
     * The ID of the Anycast static IP list.
     * </p>
     * 
     * @return The ID of the Anycast static IP list.
     */
    public final String anycastIpListId() {
        return anycastIpListId;
    }

    /**
     * <p>
     * Whether the connection group is enabled.
     * </p>
     * 
     * @return Whether the connection group is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(anycastIpListId());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionGroupRequest)) {
            return false;
        }
        UpdateConnectionGroupRequest other = (UpdateConnectionGroupRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ipv6Enabled(), other.ipv6Enabled())
                && Objects.equals(ifMatch(), other.ifMatch()) && Objects.equals(anycastIpListId(), other.anycastIpListId())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionGroupRequest").add("Id", id()).add("Ipv6Enabled", ipv6Enabled())
                .add("IfMatch", ifMatch()).add("AnycastIpListId", anycastIpListId()).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Ipv6Enabled":
            return Optional.ofNullable(clazz.cast(ipv6Enabled()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "AnycastIpListId":
            return Optional.ofNullable(clazz.cast(anycastIpListId()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Ipv6Enabled", IPV6_ENABLED_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionGroupRequest, T> g) {
        return obj -> g.apply((UpdateConnectionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectionGroupRequest> {
        /**
         * <p>
         * The ID of the connection group.
         * </p>
         * 
         * @param id
         *        The ID of the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Enable IPv6 for the connection group. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesEnableIPv6"
         * >Enable IPv6</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param ipv6Enabled
         *        Enable IPv6 for the connection group. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesEnableIPv6"
         *        >Enable IPv6</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Enabled(Boolean ipv6Enabled);

        /**
         * <p>
         * The value of the <code>ETag</code> header that you received when retrieving the connection group that you're
         * updating.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header that you received when retrieving the connection group that
         *        you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * <p>
         * The ID of the Anycast static IP list.
         * </p>
         * 
         * @param anycastIpListId
         *        The ID of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anycastIpListId(String anycastIpListId);

        /**
         * <p>
         * Whether the connection group is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether the connection group is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String id;

        private Boolean ipv6Enabled;

        private String ifMatch;

        private String anycastIpListId;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionGroupRequest model) {
            super(model);
            id(model.id);
            ipv6Enabled(model.ipv6Enabled);
            ifMatch(model.ifMatch);
            anycastIpListId(model.anycastIpListId);
            enabled(model.enabled);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIpv6Enabled() {
            return ipv6Enabled;
        }

        public final void setIpv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        @Override
        public final Builder ipv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getAnycastIpListId() {
            return anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionGroupRequest build() {
            return new UpdateConnectionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
