/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of parameter values to add to the resource. A parameter is specified as a key-value pair. A valid parameter
 * value must exist for any parameter that is marked as required in the multi-tenant distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterDefinition.Builder, ParameterDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ParameterDefinition::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<ParameterDefinitionSchema> DEFINITION_FIELD = SdkField
            .<ParameterDefinitionSchema> builder(MarshallingType.SDK_POJO)
            .memberName("Definition")
            .getter(getter(ParameterDefinition::definition))
            .setter(setter(Builder::definition))
            .constructor(ParameterDefinitionSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition")
                    .unmarshallLocationName("Definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ParameterDefinitionSchema definition;

    private ParameterDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value that you assigned to the parameter.
     * </p>
     * 
     * @return The value that you assigned to the parameter.
     */
    public final ParameterDefinitionSchema definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterDefinition").add("Name", name()).add("Definition", definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParameterDefinition, T> g) {
        return obj -> g.apply((ParameterDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterDefinition> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param name
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value that you assigned to the parameter.
         * </p>
         * 
         * @param definition
         *        The value that you assigned to the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(ParameterDefinitionSchema definition);

        /**
         * <p>
         * The value that you assigned to the parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterDefinitionSchema.Builder}
         * avoiding the need to create one manually via {@link ParameterDefinitionSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterDefinitionSchema.Builder#build()} is called immediately
         * and its result is passed to {@link #definition(ParameterDefinitionSchema)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link ParameterDefinitionSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(ParameterDefinitionSchema)
         */
        default Builder definition(Consumer<ParameterDefinitionSchema.Builder> definition) {
            return definition(ParameterDefinitionSchema.builder().applyMutation(definition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ParameterDefinitionSchema definition;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDefinition model) {
            name(model.name);
            definition(model.definition);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ParameterDefinitionSchema.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(ParameterDefinitionSchema.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(ParameterDefinitionSchema definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public ParameterDefinition build() {
            return new ParameterDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
