/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsByVpcOriginIdRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListDistributionsByVpcOriginIdRequest.Builder, ListDistributionsByVpcOriginIdRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListDistributionsByVpcOriginIdRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListDistributionsByVpcOriginIdRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> VPC_ORIGIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VpcOriginId")
            .getter(getter(ListDistributionsByVpcOriginIdRequest::vpcOriginId))
            .setter(setter(Builder::vpcOriginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VpcOriginId")
                    .unmarshallLocationName("VpcOriginId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD,
            VPC_ORIGIN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final String maxItems;

    private final String vpcOriginId;

    private ListDistributionsByVpcOriginIdRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.vpcOriginId = builder.vpcOriginId;
    }

    /**
     * <p>
     * The marker associated with the VPC origin distributions list.
     * </p>
     * 
     * @return The marker associated with the VPC origin distributions list.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of items included in the list.
     * </p>
     * 
     * @return The maximum number of items included in the list.
     */
    public final String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The VPC origin ID.
     * </p>
     * 
     * @return The VPC origin ID.
     */
    public final String vpcOriginId() {
        return vpcOriginId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOriginId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByVpcOriginIdRequest)) {
            return false;
        }
        ListDistributionsByVpcOriginIdRequest other = (ListDistributionsByVpcOriginIdRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(vpcOriginId(), other.vpcOriginId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributionsByVpcOriginIdRequest").add("Marker", marker()).add("MaxItems", maxItems())
                .add("VpcOriginId", vpcOriginId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "VpcOriginId":
            return Optional.ofNullable(clazz.cast(vpcOriginId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("VpcOriginId", VPC_ORIGIN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByVpcOriginIdRequest, T> g) {
        return obj -> g.apply((ListDistributionsByVpcOriginIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionsByVpcOriginIdRequest> {
        /**
         * <p>
         * The marker associated with the VPC origin distributions list.
         * </p>
         * 
         * @param marker
         *        The marker associated with the VPC origin distributions list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of items included in the list.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of items included in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * The VPC origin ID.
         * </p>
         * 
         * @param vpcOriginId
         *        The VPC origin ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOriginId(String vpcOriginId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private String vpcOriginId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByVpcOriginIdRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
            vpcOriginId(model.vpcOriginId);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getVpcOriginId() {
            return vpcOriginId;
        }

        public final void setVpcOriginId(String vpcOriginId) {
            this.vpcOriginId = vpcOriginId;
        }

        @Override
        public final Builder vpcOriginId(String vpcOriginId) {
            this.vpcOriginId = vpcOriginId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByVpcOriginIdRequest build() {
            return new ListDistributionsByVpcOriginIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
