/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionTenantsByCustomizationResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListDistributionTenantsByCustomizationResponse.Builder, ListDistributionTenantsByCustomizationResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(ListDistributionTenantsByCustomizationResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<List<DistributionTenantSummary>> DISTRIBUTION_TENANT_LIST_FIELD = SdkField
            .<List<DistributionTenantSummary>> builder(MarshallingType.LIST)
            .memberName("DistributionTenantList")
            .getter(getter(ListDistributionTenantsByCustomizationResponse::distributionTenantList))
            .setter(setter(Builder::distributionTenantList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionTenantList")
                    .unmarshallLocationName("DistributionTenantList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DistributionTenantSummary")
                            .memberFieldInfo(
                                    SdkField.<DistributionTenantSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DistributionTenantSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DistributionTenantSummary")
                                                    .unmarshallLocationName("DistributionTenantSummary").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            DISTRIBUTION_TENANT_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextMarker;

    private final List<DistributionTenantSummary> distributionTenantList;

    private ListDistributionTenantsByCustomizationResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.distributionTenantList = builder.distributionTenantList;
    }

    /**
     * <p>
     * A token used for pagination of results returned in the response. You can use the token from the previous request
     * to define where the current request should begin.
     * </p>
     * 
     * @return A token used for pagination of results returned in the response. You can use the token from the previous
     *         request to define where the current request should begin.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the DistributionTenantList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDistributionTenantList() {
        return distributionTenantList != null && !(distributionTenantList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of distribution tenants with the specified customization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDistributionTenantList} method.
     * </p>
     * 
     * @return A list of distribution tenants with the specified customization.
     */
    public final List<DistributionTenantSummary> distributionTenantList() {
        return distributionTenantList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDistributionTenantList() ? distributionTenantList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionTenantsByCustomizationResponse)) {
            return false;
        }
        ListDistributionTenantsByCustomizationResponse other = (ListDistributionTenantsByCustomizationResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker())
                && hasDistributionTenantList() == other.hasDistributionTenantList()
                && Objects.equals(distributionTenantList(), other.distributionTenantList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributionTenantsByCustomizationResponse").add("NextMarker", nextMarker())
                .add("DistributionTenantList", hasDistributionTenantList() ? distributionTenantList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "DistributionTenantList":
            return Optional.ofNullable(clazz.cast(distributionTenantList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("DistributionTenantList", DISTRIBUTION_TENANT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionTenantsByCustomizationResponse, T> g) {
        return obj -> g.apply((ListDistributionTenantsByCustomizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionTenantsByCustomizationResponse> {
        /**
         * <p>
         * A token used for pagination of results returned in the response. You can use the token from the previous
         * request to define where the current request should begin.
         * </p>
         * 
         * @param nextMarker
         *        A token used for pagination of results returned in the response. You can use the token from the
         *        previous request to define where the current request should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * A list of distribution tenants with the specified customization.
         * </p>
         * 
         * @param distributionTenantList
         *        A list of distribution tenants with the specified customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionTenantList(Collection<DistributionTenantSummary> distributionTenantList);

        /**
         * <p>
         * A list of distribution tenants with the specified customization.
         * </p>
         * 
         * @param distributionTenantList
         *        A list of distribution tenants with the specified customization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionTenantList(DistributionTenantSummary... distributionTenantList);

        /**
         * <p>
         * A list of distribution tenants with the specified customization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #distributionTenantList(List<DistributionTenantSummary>)}.
         * 
         * @param distributionTenantList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionTenantList(java.util.Collection<DistributionTenantSummary>)
         */
        Builder distributionTenantList(Consumer<DistributionTenantSummary.Builder>... distributionTenantList);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<DistributionTenantSummary> distributionTenantList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionTenantsByCustomizationResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            distributionTenantList(model.distributionTenantList);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<DistributionTenantSummary.Builder> getDistributionTenantList() {
            List<DistributionTenantSummary.Builder> result = DistributionTenantListCopier
                    .copyToBuilder(this.distributionTenantList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistributionTenantList(Collection<DistributionTenantSummary.BuilderImpl> distributionTenantList) {
            this.distributionTenantList = DistributionTenantListCopier.copyFromBuilder(distributionTenantList);
        }

        @Override
        public final Builder distributionTenantList(Collection<DistributionTenantSummary> distributionTenantList) {
            this.distributionTenantList = DistributionTenantListCopier.copy(distributionTenantList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributionTenantList(DistributionTenantSummary... distributionTenantList) {
            distributionTenantList(Arrays.asList(distributionTenantList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributionTenantList(Consumer<DistributionTenantSummary.Builder>... distributionTenantList) {
            distributionTenantList(Stream.of(distributionTenantList)
                    .map(c -> DistributionTenantSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDistributionTenantsByCustomizationResponse build() {
            return new ListDistributionTenantsByCustomizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
