/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a field-level encryption item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldLevelEncryptionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldLevelEncryptionSummary.Builder, FieldLevelEncryptionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(FieldLevelEncryptionSummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(FieldLevelEncryptionSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(FieldLevelEncryptionSummary::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<QueryArgProfileConfig> QUERY_ARG_PROFILE_CONFIG_FIELD = SdkField
            .<QueryArgProfileConfig> builder(MarshallingType.SDK_POJO)
            .memberName("QueryArgProfileConfig")
            .getter(getter(FieldLevelEncryptionSummary::queryArgProfileConfig))
            .setter(setter(Builder::queryArgProfileConfig))
            .constructor(QueryArgProfileConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArgProfileConfig")
                    .unmarshallLocationName("QueryArgProfileConfig").build()).build();

    private static final SdkField<ContentTypeProfileConfig> CONTENT_TYPE_PROFILE_CONFIG_FIELD = SdkField
            .<ContentTypeProfileConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ContentTypeProfileConfig")
            .getter(getter(FieldLevelEncryptionSummary::contentTypeProfileConfig))
            .setter(setter(Builder::contentTypeProfileConfig))
            .constructor(ContentTypeProfileConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypeProfileConfig")
                    .unmarshallLocationName("ContentTypeProfileConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LAST_MODIFIED_TIME_FIELD, COMMENT_FIELD, QUERY_ARG_PROFILE_CONFIG_FIELD, CONTENT_TYPE_PROFILE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant lastModifiedTime;

    private final String comment;

    private final QueryArgProfileConfig queryArgProfileConfig;

    private final ContentTypeProfileConfig contentTypeProfileConfig;

    private FieldLevelEncryptionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.comment = builder.comment;
        this.queryArgProfileConfig = builder.queryArgProfileConfig;
        this.contentTypeProfileConfig = builder.contentTypeProfileConfig;
    }

    /**
     * <p>
     * The unique ID of a field-level encryption item.
     * </p>
     * 
     * @return The unique ID of a field-level encryption item.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The last time that the summary of field-level encryption items was modified.
     * </p>
     * 
     * @return The last time that the summary of field-level encryption items was modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * An optional comment about the field-level encryption item. The comment cannot be longer than 128 characters.
     * </p>
     * 
     * @return An optional comment about the field-level encryption item. The comment cannot be longer than 128
     *         characters.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A summary of a query argument-profile mapping.
     * </p>
     * 
     * @return A summary of a query argument-profile mapping.
     */
    public final QueryArgProfileConfig queryArgProfileConfig() {
        return queryArgProfileConfig;
    }

    /**
     * <p>
     * A summary of a content type-profile mapping.
     * </p>
     * 
     * @return A summary of a content type-profile mapping.
     */
    public final ContentTypeProfileConfig contentTypeProfileConfig() {
        return contentTypeProfileConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(queryArgProfileConfig());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeProfileConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLevelEncryptionSummary)) {
            return false;
        }
        FieldLevelEncryptionSummary other = (FieldLevelEncryptionSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(comment(), other.comment())
                && Objects.equals(queryArgProfileConfig(), other.queryArgProfileConfig())
                && Objects.equals(contentTypeProfileConfig(), other.contentTypeProfileConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldLevelEncryptionSummary").add("Id", id()).add("LastModifiedTime", lastModifiedTime())
                .add("Comment", comment()).add("QueryArgProfileConfig", queryArgProfileConfig())
                .add("ContentTypeProfileConfig", contentTypeProfileConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "QueryArgProfileConfig":
            return Optional.ofNullable(clazz.cast(queryArgProfileConfig()));
        case "ContentTypeProfileConfig":
            return Optional.ofNullable(clazz.cast(contentTypeProfileConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("QueryArgProfileConfig", QUERY_ARG_PROFILE_CONFIG_FIELD);
        map.put("ContentTypeProfileConfig", CONTENT_TYPE_PROFILE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldLevelEncryptionSummary, T> g) {
        return obj -> g.apply((FieldLevelEncryptionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldLevelEncryptionSummary> {
        /**
         * <p>
         * The unique ID of a field-level encryption item.
         * </p>
         * 
         * @param id
         *        The unique ID of a field-level encryption item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The last time that the summary of field-level encryption items was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time that the summary of field-level encryption items was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * An optional comment about the field-level encryption item. The comment cannot be longer than 128 characters.
         * </p>
         * 
         * @param comment
         *        An optional comment about the field-level encryption item. The comment cannot be longer than 128
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A summary of a query argument-profile mapping.
         * </p>
         * 
         * @param queryArgProfileConfig
         *        A summary of a query argument-profile mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryArgProfileConfig(QueryArgProfileConfig queryArgProfileConfig);

        /**
         * <p>
         * A summary of a query argument-profile mapping.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryArgProfileConfig.Builder} avoiding
         * the need to create one manually via {@link QueryArgProfileConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryArgProfileConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #queryArgProfileConfig(QueryArgProfileConfig)}.
         * 
         * @param queryArgProfileConfig
         *        a consumer that will call methods on {@link QueryArgProfileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryArgProfileConfig(QueryArgProfileConfig)
         */
        default Builder queryArgProfileConfig(Consumer<QueryArgProfileConfig.Builder> queryArgProfileConfig) {
            return queryArgProfileConfig(QueryArgProfileConfig.builder().applyMutation(queryArgProfileConfig).build());
        }

        /**
         * <p>
         * A summary of a content type-profile mapping.
         * </p>
         * 
         * @param contentTypeProfileConfig
         *        A summary of a content type-profile mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentTypeProfileConfig(ContentTypeProfileConfig contentTypeProfileConfig);

        /**
         * <p>
         * A summary of a content type-profile mapping.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentTypeProfileConfig.Builder}
         * avoiding the need to create one manually via {@link ContentTypeProfileConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentTypeProfileConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #contentTypeProfileConfig(ContentTypeProfileConfig)}.
         * 
         * @param contentTypeProfileConfig
         *        a consumer that will call methods on {@link ContentTypeProfileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentTypeProfileConfig(ContentTypeProfileConfig)
         */
        default Builder contentTypeProfileConfig(Consumer<ContentTypeProfileConfig.Builder> contentTypeProfileConfig) {
            return contentTypeProfileConfig(ContentTypeProfileConfig.builder().applyMutation(contentTypeProfileConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant lastModifiedTime;

        private String comment;

        private QueryArgProfileConfig queryArgProfileConfig;

        private ContentTypeProfileConfig contentTypeProfileConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldLevelEncryptionSummary model) {
            id(model.id);
            lastModifiedTime(model.lastModifiedTime);
            comment(model.comment);
            queryArgProfileConfig(model.queryArgProfileConfig);
            contentTypeProfileConfig(model.contentTypeProfileConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final QueryArgProfileConfig.Builder getQueryArgProfileConfig() {
            return queryArgProfileConfig != null ? queryArgProfileConfig.toBuilder() : null;
        }

        public final void setQueryArgProfileConfig(QueryArgProfileConfig.BuilderImpl queryArgProfileConfig) {
            this.queryArgProfileConfig = queryArgProfileConfig != null ? queryArgProfileConfig.build() : null;
        }

        @Override
        public final Builder queryArgProfileConfig(QueryArgProfileConfig queryArgProfileConfig) {
            this.queryArgProfileConfig = queryArgProfileConfig;
            return this;
        }

        public final ContentTypeProfileConfig.Builder getContentTypeProfileConfig() {
            return contentTypeProfileConfig != null ? contentTypeProfileConfig.toBuilder() : null;
        }

        public final void setContentTypeProfileConfig(ContentTypeProfileConfig.BuilderImpl contentTypeProfileConfig) {
            this.contentTypeProfileConfig = contentTypeProfileConfig != null ? contentTypeProfileConfig.build() : null;
        }

        @Override
        public final Builder contentTypeProfileConfig(ContentTypeProfileConfig contentTypeProfileConfig) {
            this.contentTypeProfileConfig = contentTypeProfileConfig;
            return this;
        }

        @Override
        public FieldLevelEncryptionSummary build() {
            return new FieldLevelEncryptionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
