/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainAssociationRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateDomainAssociationRequest.Builder, UpdateDomainAssociationRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Domain")
            .getter(getter(UpdateDomainAssociationRequest::domain))
            .setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain")
                    .unmarshallLocationName("Domain").build()).build();

    private static final SdkField<DistributionResourceId> TARGET_RESOURCE_FIELD = SdkField
            .<DistributionResourceId> builder(MarshallingType.SDK_POJO)
            .memberName("TargetResource")
            .getter(getter(UpdateDomainAssociationRequest::targetResource))
            .setter(setter(Builder::targetResource))
            .constructor(DistributionResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResource")
                    .unmarshallLocationName("TargetResource").build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateDomainAssociationRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            TARGET_RESOURCE_FIELD, IF_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domain;

    private final DistributionResourceId targetResource;

    private final String ifMatch;

    private UpdateDomainAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.targetResource = builder.targetResource;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The domain to update.
     * </p>
     * 
     * @return The domain to update.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The target distribution resource for the domain. You can specify either <code>DistributionId</code> or
     * <code>DistributionTenantId</code>, but not both.
     * </p>
     * 
     * @return The target distribution resource for the domain. You can specify either <code>DistributionId</code> or
     *         <code>DistributionTenantId</code>, but not both.
     */
    public final DistributionResourceId targetResource() {
        return targetResource;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> identifier for the distribution or distribution tenant that will be associated
     * with the domain.
     * </p>
     * 
     * @return The value of the <code>ETag</code> identifier for the distribution or distribution tenant that will be
     *         associated with the domain.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainAssociationRequest)) {
            return false;
        }
        UpdateDomainAssociationRequest other = (UpdateDomainAssociationRequest) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(targetResource(), other.targetResource())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainAssociationRequest").add("Domain", domain()).add("TargetResource", targetResource())
                .add("IfMatch", ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "TargetResource":
            return Optional.ofNullable(clazz.cast(targetResource()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("TargetResource", TARGET_RESOURCE_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainAssociationRequest, T> g) {
        return obj -> g.apply((UpdateDomainAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainAssociationRequest> {
        /**
         * <p>
         * The domain to update.
         * </p>
         * 
         * @param domain
         *        The domain to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The target distribution resource for the domain. You can specify either <code>DistributionId</code> or
         * <code>DistributionTenantId</code>, but not both.
         * </p>
         * 
         * @param targetResource
         *        The target distribution resource for the domain. You can specify either <code>DistributionId</code> or
         *        <code>DistributionTenantId</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResource(DistributionResourceId targetResource);

        /**
         * <p>
         * The target distribution resource for the domain. You can specify either <code>DistributionId</code> or
         * <code>DistributionTenantId</code>, but not both.
         * </p>
         * This is a convenience method that creates an instance of the {@link DistributionResourceId.Builder} avoiding
         * the need to create one manually via {@link DistributionResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DistributionResourceId.Builder#build()} is called immediately and
         * its result is passed to {@link #targetResource(DistributionResourceId)}.
         * 
         * @param targetResource
         *        a consumer that will call methods on {@link DistributionResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResource(DistributionResourceId)
         */
        default Builder targetResource(Consumer<DistributionResourceId.Builder> targetResource) {
            return targetResource(DistributionResourceId.builder().applyMutation(targetResource).build());
        }

        /**
         * <p>
         * The value of the <code>ETag</code> identifier for the distribution or distribution tenant that will be
         * associated with the domain.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> identifier for the distribution or distribution tenant that will be
         *        associated with the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String domain;

        private DistributionResourceId targetResource;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainAssociationRequest model) {
            super(model);
            domain(model.domain);
            targetResource(model.targetResource);
            ifMatch(model.ifMatch);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final DistributionResourceId.Builder getTargetResource() {
            return targetResource != null ? targetResource.toBuilder() : null;
        }

        public final void setTargetResource(DistributionResourceId.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(DistributionResourceId targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainAssociationRequest build() {
            return new UpdateDomainAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
