/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the validation token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationTokenDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationTokenDetail.Builder, ValidationTokenDetail> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Domain")
            .getter(getter(ValidationTokenDetail::domain))
            .setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain")
                    .unmarshallLocationName("Domain").build()).build();

    private static final SdkField<String> REDIRECT_TO_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RedirectTo")
            .getter(getter(ValidationTokenDetail::redirectTo))
            .setter(setter(Builder::redirectTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectTo")
                    .unmarshallLocationName("RedirectTo").build()).build();

    private static final SdkField<String> REDIRECT_FROM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RedirectFrom")
            .getter(getter(ValidationTokenDetail::redirectFrom))
            .setter(setter(Builder::redirectFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectFrom")
                    .unmarshallLocationName("RedirectFrom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD,
            REDIRECT_TO_FIELD, REDIRECT_FROM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String redirectTo;

    private final String redirectFrom;

    private ValidationTokenDetail(BuilderImpl builder) {
        this.domain = builder.domain;
        this.redirectTo = builder.redirectTo;
        this.redirectFrom = builder.redirectFrom;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The domain to redirect to.
     * </p>
     * 
     * @return The domain to redirect to.
     */
    public final String redirectTo() {
        return redirectTo;
    }

    /**
     * <p>
     * The domain to redirect from.
     * </p>
     * 
     * @return The domain to redirect from.
     */
    public final String redirectFrom() {
        return redirectFrom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(redirectTo());
        hashCode = 31 * hashCode + Objects.hashCode(redirectFrom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationTokenDetail)) {
            return false;
        }
        ValidationTokenDetail other = (ValidationTokenDetail) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(redirectTo(), other.redirectTo())
                && Objects.equals(redirectFrom(), other.redirectFrom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationTokenDetail").add("Domain", domain()).add("RedirectTo", redirectTo())
                .add("RedirectFrom", redirectFrom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "RedirectTo":
            return Optional.ofNullable(clazz.cast(redirectTo()));
        case "RedirectFrom":
            return Optional.ofNullable(clazz.cast(redirectFrom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("RedirectTo", REDIRECT_TO_FIELD);
        map.put("RedirectFrom", REDIRECT_FROM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationTokenDetail, T> g) {
        return obj -> g.apply((ValidationTokenDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationTokenDetail> {
        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domain
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The domain to redirect to.
         * </p>
         * 
         * @param redirectTo
         *        The domain to redirect to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectTo(String redirectTo);

        /**
         * <p>
         * The domain to redirect from.
         * </p>
         * 
         * @param redirectFrom
         *        The domain to redirect from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectFrom(String redirectFrom);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String redirectTo;

        private String redirectFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationTokenDetail model) {
            domain(model.domain);
            redirectTo(model.redirectTo);
            redirectFrom(model.redirectFrom);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getRedirectTo() {
            return redirectTo;
        }

        public final void setRedirectTo(String redirectTo) {
            this.redirectTo = redirectTo;
        }

        @Override
        public final Builder redirectTo(String redirectTo) {
            this.redirectTo = redirectTo;
            return this;
        }

        public final String getRedirectFrom() {
            return redirectFrom;
        }

        public final void setRedirectFrom(String redirectFrom) {
            this.redirectFrom = redirectFrom;
        }

        @Override
        public final Builder redirectFrom(String redirectFrom) {
            this.redirectFrom = redirectFrom;
            return this;
        }

        @Override
        public ValidationTokenDetail build() {
            return new ValidationTokenDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
