/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.DnsConfiguration;
import software.amazon.awssdk.services.cloudfront.model.DnsConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyDnsConfigurationResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, VerifyDnsConfigurationResponse> {
    private static final SdkField<List<DnsConfiguration>> DNS_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsConfigurationList").getter(VerifyDnsConfigurationResponse.getter(VerifyDnsConfigurationResponse::dnsConfigurationList)).setter(VerifyDnsConfigurationResponse.setter(Builder::dnsConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsConfigurationList").unmarshallLocationName("DnsConfigurationList").build(), ListTrait.builder().memberLocationName("DnsConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DnsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsConfiguration").unmarshallLocationName("DnsConfiguration").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_CONFIGURATION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifyDnsConfigurationResponse.memberNameToFieldInitializer();
    private final List<DnsConfiguration> dnsConfigurationList;

    private VerifyDnsConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.dnsConfigurationList = builder.dnsConfigurationList;
    }

    public final boolean hasDnsConfigurationList() {
        return this.dnsConfigurationList != null && !(this.dnsConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<DnsConfiguration> dnsConfigurationList() {
        return this.dnsConfigurationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsConfigurationList() ? this.dnsConfigurationList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDnsConfigurationResponse)) {
            return false;
        }
        VerifyDnsConfigurationResponse other = (VerifyDnsConfigurationResponse)((Object)obj);
        return this.hasDnsConfigurationList() == other.hasDnsConfigurationList() && Objects.equals(this.dnsConfigurationList(), other.dnsConfigurationList());
    }

    public final String toString() {
        return ToString.builder((String)"VerifyDnsConfigurationResponse").add("DnsConfigurationList", this.hasDnsConfigurationList() ? this.dnsConfigurationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.dnsConfigurationList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DnsConfiguration>>> map = new HashMap<String, SdkField<List<DnsConfiguration>>>();
        map.put("DnsConfigurationList", DNS_CONFIGURATION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifyDnsConfigurationResponse, T> g) {
        return obj -> g.apply((VerifyDnsConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private List<DnsConfiguration> dnsConfigurationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDnsConfigurationResponse model) {
            super(model);
            this.dnsConfigurationList(model.dnsConfigurationList);
        }

        public final List<DnsConfiguration.Builder> getDnsConfigurationList() {
            List<DnsConfiguration.Builder> result = DnsConfigurationListCopier.copyToBuilder(this.dnsConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDnsConfigurationList(Collection<DnsConfiguration.BuilderImpl> dnsConfigurationList) {
            this.dnsConfigurationList = DnsConfigurationListCopier.copyFromBuilder(dnsConfigurationList);
        }

        @Override
        public final Builder dnsConfigurationList(Collection<DnsConfiguration> dnsConfigurationList) {
            this.dnsConfigurationList = DnsConfigurationListCopier.copy(dnsConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsConfigurationList(DnsConfiguration ... dnsConfigurationList) {
            this.dnsConfigurationList(Arrays.asList(dnsConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsConfigurationList(Consumer<DnsConfiguration.Builder> ... dnsConfigurationList) {
            this.dnsConfigurationList(Stream.of(dnsConfigurationList).map(c -> (DnsConfiguration)((DnsConfiguration.Builder)DnsConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public VerifyDnsConfigurationResponse build() {
            return new VerifyDnsConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyDnsConfigurationResponse> {
        public Builder dnsConfigurationList(Collection<DnsConfiguration> var1);

        public Builder dnsConfigurationList(DnsConfiguration ... var1);

        public Builder dnsConfigurationList(Consumer<DnsConfiguration.Builder> ... var1);
    }
}

