/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.DistributionResourceId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainAssociationRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateDomainAssociationRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::domain)).setter(UpdateDomainAssociationRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").unmarshallLocationName("Domain").build()}).build();
    private static final SdkField<DistributionResourceId> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetResource").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::targetResource)).setter(UpdateDomainAssociationRequest.setter(Builder::targetResource)).constructor(DistributionResourceId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetResource").unmarshallLocationName("TargetResource").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(UpdateDomainAssociationRequest.getter(UpdateDomainAssociationRequest::ifMatch)).setter(UpdateDomainAssociationRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, TARGET_RESOURCE_FIELD, IF_MATCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDomainAssociationRequest.memberNameToFieldInitializer();
    private final String domain;
    private final DistributionResourceId targetResource;
    private final String ifMatch;

    private UpdateDomainAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.targetResource = builder.targetResource;
        this.ifMatch = builder.ifMatch;
    }

    public final String domain() {
        return this.domain;
    }

    public final DistributionResourceId targetResource() {
        return this.targetResource;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainAssociationRequest)) {
            return false;
        }
        UpdateDomainAssociationRequest other = (UpdateDomainAssociationRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.targetResource(), other.targetResource()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainAssociationRequest").add("Domain", (Object)this.domain()).add("TargetResource", (Object)this.targetResource()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "TargetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("TargetResource", TARGET_RESOURCE_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainAssociationRequest, T> g) {
        return obj -> g.apply((UpdateDomainAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String domain;
        private DistributionResourceId targetResource;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainAssociationRequest model) {
            super(model);
            this.domain(model.domain);
            this.targetResource(model.targetResource);
            this.ifMatch(model.ifMatch);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final DistributionResourceId.Builder getTargetResource() {
            return this.targetResource != null ? this.targetResource.toBuilder() : null;
        }

        public final void setTargetResource(DistributionResourceId.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(DistributionResourceId targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainAssociationRequest build() {
            return new UpdateDomainAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainAssociationRequest> {
        public Builder domain(String var1);

        public Builder targetResource(DistributionResourceId var1);

        default public Builder targetResource(Consumer<DistributionResourceId.Builder> targetResource) {
            return this.targetResource((DistributionResourceId)((DistributionResourceId.Builder)DistributionResourceId.builder().applyMutation(targetResource)).build());
        }

        public Builder ifMatch(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

