/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.DomainConflict;
import software.amazon.awssdk.services.cloudfront.model.DomainConflictsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainConflictsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListDomainConflictsResponse> {
    private static final SdkField<List<DomainConflict>> DOMAIN_CONFLICTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainConflicts").getter(ListDomainConflictsResponse.getter(ListDomainConflictsResponse::domainConflicts)).setter(ListDomainConflictsResponse.setter(Builder::domainConflicts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainConflicts").unmarshallLocationName("DomainConflicts").build(), ListTrait.builder().memberLocationName("DomainConflicts").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainConflict::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainConflicts").unmarshallLocationName("DomainConflicts").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListDomainConflictsResponse.getter(ListDomainConflictsResponse::nextMarker)).setter(ListDomainConflictsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFLICTS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDomainConflictsResponse.memberNameToFieldInitializer();
    private final List<DomainConflict> domainConflicts;
    private final String nextMarker;

    private ListDomainConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.domainConflicts = builder.domainConflicts;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasDomainConflicts() {
        return this.domainConflicts != null && !(this.domainConflicts instanceof SdkAutoConstructList);
    }

    public final List<DomainConflict> domainConflicts() {
        return this.domainConflicts;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainConflicts() ? this.domainConflicts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainConflictsResponse)) {
            return false;
        }
        ListDomainConflictsResponse other = (ListDomainConflictsResponse)((Object)obj);
        return this.hasDomainConflicts() == other.hasDomainConflicts() && Objects.equals(this.domainConflicts(), other.domainConflicts()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainConflictsResponse").add("DomainConflicts", this.hasDomainConflicts() ? this.domainConflicts() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainConflicts": {
                return Optional.ofNullable(clazz.cast(this.domainConflicts()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainConflicts", DOMAIN_CONFLICTS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDomainConflictsResponse, T> g) {
        return obj -> g.apply((ListDomainConflictsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private List<DomainConflict> domainConflicts = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainConflictsResponse model) {
            super(model);
            this.domainConflicts(model.domainConflicts);
            this.nextMarker(model.nextMarker);
        }

        public final List<DomainConflict.Builder> getDomainConflicts() {
            List<DomainConflict.Builder> result = DomainConflictsListCopier.copyToBuilder(this.domainConflicts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainConflicts(Collection<DomainConflict.BuilderImpl> domainConflicts) {
            this.domainConflicts = DomainConflictsListCopier.copyFromBuilder(domainConflicts);
        }

        @Override
        public final Builder domainConflicts(Collection<DomainConflict> domainConflicts) {
            this.domainConflicts = DomainConflictsListCopier.copy(domainConflicts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainConflicts(DomainConflict ... domainConflicts) {
            this.domainConflicts(Arrays.asList(domainConflicts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainConflicts(Consumer<DomainConflict.Builder> ... domainConflicts) {
            this.domainConflicts(Stream.of(domainConflicts).map(c -> (DomainConflict)((DomainConflict.Builder)DomainConflict.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListDomainConflictsResponse build() {
            return new ListDomainConflictsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainConflictsResponse> {
        public Builder domainConflicts(Collection<DomainConflict> var1);

        public Builder domainConflicts(DomainConflict ... var1);

        public Builder domainConflicts(Consumer<DomainConflict.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

