/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectionGroupRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateConnectionGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConnectionGroupRequest.getter(CreateConnectionGroupRequest::name)).setter(CreateConnectionGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<Boolean> IPV6_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ipv6Enabled").getter(CreateConnectionGroupRequest.getter(CreateConnectionGroupRequest::ipv6Enabled)).setter(CreateConnectionGroupRequest.setter(Builder::ipv6Enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Enabled").unmarshallLocationName("Ipv6Enabled").build()}).build();
    private static final SdkField<Tags> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tags").getter(CreateConnectionGroupRequest.getter(CreateConnectionGroupRequest::tags)).setter(CreateConnectionGroupRequest.setter(Builder::tags)).constructor(Tags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build()}).build();
    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnycastIpListId").getter(CreateConnectionGroupRequest.getter(CreateConnectionGroupRequest::anycastIpListId)).setter(CreateConnectionGroupRequest.setter(Builder::anycastIpListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId").unmarshallLocationName("AnycastIpListId").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CreateConnectionGroupRequest.getter(CreateConnectionGroupRequest::enabled)).setter(CreateConnectionGroupRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IPV6_ENABLED_FIELD, TAGS_FIELD, ANYCAST_IP_LIST_ID_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectionGroupRequest.memberNameToFieldInitializer();
    private final String name;
    private final Boolean ipv6Enabled;
    private final Tags tags;
    private final String anycastIpListId;
    private final Boolean enabled;

    private CreateConnectionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ipv6Enabled = builder.ipv6Enabled;
        this.tags = builder.tags;
        this.anycastIpListId = builder.anycastIpListId;
        this.enabled = builder.enabled;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean ipv6Enabled() {
        return this.ipv6Enabled;
    }

    public final Tags tags() {
        return this.tags;
    }

    public final String anycastIpListId() {
        return this.anycastIpListId;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.anycastIpListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionGroupRequest)) {
            return false;
        }
        CreateConnectionGroupRequest other = (CreateConnectionGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ipv6Enabled(), other.ipv6Enabled()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.anycastIpListId(), other.anycastIpListId()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectionGroupRequest").add("Name", (Object)this.name()).add("Ipv6Enabled", (Object)this.ipv6Enabled()).add("Tags", (Object)this.tags()).add("AnycastIpListId", (Object)this.anycastIpListId()).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Ipv6Enabled": {
                return Optional.ofNullable(clazz.cast(this.ipv6Enabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AnycastIpListId": {
                return Optional.ofNullable(clazz.cast(this.anycastIpListId()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Ipv6Enabled", IPV6_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionGroupRequest, T> g) {
        return obj -> g.apply((CreateConnectionGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String name;
        private Boolean ipv6Enabled;
        private Tags tags;
        private String anycastIpListId;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionGroupRequest model) {
            super(model);
            this.name(model.name);
            this.ipv6Enabled(model.ipv6Enabled);
            this.tags(model.tags);
            this.anycastIpListId(model.anycastIpListId);
            this.enabled(model.enabled);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        public final void setIpv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        @Override
        public final Builder ipv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
            return this;
        }

        public final Tags.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final String getAnycastIpListId() {
            return this.anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionGroupRequest build() {
            return new CreateConnectionGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectionGroupRequest> {
        public Builder name(String var1);

        public Builder ipv6Enabled(Boolean var1);

        public Builder tags(Tags var1);

        default public Builder tags(Consumer<Tags.Builder> tags) {
            return this.tags((Tags)((Tags.Builder)Tags.builder().applyMutation(tags)).build());
        }

        public Builder anycastIpListId(String var1);

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

