/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamingDistributionsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListStreamingDistributionsResponse> {
    private static final SdkField<StreamingDistributionList> STREAMING_DISTRIBUTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingDistributionList").getter(ListStreamingDistributionsResponse.getter(ListStreamingDistributionsResponse::streamingDistributionList)).setter(ListStreamingDistributionsResponse.setter(Builder::streamingDistributionList)).constructor(StreamingDistributionList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistributionList").unmarshallLocationName("StreamingDistributionList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_DISTRIBUTION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStreamingDistributionsResponse.memberNameToFieldInitializer();
    private final StreamingDistributionList streamingDistributionList;

    private ListStreamingDistributionsResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistributionList = builder.streamingDistributionList;
    }

    public final StreamingDistributionList streamingDistributionList() {
        return this.streamingDistributionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingDistributionList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingDistributionsResponse)) {
            return false;
        }
        ListStreamingDistributionsResponse other = (ListStreamingDistributionsResponse)((Object)obj);
        return Objects.equals(this.streamingDistributionList(), other.streamingDistributionList());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamingDistributionsResponse").add("StreamingDistributionList", (Object)this.streamingDistributionList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingDistributionList": {
                return Optional.ofNullable(clazz.cast(this.streamingDistributionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<StreamingDistributionList>> map = new HashMap<String, SdkField<StreamingDistributionList>>();
        map.put("StreamingDistributionList", STREAMING_DISTRIBUTION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingDistributionsResponse, T> g) {
        return obj -> g.apply((ListStreamingDistributionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private StreamingDistributionList streamingDistributionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingDistributionsResponse model) {
            super(model);
            this.streamingDistributionList(model.streamingDistributionList);
        }

        public final StreamingDistributionList.Builder getStreamingDistributionList() {
            return this.streamingDistributionList != null ? this.streamingDistributionList.toBuilder() : null;
        }

        public final void setStreamingDistributionList(StreamingDistributionList.BuilderImpl streamingDistributionList) {
            this.streamingDistributionList = streamingDistributionList != null ? streamingDistributionList.build() : null;
        }

        @Override
        public final Builder streamingDistributionList(StreamingDistributionList streamingDistributionList) {
            this.streamingDistributionList = streamingDistributionList;
            return this;
        }

        @Override
        public ListStreamingDistributionsResponse build() {
            return new ListStreamingDistributionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamingDistributionsResponse> {
        public Builder streamingDistributionList(StreamingDistributionList var1);

        default public Builder streamingDistributionList(Consumer<StreamingDistributionList.Builder> streamingDistributionList) {
            return this.streamingDistributionList((StreamingDistributionList)((StreamingDistributionList.Builder)StreamingDistributionList.builder().applyMutation(streamingDistributionList)).build());
        }
    }
}

