/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOriginAccessControlConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetOriginAccessControlConfigResponse> {
    private static final SdkField<OriginAccessControlConfig> ORIGIN_ACCESS_CONTROL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginAccessControlConfig").getter(GetOriginAccessControlConfigResponse.getter(GetOriginAccessControlConfigResponse::originAccessControlConfig)).setter(GetOriginAccessControlConfigResponse.setter(Builder::originAccessControlConfig)).constructor(OriginAccessControlConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlConfig").unmarshallLocationName("OriginAccessControlConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetOriginAccessControlConfigResponse.getter(GetOriginAccessControlConfigResponse::eTag)).setter(GetOriginAccessControlConfigResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCESS_CONTROL_CONFIG_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOriginAccessControlConfigResponse.memberNameToFieldInitializer();
    private final OriginAccessControlConfig originAccessControlConfig;
    private final String eTag;

    private GetOriginAccessControlConfigResponse(BuilderImpl builder) {
        super(builder);
        this.originAccessControlConfig = builder.originAccessControlConfig;
        this.eTag = builder.eTag;
    }

    public final OriginAccessControlConfig originAccessControlConfig() {
        return this.originAccessControlConfig;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccessControlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOriginAccessControlConfigResponse)) {
            return false;
        }
        GetOriginAccessControlConfigResponse other = (GetOriginAccessControlConfigResponse)((Object)obj);
        return Objects.equals(this.originAccessControlConfig(), other.originAccessControlConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetOriginAccessControlConfigResponse").add("OriginAccessControlConfig", (Object)this.originAccessControlConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginAccessControlConfig": {
                return Optional.ofNullable(clazz.cast(this.originAccessControlConfig()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OriginAccessControlConfig", ORIGIN_ACCESS_CONTROL_CONFIG_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOriginAccessControlConfigResponse, T> g) {
        return obj -> g.apply((GetOriginAccessControlConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private OriginAccessControlConfig originAccessControlConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOriginAccessControlConfigResponse model) {
            super(model);
            this.originAccessControlConfig(model.originAccessControlConfig);
            this.eTag(model.eTag);
        }

        public final OriginAccessControlConfig.Builder getOriginAccessControlConfig() {
            return this.originAccessControlConfig != null ? this.originAccessControlConfig.toBuilder() : null;
        }

        public final void setOriginAccessControlConfig(OriginAccessControlConfig.BuilderImpl originAccessControlConfig) {
            this.originAccessControlConfig = originAccessControlConfig != null ? originAccessControlConfig.build() : null;
        }

        @Override
        public final Builder originAccessControlConfig(OriginAccessControlConfig originAccessControlConfig) {
            this.originAccessControlConfig = originAccessControlConfig;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetOriginAccessControlConfigResponse build() {
            return new GetOriginAccessControlConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOriginAccessControlConfigResponse> {
        public Builder originAccessControlConfig(OriginAccessControlConfig var1);

        default public Builder originAccessControlConfig(Consumer<OriginAccessControlConfig.Builder> originAccessControlConfig) {
            return this.originAccessControlConfig((OriginAccessControlConfig)((OriginAccessControlConfig.Builder)OriginAccessControlConfig.builder().applyMutation(originAccessControlConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

