/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that determines whether any HTTP headers (and if so, which headers) are included in requests that
 * CloudFront sends to the origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginRequestPolicyHeadersConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginRequestPolicyHeadersConfig.Builder, OriginRequestPolicyHeadersConfig> {
    private static final SdkField<String> HEADER_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HeaderBehavior")
            .getter(getter(OriginRequestPolicyHeadersConfig::headerBehaviorAsString))
            .setter(setter(Builder::headerBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderBehavior")
                    .unmarshallLocationName("HeaderBehavior").build()).build();

    private static final SdkField<Headers> HEADERS_FIELD = SdkField
            .<Headers> builder(MarshallingType.SDK_POJO)
            .memberName("Headers")
            .getter(getter(OriginRequestPolicyHeadersConfig::headers))
            .setter(setter(Builder::headers))
            .constructor(Headers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers")
                    .unmarshallLocationName("Headers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_BEHAVIOR_FIELD,
            HEADERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String headerBehavior;

    private final Headers headers;

    private OriginRequestPolicyHeadersConfig(BuilderImpl builder) {
        this.headerBehavior = builder.headerBehavior;
        this.headers = builder.headers;
    }

    /**
     * <p>
     * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends to the
     * origin. Even when this field is set to <code>none</code>, any headers that are listed in a
     * <code>CachePolicy</code> <i>are</i> included in origin requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are included in
     * requests that CloudFront sends to the origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to
     * the origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional CloudFront
     * headers that are listed in the <code>Headers</code> type are included in requests that CloudFront sends to the
     * origin. The additional headers are added by CloudFront.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to
     * the origin, <i> <b>except</b> </i> for those listed in the <code>Headers</code> type, which are not included.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #headerBehavior}
     * will return {@link OriginRequestPolicyHeaderBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #headerBehaviorAsString}.
     * </p>
     * 
     * @return Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends to
     *         the origin. Even when this field is set to <code>none</code>, any headers that are listed in a
     *         <code>CachePolicy</code> <i>are</i> included in origin requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are
     *         included in requests that CloudFront sends to the origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront
     *         sends to the origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional
     *         CloudFront headers that are listed in the <code>Headers</code> type are included in requests that
     *         CloudFront sends to the origin. The additional headers are added by CloudFront.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront
     *         sends to the origin, <i> <b>except</b> </i> for those listed in the <code>Headers</code> type, which are
     *         not included.
     *         </p>
     *         </li>
     * @see OriginRequestPolicyHeaderBehavior
     */
    public final OriginRequestPolicyHeaderBehavior headerBehavior() {
        return OriginRequestPolicyHeaderBehavior.fromValue(headerBehavior);
    }

    /**
     * <p>
     * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends to the
     * origin. Even when this field is set to <code>none</code>, any headers that are listed in a
     * <code>CachePolicy</code> <i>are</i> included in origin requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are included in
     * requests that CloudFront sends to the origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to
     * the origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional CloudFront
     * headers that are listed in the <code>Headers</code> type are included in requests that CloudFront sends to the
     * origin. The additional headers are added by CloudFront.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends to
     * the origin, <i> <b>except</b> </i> for those listed in the <code>Headers</code> type, which are not included.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #headerBehavior}
     * will return {@link OriginRequestPolicyHeaderBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #headerBehaviorAsString}.
     * </p>
     * 
     * @return Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends to
     *         the origin. Even when this field is set to <code>none</code>, any headers that are listed in a
     *         <code>CachePolicy</code> <i>are</i> included in origin requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are
     *         included in requests that CloudFront sends to the origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront
     *         sends to the origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional
     *         CloudFront headers that are listed in the <code>Headers</code> type are included in requests that
     *         CloudFront sends to the origin. The additional headers are added by CloudFront.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront
     *         sends to the origin, <i> <b>except</b> </i> for those listed in the <code>Headers</code> type, which are
     *         not included.
     *         </p>
     *         </li>
     * @see OriginRequestPolicyHeaderBehavior
     */
    public final String headerBehaviorAsString() {
        return headerBehavior;
    }

    /**
     * Returns the value of the Headers property for this object.
     * 
     * @return The value of the Headers property for this object.
     */
    public final Headers headers() {
        return headers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(headerBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginRequestPolicyHeadersConfig)) {
            return false;
        }
        OriginRequestPolicyHeadersConfig other = (OriginRequestPolicyHeadersConfig) obj;
        return Objects.equals(headerBehaviorAsString(), other.headerBehaviorAsString())
                && Objects.equals(headers(), other.headers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginRequestPolicyHeadersConfig").add("HeaderBehavior", headerBehaviorAsString())
                .add("Headers", headers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderBehavior":
            return Optional.ofNullable(clazz.cast(headerBehaviorAsString()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HeaderBehavior", HEADER_BEHAVIOR_FIELD);
        map.put("Headers", HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OriginRequestPolicyHeadersConfig, T> g) {
        return obj -> g.apply((OriginRequestPolicyHeadersConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginRequestPolicyHeadersConfig> {
        /**
         * <p>
         * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends to the
         * origin. Even when this field is set to <code>none</code>, any headers that are listed in a
         * <code>CachePolicy</code> <i>are</i> included in origin requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are included
         * in requests that CloudFront sends to the origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends
         * to the origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional
         * CloudFront headers that are listed in the <code>Headers</code> type are included in requests that CloudFront
         * sends to the origin. The additional headers are added by CloudFront.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends
         * to the origin, <i> <b>except</b> </i> for those listed in the <code>Headers</code> type, which are not
         * included.
         * </p>
         * </li>
         * </ul>
         * 
         * @param headerBehavior
         *        Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
         *        Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends
         *        to the origin. Even when this field is set to <code>none</code>, any headers that are listed in a
         *        <code>CachePolicy</code> <i>are</i> included in origin requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are
         *        included in requests that CloudFront sends to the origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront
         *        sends to the origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional
         *        CloudFront headers that are listed in the <code>Headers</code> type are included in requests that
         *        CloudFront sends to the origin. The additional headers are added by CloudFront.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront
         *        sends to the origin, <i> <b>except</b> </i> for those listed in the <code>Headers</code> type, which
         *        are not included.
         *        </p>
         *        </li>
         * @see OriginRequestPolicyHeaderBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginRequestPolicyHeaderBehavior
         */
        Builder headerBehavior(String headerBehavior);

        /**
         * <p>
         * Determines whether any HTTP headers are included in requests that CloudFront sends to the origin. Valid
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends to the
         * origin. Even when this field is set to <code>none</code>, any headers that are listed in a
         * <code>CachePolicy</code> <i>are</i> included in origin requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are included
         * in requests that CloudFront sends to the origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends
         * to the origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional
         * CloudFront headers that are listed in the <code>Headers</code> type are included in requests that CloudFront
         * sends to the origin. The additional headers are added by CloudFront.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront sends
         * to the origin, <i> <b>except</b> </i> for those listed in the <code>Headers</code> type, which are not
         * included.
         * </p>
         * </li>
         * </ul>
         * 
         * @param headerBehavior
         *        Determines whether any HTTP headers are included in requests that CloudFront sends to the origin.
         *        Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>none</code> – No HTTP headers in viewer requests are included in requests that CloudFront sends
         *        to the origin. Even when this field is set to <code>none</code>, any headers that are listed in a
         *        <code>CachePolicy</code> <i>are</i> included in origin requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>whitelist</code> – Only the HTTP headers that are listed in the <code>Headers</code> type are
         *        included in requests that CloudFront sends to the origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allViewer</code> – All HTTP headers in viewer requests are included in requests that CloudFront
         *        sends to the origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allViewerAndWhitelistCloudFront</code> – All HTTP headers in viewer requests and the additional
         *        CloudFront headers that are listed in the <code>Headers</code> type are included in requests that
         *        CloudFront sends to the origin. The additional headers are added by CloudFront.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allExcept</code> – All HTTP headers in viewer requests are included in requests that CloudFront
         *        sends to the origin, <i> <b>except</b> </i> for those listed in the <code>Headers</code> type, which
         *        are not included.
         *        </p>
         *        </li>
         * @see OriginRequestPolicyHeaderBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginRequestPolicyHeaderBehavior
         */
        Builder headerBehavior(OriginRequestPolicyHeaderBehavior headerBehavior);

        /**
         * Sets the value of the Headers property for this object.
         *
         * @param headers
         *        The new value for the Headers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Headers headers);

        /**
         * Sets the value of the Headers property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Headers.Builder} avoiding the need to
         * create one manually via {@link Headers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Headers.Builder#build()} is called immediately and its result is
         * passed to {@link #headers(Headers)}.
         * 
         * @param headers
         *        a consumer that will call methods on {@link Headers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(Headers)
         */
        default Builder headers(Consumer<Headers.Builder> headers) {
            return headers(Headers.builder().applyMutation(headers).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String headerBehavior;

        private Headers headers;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginRequestPolicyHeadersConfig model) {
            headerBehavior(model.headerBehavior);
            headers(model.headers);
        }

        public final String getHeaderBehavior() {
            return headerBehavior;
        }

        public final void setHeaderBehavior(String headerBehavior) {
            this.headerBehavior = headerBehavior;
        }

        @Override
        public final Builder headerBehavior(String headerBehavior) {
            this.headerBehavior = headerBehavior;
            return this;
        }

        @Override
        public final Builder headerBehavior(OriginRequestPolicyHeaderBehavior headerBehavior) {
            this.headerBehavior(headerBehavior == null ? null : headerBehavior.toString());
            return this;
        }

        public final Headers.Builder getHeaders() {
            return headers != null ? headers.toBuilder() : null;
        }

        public final void setHeaders(Headers.BuilderImpl headers) {
            this.headers = headers != null ? headers.build() : null;
        }

        @Override
        public final Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        @Override
        public OriginRequestPolicyHeadersConfig build() {
            return new OriginRequestPolicyHeadersConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
