/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnycastIpListsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListAnycastIpListsResponse.Builder, ListAnycastIpListsResponse> {
    private static final SdkField<AnycastIpListCollection> ANYCAST_IP_LISTS_FIELD = SdkField
            .<AnycastIpListCollection> builder(MarshallingType.SDK_POJO)
            .memberName("AnycastIpLists")
            .getter(getter(ListAnycastIpListsResponse::anycastIpLists))
            .setter(setter(Builder::anycastIpLists))
            .constructor(AnycastIpListCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListCollection")
                    .unmarshallLocationName("AnycastIpListCollection").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANYCAST_IP_LISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AnycastIpListCollection anycastIpLists;

    private ListAnycastIpListsResponse(BuilderImpl builder) {
        super(builder);
        this.anycastIpLists = builder.anycastIpLists;
    }

    /**
     * <p>
     * Root level tag for the <code>AnycastIpLists</code> parameters.
     * </p>
     * 
     * @return Root level tag for the <code>AnycastIpLists</code> parameters.
     */
    public final AnycastIpListCollection anycastIpLists() {
        return anycastIpLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anycastIpLists());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnycastIpListsResponse)) {
            return false;
        }
        ListAnycastIpListsResponse other = (ListAnycastIpListsResponse) obj;
        return Objects.equals(anycastIpLists(), other.anycastIpLists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnycastIpListsResponse").add("AnycastIpLists", anycastIpLists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnycastIpLists":
            return Optional.ofNullable(clazz.cast(anycastIpLists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnycastIpListCollection", ANYCAST_IP_LISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnycastIpListsResponse, T> g) {
        return obj -> g.apply((ListAnycastIpListsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAnycastIpListsResponse> {
        /**
         * <p>
         * Root level tag for the <code>AnycastIpLists</code> parameters.
         * </p>
         * 
         * @param anycastIpLists
         *        Root level tag for the <code>AnycastIpLists</code> parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anycastIpLists(AnycastIpListCollection anycastIpLists);

        /**
         * <p>
         * Root level tag for the <code>AnycastIpLists</code> parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnycastIpListCollection.Builder} avoiding
         * the need to create one manually via {@link AnycastIpListCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnycastIpListCollection.Builder#build()} is called immediately
         * and its result is passed to {@link #anycastIpLists(AnycastIpListCollection)}.
         * 
         * @param anycastIpLists
         *        a consumer that will call methods on {@link AnycastIpListCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anycastIpLists(AnycastIpListCollection)
         */
        default Builder anycastIpLists(Consumer<AnycastIpListCollection.Builder> anycastIpLists) {
            return anycastIpLists(AnycastIpListCollection.builder().applyMutation(anycastIpLists).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private AnycastIpListCollection anycastIpLists;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnycastIpListsResponse model) {
            super(model);
            anycastIpLists(model.anycastIpLists);
        }

        public final AnycastIpListCollection.Builder getAnycastIpLists() {
            return anycastIpLists != null ? anycastIpLists.toBuilder() : null;
        }

        public final void setAnycastIpLists(AnycastIpListCollection.BuilderImpl anycastIpLists) {
            this.anycastIpLists = anycastIpLists != null ? anycastIpLists.build() : null;
        }

        @Override
        public final Builder anycastIpLists(AnycastIpListCollection anycastIpLists) {
            this.anycastIpLists = anycastIpLists;
            return this;
        }

        @Override
        public ListAnycastIpListsResponse build() {
            return new ListAnycastIpListsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
