/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a CloudFront function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionMetadata.Builder, FunctionMetadata> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FunctionARN")
            .getter(getter(FunctionMetadata::functionARN))
            .setter(setter(Builder::functionARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionARN")
                    .unmarshallLocationName("FunctionARN").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Stage")
            .getter(getter(FunctionMetadata::stageAsString))
            .setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage")
                    .unmarshallLocationName("Stage").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime")
            .getter(getter(FunctionMetadata::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime")
                    .unmarshallLocationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(FunctionMetadata::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD,
            STAGE_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String functionARN;

    private final String stage;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private FunctionMetadata(BuilderImpl builder) {
        this.functionARN = builder.functionARN;
        this.stage = builder.stage;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
     */
    public final String functionARN() {
        return functionARN;
    }

    /**
     * <p>
     * The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.
     * </p>
     * <p>
     * When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
     * <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     * </p>
     * <p>
     * When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution's cache
     * behavior, using the function's ARN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link FunctionStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
     *         <p>
     *         When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
     *         <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     *         </p>
     *         <p>
     *         When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution's cache
     *         behavior, using the function's ARN.
     * @see FunctionStage
     */
    public final FunctionStage stage() {
        return FunctionStage.fromValue(stage);
    }

    /**
     * <p>
     * The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.
     * </p>
     * <p>
     * When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
     * <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     * </p>
     * <p>
     * When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution's cache
     * behavior, using the function's ARN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link FunctionStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
     *         <p>
     *         When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
     *         <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     *         </p>
     *         <p>
     *         When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution's cache
     *         behavior, using the function's ARN.
     * @see FunctionStage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * The date and time when the function was created.
     * </p>
     * 
     * @return The date and time when the function was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The date and time when the function was most recently updated.
     * </p>
     * 
     * @return The date and time when the function was most recently updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionARN());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionMetadata)) {
            return false;
        }
        FunctionMetadata other = (FunctionMetadata) obj;
        return Objects.equals(functionARN(), other.functionARN()) && Objects.equals(stageAsString(), other.stageAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionMetadata").add("FunctionARN", functionARN()).add("Stage", stageAsString())
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionARN":
            return Optional.ofNullable(clazz.cast(functionARN()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionARN", FUNCTION_ARN_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionMetadata, T> g) {
        return obj -> g.apply((FunctionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
         * </p>
         * 
         * @param functionARN
         *        The Amazon Resource Name (ARN) of the function. The ARN uniquely identifies the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionARN(String functionARN);

        /**
         * <p>
         * The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.
         * </p>
         * <p>
         * When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
         * <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
         * </p>
         * <p>
         * When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution's cache
         * behavior, using the function's ARN.
         * </p>
         * 
         * @param stage
         *        The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
         *        <p>
         *        When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
         *        <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
         *        </p>
         *        <p>
         *        When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution's
         *        cache behavior, using the function's ARN.
         * @see FunctionStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionStage
         */
        Builder stage(String stage);

        /**
         * <p>
         * The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.
         * </p>
         * <p>
         * When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
         * <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
         * </p>
         * <p>
         * When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution's cache
         * behavior, using the function's ARN.
         * </p>
         * 
         * @param stage
         *        The stage that the function is in, either <code>DEVELOPMENT</code> or <code>LIVE</code>.</p>
         *        <p>
         *        When a function is in the <code>DEVELOPMENT</code> stage, you can test the function with
         *        <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
         *        </p>
         *        <p>
         *        When a function is in the <code>LIVE</code> stage, you can attach the function to a distribution's
         *        cache behavior, using the function's ARN.
         * @see FunctionStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionStage
         */
        Builder stage(FunctionStage stage);

        /**
         * <p>
         * The date and time when the function was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time when the function was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The date and time when the function was most recently updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time when the function was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String functionARN;

        private String stage;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionMetadata model) {
            functionARN(model.functionARN);
            stage(model.stage);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getFunctionARN() {
            return functionARN;
        }

        public final void setFunctionARN(String functionARN) {
            this.functionARN = functionARN;
        }

        @Override
        public final Builder functionARN(String functionARN) {
            this.functionARN = functionARN;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(FunctionStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public FunctionMetadata build() {
            return new FunctionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
