/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field-level encryption profile summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldLevelEncryptionProfileSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldLevelEncryptionProfileSummary.Builder, FieldLevelEncryptionProfileSummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(FieldLevelEncryptionProfileSummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(FieldLevelEncryptionProfileSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(FieldLevelEncryptionProfileSummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<EncryptionEntities> ENCRYPTION_ENTITIES_FIELD = SdkField
            .<EncryptionEntities> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionEntities")
            .getter(getter(FieldLevelEncryptionProfileSummary::encryptionEntities))
            .setter(setter(Builder::encryptionEntities))
            .constructor(EncryptionEntities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionEntities")
                    .unmarshallLocationName("EncryptionEntities").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(FieldLevelEncryptionProfileSummary::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            LAST_MODIFIED_TIME_FIELD, NAME_FIELD, ENCRYPTION_ENTITIES_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant lastModifiedTime;

    private final String name;

    private final EncryptionEntities encryptionEntities;

    private final String comment;

    private FieldLevelEncryptionProfileSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.name = builder.name;
        this.encryptionEntities = builder.encryptionEntities;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * ID for the field-level encryption profile summary.
     * </p>
     * 
     * @return ID for the field-level encryption profile summary.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time when the field-level encryption profile summary was last updated.
     * </p>
     * 
     * @return The time when the field-level encryption profile summary was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Name for the field-level encryption profile summary.
     * </p>
     * 
     * @return Name for the field-level encryption profile summary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A complex data type of encryption entities for the field-level encryption profile that include the public key ID,
     * provider, and field patterns for specifying which fields to encrypt with this key.
     * </p>
     * 
     * @return A complex data type of encryption entities for the field-level encryption profile that include the public
     *         key ID, provider, and field patterns for specifying which fields to encrypt with this key.
     */
    public final EncryptionEntities encryptionEntities() {
        return encryptionEntities;
    }

    /**
     * <p>
     * An optional comment for the field-level encryption profile summary. The comment cannot be longer than 128
     * characters.
     * </p>
     * 
     * @return An optional comment for the field-level encryption profile summary. The comment cannot be longer than 128
     *         characters.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionEntities());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLevelEncryptionProfileSummary)) {
            return false;
        }
        FieldLevelEncryptionProfileSummary other = (FieldLevelEncryptionProfileSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(name(), other.name()) && Objects.equals(encryptionEntities(), other.encryptionEntities())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldLevelEncryptionProfileSummary").add("Id", id()).add("LastModifiedTime", lastModifiedTime())
                .add("Name", name()).add("EncryptionEntities", encryptionEntities()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EncryptionEntities":
            return Optional.ofNullable(clazz.cast(encryptionEntities()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EncryptionEntities", ENCRYPTION_ENTITIES_FIELD);
        map.put("Comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldLevelEncryptionProfileSummary, T> g) {
        return obj -> g.apply((FieldLevelEncryptionProfileSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldLevelEncryptionProfileSummary> {
        /**
         * <p>
         * ID for the field-level encryption profile summary.
         * </p>
         * 
         * @param id
         *        ID for the field-level encryption profile summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time when the field-level encryption profile summary was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the field-level encryption profile summary was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Name for the field-level encryption profile summary.
         * </p>
         * 
         * @param name
         *        Name for the field-level encryption profile summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A complex data type of encryption entities for the field-level encryption profile that include the public key
         * ID, provider, and field patterns for specifying which fields to encrypt with this key.
         * </p>
         * 
         * @param encryptionEntities
         *        A complex data type of encryption entities for the field-level encryption profile that include the
         *        public key ID, provider, and field patterns for specifying which fields to encrypt with this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionEntities(EncryptionEntities encryptionEntities);

        /**
         * <p>
         * A complex data type of encryption entities for the field-level encryption profile that include the public key
         * ID, provider, and field patterns for specifying which fields to encrypt with this key.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionEntities.Builder} avoiding the
         * need to create one manually via {@link EncryptionEntities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionEntities.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionEntities(EncryptionEntities)}.
         * 
         * @param encryptionEntities
         *        a consumer that will call methods on {@link EncryptionEntities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionEntities(EncryptionEntities)
         */
        default Builder encryptionEntities(Consumer<EncryptionEntities.Builder> encryptionEntities) {
            return encryptionEntities(EncryptionEntities.builder().applyMutation(encryptionEntities).build());
        }

        /**
         * <p>
         * An optional comment for the field-level encryption profile summary. The comment cannot be longer than 128
         * characters.
         * </p>
         * 
         * @param comment
         *        An optional comment for the field-level encryption profile summary. The comment cannot be longer than
         *        128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant lastModifiedTime;

        private String name;

        private EncryptionEntities encryptionEntities;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldLevelEncryptionProfileSummary model) {
            id(model.id);
            lastModifiedTime(model.lastModifiedTime);
            name(model.name);
            encryptionEntities(model.encryptionEntities);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EncryptionEntities.Builder getEncryptionEntities() {
            return encryptionEntities != null ? encryptionEntities.toBuilder() : null;
        }

        public final void setEncryptionEntities(EncryptionEntities.BuilderImpl encryptionEntities) {
            this.encryptionEntities = encryptionEntities != null ? encryptionEntities.build() : null;
        }

        @Override
        public final Builder encryptionEntities(EncryptionEntities encryptionEntities) {
            this.encryptionEntities = encryptionEntities;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public FieldLevelEncryptionProfileSummary build() {
            return new FieldLevelEncryptionProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
