/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFieldLevelEncryptionProfileResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateFieldLevelEncryptionProfileResponse.Builder, CreateFieldLevelEncryptionProfileResponse> {
    private static final SdkField<FieldLevelEncryptionProfile> FIELD_LEVEL_ENCRYPTION_PROFILE_FIELD = SdkField
            .<FieldLevelEncryptionProfile> builder(MarshallingType.SDK_POJO)
            .memberName("FieldLevelEncryptionProfile")
            .getter(getter(CreateFieldLevelEncryptionProfileResponse::fieldLevelEncryptionProfile))
            .setter(setter(Builder::fieldLevelEncryptionProfile))
            .constructor(FieldLevelEncryptionProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionProfile")
                    .unmarshallLocationName("FieldLevelEncryptionProfile").build(), PayloadTrait.create()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(CreateFieldLevelEncryptionProfileResponse::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(CreateFieldLevelEncryptionProfileResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FIELD_LEVEL_ENCRYPTION_PROFILE_FIELD, LOCATION_FIELD, E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FieldLevelEncryptionProfile fieldLevelEncryptionProfile;

    private final String location;

    private final String eTag;

    private CreateFieldLevelEncryptionProfileResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryptionProfile = builder.fieldLevelEncryptionProfile;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * Returned when you create a new field-level encryption profile.
     * </p>
     * 
     * @return Returned when you create a new field-level encryption profile.
     */
    public final FieldLevelEncryptionProfile fieldLevelEncryptionProfile() {
        return fieldLevelEncryptionProfile;
    }

    /**
     * <p>
     * The fully qualified URI of the new profile resource just created.
     * </p>
     * 
     * @return The fully qualified URI of the new profile resource just created.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionProfile());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFieldLevelEncryptionProfileResponse)) {
            return false;
        }
        CreateFieldLevelEncryptionProfileResponse other = (CreateFieldLevelEncryptionProfileResponse) obj;
        return Objects.equals(fieldLevelEncryptionProfile(), other.fieldLevelEncryptionProfile())
                && Objects.equals(location(), other.location()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFieldLevelEncryptionProfileResponse")
                .add("FieldLevelEncryptionProfile", fieldLevelEncryptionProfile()).add("Location", location())
                .add("ETag", eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldLevelEncryptionProfile":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionProfile()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldLevelEncryptionProfile", FIELD_LEVEL_ENCRYPTION_PROFILE_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFieldLevelEncryptionProfileResponse, T> g) {
        return obj -> g.apply((CreateFieldLevelEncryptionProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateFieldLevelEncryptionProfileResponse> {
        /**
         * <p>
         * Returned when you create a new field-level encryption profile.
         * </p>
         * 
         * @param fieldLevelEncryptionProfile
         *        Returned when you create a new field-level encryption profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionProfile(FieldLevelEncryptionProfile fieldLevelEncryptionProfile);

        /**
         * <p>
         * Returned when you create a new field-level encryption profile.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldLevelEncryptionProfile.Builder}
         * avoiding the need to create one manually via {@link FieldLevelEncryptionProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldLevelEncryptionProfile.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldLevelEncryptionProfile(FieldLevelEncryptionProfile)}.
         * 
         * @param fieldLevelEncryptionProfile
         *        a consumer that will call methods on {@link FieldLevelEncryptionProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryptionProfile(FieldLevelEncryptionProfile)
         */
        default Builder fieldLevelEncryptionProfile(Consumer<FieldLevelEncryptionProfile.Builder> fieldLevelEncryptionProfile) {
            return fieldLevelEncryptionProfile(FieldLevelEncryptionProfile.builder().applyMutation(fieldLevelEncryptionProfile)
                    .build());
        }

        /**
         * <p>
         * The fully qualified URI of the new profile resource just created.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the new profile resource just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the field level encryption profile. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private FieldLevelEncryptionProfile fieldLevelEncryptionProfile;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFieldLevelEncryptionProfileResponse model) {
            super(model);
            fieldLevelEncryptionProfile(model.fieldLevelEncryptionProfile);
            location(model.location);
            eTag(model.eTag);
        }

        public final FieldLevelEncryptionProfile.Builder getFieldLevelEncryptionProfile() {
            return fieldLevelEncryptionProfile != null ? fieldLevelEncryptionProfile.toBuilder() : null;
        }

        public final void setFieldLevelEncryptionProfile(FieldLevelEncryptionProfile.BuilderImpl fieldLevelEncryptionProfile) {
            this.fieldLevelEncryptionProfile = fieldLevelEncryptionProfile != null ? fieldLevelEncryptionProfile.build() : null;
        }

        @Override
        public final Builder fieldLevelEncryptionProfile(FieldLevelEncryptionProfile fieldLevelEncryptionProfile) {
            this.fieldLevelEncryptionProfile = fieldLevelEncryptionProfile;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public CreateFieldLevelEncryptionProfileResponse build() {
            return new CreateFieldLevelEncryptionProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
