/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyDistributionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CopyDistributionRequest.Builder, CopyDistributionRequest> {
    private static final SdkField<String> PRIMARY_DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrimaryDistributionId")
            .getter(getter(CopyDistributionRequest::primaryDistributionId))
            .setter(setter(Builder::primaryDistributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PrimaryDistributionId")
                    .unmarshallLocationName("PrimaryDistributionId").build()).build();

    private static final SdkField<Boolean> STAGING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Staging")
            .getter(getter(CopyDistributionRequest::staging))
            .setter(setter(Builder::staging))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Staging")
                    .unmarshallLocationName("Staging").build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(CopyDistributionRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(CopyDistributionRequest::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(CopyDistributionRequest::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_DISTRIBUTION_ID_FIELD,
            STAGING_FIELD, IF_MATCH_FIELD, CALLER_REFERENCE_FIELD, ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String primaryDistributionId;

    private final Boolean staging;

    private final String ifMatch;

    private final String callerReference;

    private final Boolean enabled;

    private CopyDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.primaryDistributionId = builder.primaryDistributionId;
        this.staging = builder.staging;
        this.ifMatch = builder.ifMatch;
        this.callerReference = builder.callerReference;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The identifier of the primary distribution whose configuration you are copying. To get a distribution ID, use
     * <code>ListDistributions</code>.
     * </p>
     * 
     * @return The identifier of the primary distribution whose configuration you are copying. To get a distribution ID,
     *         use <code>ListDistributions</code>.
     */
    public final String primaryDistributionId() {
        return primaryDistributionId;
    }

    /**
     * <p>
     * The type of distribution that your primary distribution will be copied to. The only valid value is
     * <code>True</code>, indicating that you are copying to a staging distribution.
     * </p>
     * 
     * @return The type of distribution that your primary distribution will be copied to. The only valid value is
     *         <code>True</code>, indicating that you are copying to a staging distribution.
     */
    public final Boolean staging() {
        return staging;
    }

    /**
     * <p>
     * The version identifier of the primary distribution whose configuration you are copying. This is the
     * <code>ETag</code> value returned in the response to <code>GetDistribution</code> and
     * <code>GetDistributionConfig</code>.
     * </p>
     * 
     * @return The version identifier of the primary distribution whose configuration you are copying. This is the
     *         <code>ETag</code> value returned in the response to <code>GetDistribution</code> and
     *         <code>GetDistributionConfig</code>.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * <p>
     * A value that uniquely identifies a request to create a resource. This helps to prevent CloudFront from creating a
     * duplicate resource if you accidentally resubmit an identical request.
     * </p>
     * 
     * @return A value that uniquely identifies a request to create a resource. This helps to prevent CloudFront from
     *         creating a duplicate resource if you accidentally resubmit an identical request.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A Boolean flag to specify the state of the staging distribution when it's created. When you set this value to
     * <code>True</code>, the staging distribution is enabled. When you set this value to <code>False</code>, the
     * staging distribution is disabled.
     * </p>
     * <p>
     * If you omit this field, the default value is <code>True</code>.
     * </p>
     * 
     * @return A Boolean flag to specify the state of the staging distribution when it's created. When you set this
     *         value to <code>True</code>, the staging distribution is enabled. When you set this value to
     *         <code>False</code>, the staging distribution is disabled.</p>
     *         <p>
     *         If you omit this field, the default value is <code>True</code>.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(primaryDistributionId());
        hashCode = 31 * hashCode + Objects.hashCode(staging());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDistributionRequest)) {
            return false;
        }
        CopyDistributionRequest other = (CopyDistributionRequest) obj;
        return Objects.equals(primaryDistributionId(), other.primaryDistributionId())
                && Objects.equals(staging(), other.staging()) && Objects.equals(ifMatch(), other.ifMatch())
                && Objects.equals(callerReference(), other.callerReference()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyDistributionRequest").add("PrimaryDistributionId", primaryDistributionId())
                .add("Staging", staging()).add("IfMatch", ifMatch()).add("CallerReference", callerReference())
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryDistributionId":
            return Optional.ofNullable(clazz.cast(primaryDistributionId()));
        case "Staging":
            return Optional.ofNullable(clazz.cast(staging()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryDistributionId", PRIMARY_DISTRIBUTION_ID_FIELD);
        map.put("Staging", STAGING_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("CallerReference", CALLER_REFERENCE_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyDistributionRequest, T> g) {
        return obj -> g.apply((CopyDistributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyDistributionRequest> {
        /**
         * <p>
         * The identifier of the primary distribution whose configuration you are copying. To get a distribution ID, use
         * <code>ListDistributions</code>.
         * </p>
         * 
         * @param primaryDistributionId
         *        The identifier of the primary distribution whose configuration you are copying. To get a distribution
         *        ID, use <code>ListDistributions</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryDistributionId(String primaryDistributionId);

        /**
         * <p>
         * The type of distribution that your primary distribution will be copied to. The only valid value is
         * <code>True</code>, indicating that you are copying to a staging distribution.
         * </p>
         * 
         * @param staging
         *        The type of distribution that your primary distribution will be copied to. The only valid value is
         *        <code>True</code>, indicating that you are copying to a staging distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staging(Boolean staging);

        /**
         * <p>
         * The version identifier of the primary distribution whose configuration you are copying. This is the
         * <code>ETag</code> value returned in the response to <code>GetDistribution</code> and
         * <code>GetDistributionConfig</code>.
         * </p>
         * 
         * @param ifMatch
         *        The version identifier of the primary distribution whose configuration you are copying. This is the
         *        <code>ETag</code> value returned in the response to <code>GetDistribution</code> and
         *        <code>GetDistributionConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * <p>
         * A value that uniquely identifies a request to create a resource. This helps to prevent CloudFront from
         * creating a duplicate resource if you accidentally resubmit an identical request.
         * </p>
         * 
         * @param callerReference
         *        A value that uniquely identifies a request to create a resource. This helps to prevent CloudFront from
         *        creating a duplicate resource if you accidentally resubmit an identical request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A Boolean flag to specify the state of the staging distribution when it's created. When you set this value to
         * <code>True</code>, the staging distribution is enabled. When you set this value to <code>False</code>, the
         * staging distribution is disabled.
         * </p>
         * <p>
         * If you omit this field, the default value is <code>True</code>.
         * </p>
         * 
         * @param enabled
         *        A Boolean flag to specify the state of the staging distribution when it's created. When you set this
         *        value to <code>True</code>, the staging distribution is enabled. When you set this value to
         *        <code>False</code>, the staging distribution is disabled.</p>
         *        <p>
         *        If you omit this field, the default value is <code>True</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String primaryDistributionId;

        private Boolean staging;

        private String ifMatch;

        private String callerReference;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDistributionRequest model) {
            super(model);
            primaryDistributionId(model.primaryDistributionId);
            staging(model.staging);
            ifMatch(model.ifMatch);
            callerReference(model.callerReference);
            enabled(model.enabled);
        }

        public final String getPrimaryDistributionId() {
            return primaryDistributionId;
        }

        public final void setPrimaryDistributionId(String primaryDistributionId) {
            this.primaryDistributionId = primaryDistributionId;
        }

        @Override
        public final Builder primaryDistributionId(String primaryDistributionId) {
            this.primaryDistributionId = primaryDistributionId;
            return this;
        }

        public final Boolean getStaging() {
            return staging;
        }

        public final void setStaging(Boolean staging) {
            this.staging = staging;
        }

        @Override
        public final Builder staging(Boolean staging) {
            this.staging = staging;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDistributionRequest build() {
            return new CopyDistributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
