/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFrontOriginAccessIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFrontOriginAccessIdentity> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CloudFrontOriginAccessIdentity.getter(CloudFrontOriginAccessIdentity::id)).setter(CloudFrontOriginAccessIdentity.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> S3_CANONICAL_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3CanonicalUserId").getter(CloudFrontOriginAccessIdentity.getter(CloudFrontOriginAccessIdentity::s3CanonicalUserId)).setter(CloudFrontOriginAccessIdentity.setter(Builder::s3CanonicalUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3CanonicalUserId").unmarshallLocationName("S3CanonicalUserId").build()}).build();
    private static final SdkField<CloudFrontOriginAccessIdentityConfig> CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudFrontOriginAccessIdentityConfig").getter(CloudFrontOriginAccessIdentity.getter(CloudFrontOriginAccessIdentity::cloudFrontOriginAccessIdentityConfig)).setter(CloudFrontOriginAccessIdentity.setter(Builder::cloudFrontOriginAccessIdentityConfig)).constructor(CloudFrontOriginAccessIdentityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontOriginAccessIdentityConfig").unmarshallLocationName("CloudFrontOriginAccessIdentityConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, S3_CANONICAL_USER_ID_FIELD, CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("S3CanonicalUserId", S3_CANONICAL_USER_ID_FIELD);
            this.put("CloudFrontOriginAccessIdentityConfig", CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String s3CanonicalUserId;
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

    private CloudFrontOriginAccessIdentity(BuilderImpl builder) {
        this.id = builder.id;
        this.s3CanonicalUserId = builder.s3CanonicalUserId;
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
    }

    public final String id() {
        return this.id;
    }

    public final String s3CanonicalUserId() {
        return this.s3CanonicalUserId;
    }

    public final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return this.cloudFrontOriginAccessIdentityConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3CanonicalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontOriginAccessIdentityConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentity)) {
            return false;
        }
        CloudFrontOriginAccessIdentity other = (CloudFrontOriginAccessIdentity)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.s3CanonicalUserId(), other.s3CanonicalUserId()) && Objects.equals(this.cloudFrontOriginAccessIdentityConfig(), other.cloudFrontOriginAccessIdentityConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CloudFrontOriginAccessIdentity").add("Id", (Object)this.id()).add("S3CanonicalUserId", (Object)this.s3CanonicalUserId()).add("CloudFrontOriginAccessIdentityConfig", (Object)this.cloudFrontOriginAccessIdentityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "S3CanonicalUserId": {
                return Optional.ofNullable(clazz.cast(this.s3CanonicalUserId()));
            }
            case "CloudFrontOriginAccessIdentityConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontOriginAccessIdentityConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudFrontOriginAccessIdentity, T> g) {
        return obj -> g.apply((CloudFrontOriginAccessIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String s3CanonicalUserId;
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentity model) {
            this.id(model.id);
            this.s3CanonicalUserId(model.s3CanonicalUserId);
            this.cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getS3CanonicalUserId() {
            return this.s3CanonicalUserId;
        }

        public final void setS3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
        }

        @Override
        public final Builder s3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
            return this;
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return this.cloudFrontOriginAccessIdentityConfig != null ? this.cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.build() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public CloudFrontOriginAccessIdentity build() {
            return new CloudFrontOriginAccessIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFrontOriginAccessIdentity> {
        public Builder id(String var1);

        public Builder s3CanonicalUserId(String var1);

        public Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig var1);

        default public Builder cloudFrontOriginAccessIdentityConfig(Consumer<CloudFrontOriginAccessIdentityConfig.Builder> cloudFrontOriginAccessIdentityConfig) {
            return this.cloudFrontOriginAccessIdentityConfig((CloudFrontOriginAccessIdentityConfig)((CloudFrontOriginAccessIdentityConfig.Builder)CloudFrontOriginAccessIdentityConfig.builder().applyMutation(cloudFrontOriginAccessIdentityConfig)).build());
        }
    }
}

