/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.HttpVersion;
import software.amazon.awssdk.services.cloudfront.model.LoggingConfig;
import software.amazon.awssdk.services.cloudfront.model.OriginGroups;
import software.amazon.awssdk.services.cloudfront.model.Origins;
import software.amazon.awssdk.services.cloudfront.model.PriceClass;
import software.amazon.awssdk.services.cloudfront.model.Restrictions;
import software.amazon.awssdk.services.cloudfront.model.ViewerCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DistributionConfig> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerReference").getter(DistributionConfig.getter(DistributionConfig::callerReference)).setter(DistributionConfig.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<Aliases> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Aliases").getter(DistributionConfig.getter(DistributionConfig::aliases)).setter(DistributionConfig.setter(Builder::aliases)).constructor(Aliases::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").unmarshallLocationName("Aliases").build()}).build();
    private static final SdkField<String> DEFAULT_ROOT_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRootObject").getter(DistributionConfig.getter(DistributionConfig::defaultRootObject)).setter(DistributionConfig.setter(Builder::defaultRootObject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRootObject").unmarshallLocationName("DefaultRootObject").build()}).build();
    private static final SdkField<Origins> ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Origins").getter(DistributionConfig.getter(DistributionConfig::origins)).setter(DistributionConfig.setter(Builder::origins)).constructor(Origins::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins").unmarshallLocationName("Origins").build()}).build();
    private static final SdkField<OriginGroups> ORIGIN_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginGroups").getter(DistributionConfig.getter(DistributionConfig::originGroups)).setter(DistributionConfig.setter(Builder::originGroups)).constructor(OriginGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginGroups").unmarshallLocationName("OriginGroups").build()}).build();
    private static final SdkField<DefaultCacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultCacheBehavior").getter(DistributionConfig.getter(DistributionConfig::defaultCacheBehavior)).setter(DistributionConfig.setter(Builder::defaultCacheBehavior)).constructor(DefaultCacheBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCacheBehavior").unmarshallLocationName("DefaultCacheBehavior").build()}).build();
    private static final SdkField<CacheBehaviors> CACHE_BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheBehaviors").getter(DistributionConfig.getter(DistributionConfig::cacheBehaviors)).setter(DistributionConfig.setter(Builder::cacheBehaviors)).constructor(CacheBehaviors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheBehaviors").unmarshallLocationName("CacheBehaviors").build()}).build();
    private static final SdkField<CustomErrorResponses> CUSTOM_ERROR_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomErrorResponses").getter(DistributionConfig.getter(DistributionConfig::customErrorResponses)).setter(DistributionConfig.setter(Builder::customErrorResponses)).constructor(CustomErrorResponses::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomErrorResponses").unmarshallLocationName("CustomErrorResponses").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(DistributionConfig.getter(DistributionConfig::comment)).setter(DistributionConfig.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Logging").getter(DistributionConfig.getter(DistributionConfig::logging)).setter(DistributionConfig.setter(Builder::logging)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logging").unmarshallLocationName("Logging").build()}).build();
    private static final SdkField<String> PRICE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PriceClass").getter(DistributionConfig.getter(DistributionConfig::priceClassAsString)).setter(DistributionConfig.setter(Builder::priceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceClass").unmarshallLocationName("PriceClass").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(DistributionConfig.getter(DistributionConfig::enabled)).setter(DistributionConfig.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final SdkField<ViewerCertificate> VIEWER_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ViewerCertificate").getter(DistributionConfig.getter(DistributionConfig::viewerCertificate)).setter(DistributionConfig.setter(Builder::viewerCertificate)).constructor(ViewerCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerCertificate").unmarshallLocationName("ViewerCertificate").build()}).build();
    private static final SdkField<Restrictions> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Restrictions").getter(DistributionConfig.getter(DistributionConfig::restrictions)).setter(DistributionConfig.setter(Builder::restrictions)).constructor(Restrictions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions").unmarshallLocationName("Restrictions").build()}).build();
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebACLId").getter(DistributionConfig.getter(DistributionConfig::webACLId)).setter(DistributionConfig.setter(Builder::webACLId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").unmarshallLocationName("WebACLId").build()}).build();
    private static final SdkField<String> HTTP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpVersion").getter(DistributionConfig.getter(DistributionConfig::httpVersionAsString)).setter(DistributionConfig.setter(Builder::httpVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpVersion").unmarshallLocationName("HttpVersion").build()}).build();
    private static final SdkField<Boolean> IS_IPV6_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsIPV6Enabled").getter(DistributionConfig.getter(DistributionConfig::isIPV6Enabled)).setter(DistributionConfig.setter(Builder::isIPV6Enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIPV6Enabled").unmarshallLocationName("IsIPV6Enabled").build()}).build();
    private static final SdkField<String> CONTINUOUS_DEPLOYMENT_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContinuousDeploymentPolicyId").getter(DistributionConfig.getter(DistributionConfig::continuousDeploymentPolicyId)).setter(DistributionConfig.setter(Builder::continuousDeploymentPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousDeploymentPolicyId").unmarshallLocationName("ContinuousDeploymentPolicyId").build()}).build();
    private static final SdkField<Boolean> STAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Staging").getter(DistributionConfig.getter(DistributionConfig::staging)).setter(DistributionConfig.setter(Builder::staging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Staging").unmarshallLocationName("Staging").build()}).build();
    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnycastIpListId").getter(DistributionConfig.getter(DistributionConfig::anycastIpListId)).setter(DistributionConfig.setter(Builder::anycastIpListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId").unmarshallLocationName("AnycastIpListId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD, ALIASES_FIELD, DEFAULT_ROOT_OBJECT_FIELD, ORIGINS_FIELD, ORIGIN_GROUPS_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIORS_FIELD, CUSTOM_ERROR_RESPONSES_FIELD, COMMENT_FIELD, LOGGING_FIELD, PRICE_CLASS_FIELD, ENABLED_FIELD, VIEWER_CERTIFICATE_FIELD, RESTRICTIONS_FIELD, WEB_ACL_ID_FIELD, HTTP_VERSION_FIELD, IS_IPV6_ENABLED_FIELD, CONTINUOUS_DEPLOYMENT_POLICY_ID_FIELD, STAGING_FIELD, ANYCAST_IP_LIST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CallerReference", CALLER_REFERENCE_FIELD);
            this.put("Aliases", ALIASES_FIELD);
            this.put("DefaultRootObject", DEFAULT_ROOT_OBJECT_FIELD);
            this.put("Origins", ORIGINS_FIELD);
            this.put("OriginGroups", ORIGIN_GROUPS_FIELD);
            this.put("DefaultCacheBehavior", DEFAULT_CACHE_BEHAVIOR_FIELD);
            this.put("CacheBehaviors", CACHE_BEHAVIORS_FIELD);
            this.put("CustomErrorResponses", CUSTOM_ERROR_RESPONSES_FIELD);
            this.put("Comment", COMMENT_FIELD);
            this.put("Logging", LOGGING_FIELD);
            this.put("PriceClass", PRICE_CLASS_FIELD);
            this.put("Enabled", ENABLED_FIELD);
            this.put("ViewerCertificate", VIEWER_CERTIFICATE_FIELD);
            this.put("Restrictions", RESTRICTIONS_FIELD);
            this.put("WebACLId", WEB_ACL_ID_FIELD);
            this.put("HttpVersion", HTTP_VERSION_FIELD);
            this.put("IsIPV6Enabled", IS_IPV6_ENABLED_FIELD);
            this.put("ContinuousDeploymentPolicyId", CONTINUOUS_DEPLOYMENT_POLICY_ID_FIELD);
            this.put("Staging", STAGING_FIELD);
            this.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String callerReference;
    private final Aliases aliases;
    private final String defaultRootObject;
    private final Origins origins;
    private final OriginGroups originGroups;
    private final DefaultCacheBehavior defaultCacheBehavior;
    private final CacheBehaviors cacheBehaviors;
    private final CustomErrorResponses customErrorResponses;
    private final String comment;
    private final LoggingConfig logging;
    private final String priceClass;
    private final Boolean enabled;
    private final ViewerCertificate viewerCertificate;
    private final Restrictions restrictions;
    private final String webACLId;
    private final String httpVersion;
    private final Boolean isIPV6Enabled;
    private final String continuousDeploymentPolicyId;
    private final Boolean staging;
    private final String anycastIpListId;

    private DistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.aliases = builder.aliases;
        this.defaultRootObject = builder.defaultRootObject;
        this.origins = builder.origins;
        this.originGroups = builder.originGroups;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
        this.continuousDeploymentPolicyId = builder.continuousDeploymentPolicyId;
        this.staging = builder.staging;
        this.anycastIpListId = builder.anycastIpListId;
    }

    public final String callerReference() {
        return this.callerReference;
    }

    public final Aliases aliases() {
        return this.aliases;
    }

    public final String defaultRootObject() {
        return this.defaultRootObject;
    }

    public final Origins origins() {
        return this.origins;
    }

    public final OriginGroups originGroups() {
        return this.originGroups;
    }

    public final DefaultCacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public final CacheBehaviors cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public final CustomErrorResponses customErrorResponses() {
        return this.customErrorResponses;
    }

    public final String comment() {
        return this.comment;
    }

    public final LoggingConfig logging() {
        return this.logging;
    }

    public final PriceClass priceClass() {
        return PriceClass.fromValue(this.priceClass);
    }

    public final String priceClassAsString() {
        return this.priceClass;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final ViewerCertificate viewerCertificate() {
        return this.viewerCertificate;
    }

    public final Restrictions restrictions() {
        return this.restrictions;
    }

    public final String webACLId() {
        return this.webACLId;
    }

    public final HttpVersion httpVersion() {
        return HttpVersion.fromValue(this.httpVersion);
    }

    public final String httpVersionAsString() {
        return this.httpVersion;
    }

    public final Boolean isIPV6Enabled() {
        return this.isIPV6Enabled;
    }

    public final String continuousDeploymentPolicyId() {
        return this.continuousDeploymentPolicyId;
    }

    public final Boolean staging() {
        return this.staging;
    }

    public final String anycastIpListId() {
        return this.anycastIpListId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRootObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.origins());
        hashCode = 31 * hashCode + Objects.hashCode(this.originGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isIPV6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuousDeploymentPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.staging());
        hashCode = 31 * hashCode + Objects.hashCode(this.anycastIpListId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfig)) {
            return false;
        }
        DistributionConfig other = (DistributionConfig)obj;
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.defaultRootObject(), other.defaultRootObject()) && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.originGroups(), other.originGroups()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.customErrorResponses(), other.customErrorResponses()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.priceClassAsString(), other.priceClassAsString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.viewerCertificate(), other.viewerCertificate()) && Objects.equals(this.restrictions(), other.restrictions()) && Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.httpVersionAsString(), other.httpVersionAsString()) && Objects.equals(this.isIPV6Enabled(), other.isIPV6Enabled()) && Objects.equals(this.continuousDeploymentPolicyId(), other.continuousDeploymentPolicyId()) && Objects.equals(this.staging(), other.staging()) && Objects.equals(this.anycastIpListId(), other.anycastIpListId());
    }

    public final String toString() {
        return ToString.builder((String)"DistributionConfig").add("CallerReference", (Object)this.callerReference()).add("Aliases", (Object)this.aliases()).add("DefaultRootObject", (Object)this.defaultRootObject()).add("Origins", (Object)this.origins()).add("OriginGroups", (Object)this.originGroups()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviors", (Object)this.cacheBehaviors()).add("CustomErrorResponses", (Object)this.customErrorResponses()).add("Comment", (Object)(this.comment() == null ? null : "*** Sensitive Data Redacted ***")).add("Logging", (Object)this.logging()).add("PriceClass", (Object)this.priceClassAsString()).add("Enabled", (Object)this.enabled()).add("ViewerCertificate", (Object)this.viewerCertificate()).add("Restrictions", (Object)this.restrictions()).add("WebACLId", (Object)this.webACLId()).add("HttpVersion", (Object)this.httpVersionAsString()).add("IsIPV6Enabled", (Object)this.isIPV6Enabled()).add("ContinuousDeploymentPolicyId", (Object)this.continuousDeploymentPolicyId()).add("Staging", (Object)this.staging()).add("AnycastIpListId", (Object)this.anycastIpListId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "DefaultRootObject": {
                return Optional.ofNullable(clazz.cast(this.defaultRootObject()));
            }
            case "Origins": {
                return Optional.ofNullable(clazz.cast(this.origins()));
            }
            case "OriginGroups": {
                return Optional.ofNullable(clazz.cast(this.originGroups()));
            }
            case "DefaultCacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultCacheBehavior()));
            }
            case "CacheBehaviors": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviors()));
            }
            case "CustomErrorResponses": {
                return Optional.ofNullable(clazz.cast(this.customErrorResponses()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "PriceClass": {
                return Optional.ofNullable(clazz.cast(this.priceClassAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ViewerCertificate": {
                return Optional.ofNullable(clazz.cast(this.viewerCertificate()));
            }
            case "Restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictions()));
            }
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "HttpVersion": {
                return Optional.ofNullable(clazz.cast(this.httpVersionAsString()));
            }
            case "IsIPV6Enabled": {
                return Optional.ofNullable(clazz.cast(this.isIPV6Enabled()));
            }
            case "ContinuousDeploymentPolicyId": {
                return Optional.ofNullable(clazz.cast(this.continuousDeploymentPolicyId()));
            }
            case "Staging": {
                return Optional.ofNullable(clazz.cast(this.staging()));
            }
            case "AnycastIpListId": {
                return Optional.ofNullable(clazz.cast(this.anycastIpListId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DistributionConfig, T> g) {
        return obj -> g.apply((DistributionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private Aliases aliases;
        private String defaultRootObject;
        private Origins origins;
        private OriginGroups originGroups;
        private DefaultCacheBehavior defaultCacheBehavior;
        private CacheBehaviors cacheBehaviors;
        private CustomErrorResponses customErrorResponses;
        private String comment;
        private LoggingConfig logging;
        private String priceClass;
        private Boolean enabled;
        private ViewerCertificate viewerCertificate;
        private Restrictions restrictions;
        private String webACLId;
        private String httpVersion;
        private Boolean isIPV6Enabled;
        private String continuousDeploymentPolicyId;
        private Boolean staging;
        private String anycastIpListId;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionConfig model) {
            this.callerReference(model.callerReference);
            this.aliases(model.aliases);
            this.defaultRootObject(model.defaultRootObject);
            this.origins(model.origins);
            this.originGroups(model.originGroups);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviors(model.cacheBehaviors);
            this.customErrorResponses(model.customErrorResponses);
            this.comment(model.comment);
            this.logging(model.logging);
            this.priceClass(model.priceClass);
            this.enabled(model.enabled);
            this.viewerCertificate(model.viewerCertificate);
            this.restrictions(model.restrictions);
            this.webACLId(model.webACLId);
            this.httpVersion(model.httpVersion);
            this.isIPV6Enabled(model.isIPV6Enabled);
            this.continuousDeploymentPolicyId(model.continuousDeploymentPolicyId);
            this.staging(model.staging);
            this.anycastIpListId(model.anycastIpListId);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final Aliases.Builder getAliases() {
            return this.aliases != null ? this.aliases.toBuilder() : null;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final String getDefaultRootObject() {
            return this.defaultRootObject;
        }

        public final void setDefaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
        }

        @Override
        public final Builder defaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
            return this;
        }

        public final Origins.Builder getOrigins() {
            return this.origins != null ? this.origins.toBuilder() : null;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final OriginGroups.Builder getOriginGroups() {
            return this.originGroups != null ? this.originGroups.toBuilder() : null;
        }

        public final void setOriginGroups(OriginGroups.BuilderImpl originGroups) {
            this.originGroups = originGroups != null ? originGroups.build() : null;
        }

        @Override
        public final Builder originGroups(OriginGroups originGroups) {
            this.originGroups = originGroups;
            return this;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return this.cacheBehaviors != null ? this.cacheBehaviors.toBuilder() : null;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return this.customErrorResponses != null ? this.customErrorResponses.toBuilder() : null;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final LoggingConfig.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        public final void setLogging(LoggingConfig.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(LoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final String getPriceClass() {
            return this.priceClass;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass == null ? null : priceClass.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return this.viewerCertificate != null ? this.viewerCertificate.toBuilder() : null;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final Restrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getHttpVersion() {
            return this.httpVersion;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion == null ? null : httpVersion.toString());
            return this;
        }

        public final Boolean getIsIPV6Enabled() {
            return this.isIPV6Enabled;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final String getContinuousDeploymentPolicyId() {
            return this.continuousDeploymentPolicyId;
        }

        public final void setContinuousDeploymentPolicyId(String continuousDeploymentPolicyId) {
            this.continuousDeploymentPolicyId = continuousDeploymentPolicyId;
        }

        @Override
        public final Builder continuousDeploymentPolicyId(String continuousDeploymentPolicyId) {
            this.continuousDeploymentPolicyId = continuousDeploymentPolicyId;
            return this;
        }

        public final Boolean getStaging() {
            return this.staging;
        }

        public final void setStaging(Boolean staging) {
            this.staging = staging;
        }

        @Override
        public final Builder staging(Boolean staging) {
            this.staging = staging;
            return this;
        }

        public final String getAnycastIpListId() {
            return this.anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        public DistributionConfig build() {
            return new DistributionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DistributionConfig> {
        public Builder callerReference(String var1);

        public Builder aliases(Aliases var1);

        default public Builder aliases(Consumer<Aliases.Builder> aliases) {
            return this.aliases((Aliases)((Aliases.Builder)Aliases.builder().applyMutation(aliases)).build());
        }

        public Builder defaultRootObject(String var1);

        public Builder origins(Origins var1);

        default public Builder origins(Consumer<Origins.Builder> origins) {
            return this.origins((Origins)((Origins.Builder)Origins.builder().applyMutation(origins)).build());
        }

        public Builder originGroups(OriginGroups var1);

        default public Builder originGroups(Consumer<OriginGroups.Builder> originGroups) {
            return this.originGroups((OriginGroups)((OriginGroups.Builder)OriginGroups.builder().applyMutation(originGroups)).build());
        }

        public Builder defaultCacheBehavior(DefaultCacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((DefaultCacheBehavior)((DefaultCacheBehavior.Builder)DefaultCacheBehavior.builder().applyMutation(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviors(CacheBehaviors var1);

        default public Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return this.cacheBehaviors((CacheBehaviors)((CacheBehaviors.Builder)CacheBehaviors.builder().applyMutation(cacheBehaviors)).build());
        }

        public Builder customErrorResponses(CustomErrorResponses var1);

        default public Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return this.customErrorResponses((CustomErrorResponses)((CustomErrorResponses.Builder)CustomErrorResponses.builder().applyMutation(customErrorResponses)).build());
        }

        public Builder comment(String var1);

        public Builder logging(LoggingConfig var1);

        default public Builder logging(Consumer<LoggingConfig.Builder> logging) {
            return this.logging((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(logging)).build());
        }

        public Builder priceClass(String var1);

        public Builder priceClass(PriceClass var1);

        public Builder enabled(Boolean var1);

        public Builder viewerCertificate(ViewerCertificate var1);

        default public Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return this.viewerCertificate((ViewerCertificate)((ViewerCertificate.Builder)ViewerCertificate.builder().applyMutation(viewerCertificate)).build());
        }

        public Builder restrictions(Restrictions var1);

        default public Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return this.restrictions((Restrictions)((Restrictions.Builder)Restrictions.builder().applyMutation(restrictions)).build());
        }

        public Builder webACLId(String var1);

        public Builder httpVersion(String var1);

        public Builder httpVersion(HttpVersion var1);

        public Builder isIPV6Enabled(Boolean var1);

        public Builder continuousDeploymentPolicyId(String var1);

        public Builder staging(Boolean var1);

        public Builder anycastIpListId(String var1);
    }
}

