/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistribution;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStreamingDistributionResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, CreateStreamingDistributionResponse> {
    private static final SdkField<StreamingDistribution> STREAMING_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingDistribution").getter(CreateStreamingDistributionResponse.getter(CreateStreamingDistributionResponse::streamingDistribution)).setter(CreateStreamingDistributionResponse.setter(Builder::streamingDistribution)).constructor(StreamingDistribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistribution").unmarshallLocationName("StreamingDistribution").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateStreamingDistributionResponse.getter(CreateStreamingDistributionResponse::location)).setter(CreateStreamingDistributionResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(CreateStreamingDistributionResponse.getter(CreateStreamingDistributionResponse::eTag)).setter(CreateStreamingDistributionResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_DISTRIBUTION_FIELD, LOCATION_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StreamingDistribution", STREAMING_DISTRIBUTION_FIELD);
            this.put("Location", LOCATION_FIELD);
            this.put("ETag", E_TAG_FIELD);
        }
    });
    private final StreamingDistribution streamingDistribution;
    private final String location;
    private final String eTag;

    private CreateStreamingDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistribution = builder.streamingDistribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    public final StreamingDistribution streamingDistribution() {
        return this.streamingDistribution;
    }

    public final String location() {
        return this.location;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionResponse)) {
            return false;
        }
        CreateStreamingDistributionResponse other = (CreateStreamingDistributionResponse)((Object)obj);
        return Objects.equals(this.streamingDistribution(), other.streamingDistribution()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStreamingDistributionResponse").add("StreamingDistribution", (Object)this.streamingDistribution()).add("Location", (Object)this.location()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamingDistribution": {
                return Optional.ofNullable(clazz.cast(this.streamingDistribution()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamingDistributionResponse, T> g) {
        return obj -> g.apply((CreateStreamingDistributionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private StreamingDistribution streamingDistribution;
        private String location;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionResponse model) {
            super(model);
            this.streamingDistribution(model.streamingDistribution);
            this.location(model.location);
            this.eTag(model.eTag);
        }

        public final StreamingDistribution.Builder getStreamingDistribution() {
            return this.streamingDistribution != null ? this.streamingDistribution.toBuilder() : null;
        }

        public final void setStreamingDistribution(StreamingDistribution.BuilderImpl streamingDistribution) {
            this.streamingDistribution = streamingDistribution != null ? streamingDistribution.build() : null;
        }

        @Override
        public final Builder streamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public CreateStreamingDistributionResponse build() {
            return new CreateStreamingDistributionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStreamingDistributionResponse> {
        public Builder streamingDistribution(StreamingDistribution var1);

        default public Builder streamingDistribution(Consumer<StreamingDistribution.Builder> streamingDistribution) {
            return this.streamingDistribution((StreamingDistribution)((StreamingDistribution.Builder)StreamingDistribution.builder().applyMutation(streamingDistribution)).build());
        }

        public Builder location(String var1);

        public Builder eTag(String var1);
    }
}

