/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummariesCopier;
import software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnycastIpListCollection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnycastIpListCollection> {
    private static final SdkField<List<AnycastIpListSummary>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(AnycastIpListCollection.getter(AnycastIpListCollection::items)).setter(AnycastIpListCollection.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("AnycastIpListSummary").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnycastIpListSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListSummary").unmarshallLocationName("AnycastIpListSummary").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(AnycastIpListCollection.getter(AnycastIpListCollection::marker)).setter(AnycastIpListCollection.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").unmarshallLocationName("Marker").build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(AnycastIpListCollection.getter(AnycastIpListCollection::nextMarker)).setter(AnycastIpListCollection.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(AnycastIpListCollection.getter(AnycastIpListCollection::maxItems)).setter(AnycastIpListCollection.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(AnycastIpListCollection.getter(AnycastIpListCollection::isTruncated)).setter(AnycastIpListCollection.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(AnycastIpListCollection.getter(AnycastIpListCollection::quantity)).setter(AnycastIpListCollection.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, MARKER_FIELD, NEXT_MARKER_FIELD, MAX_ITEMS_FIELD, IS_TRUNCATED_FIELD, QUANTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Items", ITEMS_FIELD);
            this.put("Marker", MARKER_FIELD);
            this.put("NextMarker", NEXT_MARKER_FIELD);
            this.put("MaxItems", MAX_ITEMS_FIELD);
            this.put("IsTruncated", IS_TRUNCATED_FIELD);
            this.put("Quantity", QUANTITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<AnycastIpListSummary> items;
    private final String marker;
    private final String nextMarker;
    private final Integer maxItems;
    private final Boolean isTruncated;
    private final Integer quantity;

    private AnycastIpListCollection(BuilderImpl builder) {
        this.items = builder.items;
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.isTruncated = builder.isTruncated;
        this.quantity = builder.quantity;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<AnycastIpListSummary> items() {
        return this.items;
    }

    public final String marker() {
        return this.marker;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnycastIpListCollection)) {
            return false;
        }
        AnycastIpListCollection other = (AnycastIpListCollection)obj;
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.quantity(), other.quantity());
    }

    public final String toString() {
        return ToString.builder((String)"AnycastIpListCollection").add("Items", this.hasItems() ? this.items() : null).add("Marker", (Object)this.marker()).add("NextMarker", (Object)this.nextMarker()).add("MaxItems", (Object)this.maxItems()).add("IsTruncated", (Object)this.isTruncated()).add("Quantity", (Object)this.quantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnycastIpListCollection, T> g) {
        return obj -> g.apply((AnycastIpListCollection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AnycastIpListSummary> items = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private String nextMarker;
        private Integer maxItems;
        private Boolean isTruncated;
        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(AnycastIpListCollection model) {
            this.items(model.items);
            this.marker(model.marker);
            this.nextMarker(model.nextMarker);
            this.maxItems(model.maxItems);
            this.isTruncated(model.isTruncated);
            this.quantity(model.quantity);
        }

        public final List<AnycastIpListSummary.Builder> getItems() {
            List<AnycastIpListSummary.Builder> result = AnycastIpListSummariesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AnycastIpListSummary.BuilderImpl> items) {
            this.items = AnycastIpListSummariesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AnycastIpListSummary> items) {
            this.items = AnycastIpListSummariesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AnycastIpListSummary ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AnycastIpListSummary.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (AnycastIpListSummary)((AnycastIpListSummary.Builder)AnycastIpListSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public AnycastIpListCollection build() {
            return new AnycastIpListCollection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnycastIpListCollection> {
        public Builder items(Collection<AnycastIpListSummary> var1);

        public Builder items(AnycastIpListSummary ... var1);

        public Builder items(Consumer<AnycastIpListSummary.Builder> ... var1);

        public Builder marker(String var1);

        public Builder nextMarker(String var1);

        public Builder maxItems(Integer var1);

        public Builder isTruncated(Boolean var1);

        public Builder quantity(Integer var1);
    }
}

