/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPublicKeyConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetPublicKeyConfigResponse> {
    private static final SdkField<PublicKeyConfig> PUBLIC_KEY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicKeyConfig").getter(GetPublicKeyConfigResponse.getter(GetPublicKeyConfigResponse::publicKeyConfig)).setter(GetPublicKeyConfigResponse.setter(Builder::publicKeyConfig)).constructor(PublicKeyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyConfig").unmarshallLocationName("PublicKeyConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetPublicKeyConfigResponse.getter(GetPublicKeyConfigResponse::eTag)).setter(GetPublicKeyConfigResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_CONFIG_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PublicKeyConfig", PUBLIC_KEY_CONFIG_FIELD);
            this.put("ETag", E_TAG_FIELD);
        }
    });
    private final PublicKeyConfig publicKeyConfig;
    private final String eTag;

    private GetPublicKeyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeyConfig = builder.publicKeyConfig;
        this.eTag = builder.eTag;
    }

    public final PublicKeyConfig publicKeyConfig() {
        return this.publicKeyConfig;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPublicKeyConfigResponse)) {
            return false;
        }
        GetPublicKeyConfigResponse other = (GetPublicKeyConfigResponse)((Object)obj);
        return Objects.equals(this.publicKeyConfig(), other.publicKeyConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetPublicKeyConfigResponse").add("PublicKeyConfig", (Object)this.publicKeyConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicKeyConfig": {
                return Optional.ofNullable(clazz.cast(this.publicKeyConfig()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetPublicKeyConfigResponse, T> g) {
        return obj -> g.apply((GetPublicKeyConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private PublicKeyConfig publicKeyConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPublicKeyConfigResponse model) {
            super(model);
            this.publicKeyConfig(model.publicKeyConfig);
            this.eTag(model.eTag);
        }

        public final PublicKeyConfig.Builder getPublicKeyConfig() {
            return this.publicKeyConfig != null ? this.publicKeyConfig.toBuilder() : null;
        }

        public final void setPublicKeyConfig(PublicKeyConfig.BuilderImpl publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig != null ? publicKeyConfig.build() : null;
        }

        @Override
        public final Builder publicKeyConfig(PublicKeyConfig publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetPublicKeyConfigResponse build() {
            return new GetPublicKeyConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPublicKeyConfigResponse> {
        public Builder publicKeyConfig(PublicKeyConfig var1);

        default public Builder publicKeyConfig(Consumer<PublicKeyConfig.Builder> publicKeyConfig) {
            return this.publicKeyConfig((PublicKeyConfig)((PublicKeyConfig.Builder)PublicKeyConfig.builder().applyMutation(publicKeyConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

