/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContinuousDeploymentPolicyRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateContinuousDeploymentPolicyRequest> {
    private static final SdkField<ContinuousDeploymentPolicyConfig> CONTINUOUS_DEPLOYMENT_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContinuousDeploymentPolicyConfig").getter(CreateContinuousDeploymentPolicyRequest.getter(CreateContinuousDeploymentPolicyRequest::continuousDeploymentPolicyConfig)).setter(CreateContinuousDeploymentPolicyRequest.setter(Builder::continuousDeploymentPolicyConfig)).constructor(ContinuousDeploymentPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousDeploymentPolicyConfig").unmarshallLocationName("ContinuousDeploymentPolicyConfig").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINUOUS_DEPLOYMENT_POLICY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContinuousDeploymentPolicyConfig", CONTINUOUS_DEPLOYMENT_POLICY_CONFIG_FIELD);
        }
    });
    private final ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig;

    private CreateContinuousDeploymentPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.continuousDeploymentPolicyConfig = builder.continuousDeploymentPolicyConfig;
    }

    public final ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig() {
        return this.continuousDeploymentPolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.continuousDeploymentPolicyConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContinuousDeploymentPolicyRequest)) {
            return false;
        }
        CreateContinuousDeploymentPolicyRequest other = (CreateContinuousDeploymentPolicyRequest)((Object)obj);
        return Objects.equals(this.continuousDeploymentPolicyConfig(), other.continuousDeploymentPolicyConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContinuousDeploymentPolicyRequest").add("ContinuousDeploymentPolicyConfig", (Object)this.continuousDeploymentPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinuousDeploymentPolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.continuousDeploymentPolicyConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateContinuousDeploymentPolicyRequest, T> g) {
        return obj -> g.apply((CreateContinuousDeploymentPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContinuousDeploymentPolicyRequest model) {
            super(model);
            this.continuousDeploymentPolicyConfig(model.continuousDeploymentPolicyConfig);
        }

        public final ContinuousDeploymentPolicyConfig.Builder getContinuousDeploymentPolicyConfig() {
            return this.continuousDeploymentPolicyConfig != null ? this.continuousDeploymentPolicyConfig.toBuilder() : null;
        }

        public final void setContinuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfig.BuilderImpl continuousDeploymentPolicyConfig) {
            this.continuousDeploymentPolicyConfig = continuousDeploymentPolicyConfig != null ? continuousDeploymentPolicyConfig.build() : null;
        }

        @Override
        public final Builder continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfig continuousDeploymentPolicyConfig) {
            this.continuousDeploymentPolicyConfig = continuousDeploymentPolicyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContinuousDeploymentPolicyRequest build() {
            return new CreateContinuousDeploymentPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContinuousDeploymentPolicyRequest> {
        public Builder continuousDeploymentPolicyConfig(ContinuousDeploymentPolicyConfig var1);

        default public Builder continuousDeploymentPolicyConfig(Consumer<ContinuousDeploymentPolicyConfig.Builder> continuousDeploymentPolicyConfig) {
            return this.continuousDeploymentPolicyConfig((ContinuousDeploymentPolicyConfig)((ContinuousDeploymentPolicyConfig.Builder)ContinuousDeploymentPolicyConfig.builder().applyMutation(continuousDeploymentPolicyConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

