/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.ConflictingAlias;
import software.amazon.awssdk.services.cloudfront.model.ConflictingAliasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConflictingAliasesList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConflictingAliasesList> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ConflictingAliasesList.getter(ConflictingAliasesList::nextMarker)).setter(ConflictingAliasesList.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ConflictingAliasesList.getter(ConflictingAliasesList::maxItems)).setter(ConflictingAliasesList.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(ConflictingAliasesList.getter(ConflictingAliasesList::quantity)).setter(ConflictingAliasesList.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final SdkField<List<ConflictingAlias>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(ConflictingAliasesList.getter(ConflictingAliasesList::items)).setter(ConflictingAliasesList.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("ConflictingAlias").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConflictingAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictingAlias").unmarshallLocationName("ConflictingAlias").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, MAX_ITEMS_FIELD, QUANTITY_FIELD, ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextMarker", NEXT_MARKER_FIELD);
            this.put("MaxItems", MAX_ITEMS_FIELD);
            this.put("Quantity", QUANTITY_FIELD);
            this.put("Items", ITEMS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String nextMarker;
    private final Integer maxItems;
    private final Integer quantity;
    private final List<ConflictingAlias> items;

    private ConflictingAliasesList(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<ConflictingAlias> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictingAliasesList)) {
            return false;
        }
        ConflictingAliasesList other = (ConflictingAliasesList)obj;
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.quantity(), other.quantity()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"ConflictingAliasesList").add("NextMarker", (Object)this.nextMarker()).add("MaxItems", (Object)this.maxItems()).add("Quantity", (Object)this.quantity()).add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConflictingAliasesList, T> g) {
        return obj -> g.apply((ConflictingAliasesList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private Integer maxItems;
        private Integer quantity;
        private List<ConflictingAlias> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictingAliasesList model) {
            this.nextMarker(model.nextMarker);
            this.maxItems(model.maxItems);
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<ConflictingAlias.Builder> getItems() {
            List<ConflictingAlias.Builder> result = ConflictingAliasesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ConflictingAlias.BuilderImpl> items) {
            this.items = ConflictingAliasesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ConflictingAlias> items) {
            this.items = ConflictingAliasesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ConflictingAlias ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ConflictingAlias.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ConflictingAlias)((ConflictingAlias.Builder)ConflictingAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConflictingAliasesList build() {
            return new ConflictingAliasesList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConflictingAliasesList> {
        public Builder nextMarker(String var1);

        public Builder maxItems(Integer var1);

        public Builder quantity(Integer var1);

        public Builder items(Collection<ConflictingAlias> var1);

        public Builder items(ConflictingAlias ... var1);

        public Builder items(Consumer<ConflictingAlias.Builder> ... var1);
    }
}

