/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyContentSecurityPolicy;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyContentTypeOptions;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyFrameOptions;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyReferrerPolicy;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyStrictTransportSecurity;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyXSSProtection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseHeadersPolicySecurityHeadersConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseHeadersPolicySecurityHeadersConfig> {
    private static final SdkField<ResponseHeadersPolicyXSSProtection> XSS_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XSSProtection").getter(ResponseHeadersPolicySecurityHeadersConfig.getter(ResponseHeadersPolicySecurityHeadersConfig::xssProtection)).setter(ResponseHeadersPolicySecurityHeadersConfig.setter(Builder::xssProtection)).constructor(ResponseHeadersPolicyXSSProtection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XSSProtection").unmarshallLocationName("XSSProtection").build()}).build();
    private static final SdkField<ResponseHeadersPolicyFrameOptions> FRAME_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameOptions").getter(ResponseHeadersPolicySecurityHeadersConfig.getter(ResponseHeadersPolicySecurityHeadersConfig::frameOptions)).setter(ResponseHeadersPolicySecurityHeadersConfig.setter(Builder::frameOptions)).constructor(ResponseHeadersPolicyFrameOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameOptions").unmarshallLocationName("FrameOptions").build()}).build();
    private static final SdkField<ResponseHeadersPolicyReferrerPolicy> REFERRER_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReferrerPolicy").getter(ResponseHeadersPolicySecurityHeadersConfig.getter(ResponseHeadersPolicySecurityHeadersConfig::referrerPolicy)).setter(ResponseHeadersPolicySecurityHeadersConfig.setter(Builder::referrerPolicy)).constructor(ResponseHeadersPolicyReferrerPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferrerPolicy").unmarshallLocationName("ReferrerPolicy").build()}).build();
    private static final SdkField<ResponseHeadersPolicyContentSecurityPolicy> CONTENT_SECURITY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentSecurityPolicy").getter(ResponseHeadersPolicySecurityHeadersConfig.getter(ResponseHeadersPolicySecurityHeadersConfig::contentSecurityPolicy)).setter(ResponseHeadersPolicySecurityHeadersConfig.setter(Builder::contentSecurityPolicy)).constructor(ResponseHeadersPolicyContentSecurityPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSecurityPolicy").unmarshallLocationName("ContentSecurityPolicy").build()}).build();
    private static final SdkField<ResponseHeadersPolicyContentTypeOptions> CONTENT_TYPE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentTypeOptions").getter(ResponseHeadersPolicySecurityHeadersConfig.getter(ResponseHeadersPolicySecurityHeadersConfig::contentTypeOptions)).setter(ResponseHeadersPolicySecurityHeadersConfig.setter(Builder::contentTypeOptions)).constructor(ResponseHeadersPolicyContentTypeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTypeOptions").unmarshallLocationName("ContentTypeOptions").build()}).build();
    private static final SdkField<ResponseHeadersPolicyStrictTransportSecurity> STRICT_TRANSPORT_SECURITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StrictTransportSecurity").getter(ResponseHeadersPolicySecurityHeadersConfig.getter(ResponseHeadersPolicySecurityHeadersConfig::strictTransportSecurity)).setter(ResponseHeadersPolicySecurityHeadersConfig.setter(Builder::strictTransportSecurity)).constructor(ResponseHeadersPolicyStrictTransportSecurity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StrictTransportSecurity").unmarshallLocationName("StrictTransportSecurity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(XSS_PROTECTION_FIELD, FRAME_OPTIONS_FIELD, REFERRER_POLICY_FIELD, CONTENT_SECURITY_POLICY_FIELD, CONTENT_TYPE_OPTIONS_FIELD, STRICT_TRANSPORT_SECURITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("XSSProtection", XSS_PROTECTION_FIELD);
            this.put("FrameOptions", FRAME_OPTIONS_FIELD);
            this.put("ReferrerPolicy", REFERRER_POLICY_FIELD);
            this.put("ContentSecurityPolicy", CONTENT_SECURITY_POLICY_FIELD);
            this.put("ContentTypeOptions", CONTENT_TYPE_OPTIONS_FIELD);
            this.put("StrictTransportSecurity", STRICT_TRANSPORT_SECURITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ResponseHeadersPolicyXSSProtection xssProtection;
    private final ResponseHeadersPolicyFrameOptions frameOptions;
    private final ResponseHeadersPolicyReferrerPolicy referrerPolicy;
    private final ResponseHeadersPolicyContentSecurityPolicy contentSecurityPolicy;
    private final ResponseHeadersPolicyContentTypeOptions contentTypeOptions;
    private final ResponseHeadersPolicyStrictTransportSecurity strictTransportSecurity;

    private ResponseHeadersPolicySecurityHeadersConfig(BuilderImpl builder) {
        this.xssProtection = builder.xssProtection;
        this.frameOptions = builder.frameOptions;
        this.referrerPolicy = builder.referrerPolicy;
        this.contentSecurityPolicy = builder.contentSecurityPolicy;
        this.contentTypeOptions = builder.contentTypeOptions;
        this.strictTransportSecurity = builder.strictTransportSecurity;
    }

    public final ResponseHeadersPolicyXSSProtection xssProtection() {
        return this.xssProtection;
    }

    public final ResponseHeadersPolicyFrameOptions frameOptions() {
        return this.frameOptions;
    }

    public final ResponseHeadersPolicyReferrerPolicy referrerPolicy() {
        return this.referrerPolicy;
    }

    public final ResponseHeadersPolicyContentSecurityPolicy contentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    public final ResponseHeadersPolicyContentTypeOptions contentTypeOptions() {
        return this.contentTypeOptions;
    }

    public final ResponseHeadersPolicyStrictTransportSecurity strictTransportSecurity() {
        return this.strictTransportSecurity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.xssProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.referrerPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentSecurityPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.strictTransportSecurity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicySecurityHeadersConfig)) {
            return false;
        }
        ResponseHeadersPolicySecurityHeadersConfig other = (ResponseHeadersPolicySecurityHeadersConfig)obj;
        return Objects.equals(this.xssProtection(), other.xssProtection()) && Objects.equals(this.frameOptions(), other.frameOptions()) && Objects.equals(this.referrerPolicy(), other.referrerPolicy()) && Objects.equals(this.contentSecurityPolicy(), other.contentSecurityPolicy()) && Objects.equals(this.contentTypeOptions(), other.contentTypeOptions()) && Objects.equals(this.strictTransportSecurity(), other.strictTransportSecurity());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseHeadersPolicySecurityHeadersConfig").add("XSSProtection", (Object)this.xssProtection()).add("FrameOptions", (Object)this.frameOptions()).add("ReferrerPolicy", (Object)this.referrerPolicy()).add("ContentSecurityPolicy", (Object)this.contentSecurityPolicy()).add("ContentTypeOptions", (Object)this.contentTypeOptions()).add("StrictTransportSecurity", (Object)this.strictTransportSecurity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "XSSProtection": {
                return Optional.ofNullable(clazz.cast(this.xssProtection()));
            }
            case "FrameOptions": {
                return Optional.ofNullable(clazz.cast(this.frameOptions()));
            }
            case "ReferrerPolicy": {
                return Optional.ofNullable(clazz.cast(this.referrerPolicy()));
            }
            case "ContentSecurityPolicy": {
                return Optional.ofNullable(clazz.cast(this.contentSecurityPolicy()));
            }
            case "ContentTypeOptions": {
                return Optional.ofNullable(clazz.cast(this.contentTypeOptions()));
            }
            case "StrictTransportSecurity": {
                return Optional.ofNullable(clazz.cast(this.strictTransportSecurity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicySecurityHeadersConfig, T> g) {
        return obj -> g.apply((ResponseHeadersPolicySecurityHeadersConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResponseHeadersPolicyXSSProtection xssProtection;
        private ResponseHeadersPolicyFrameOptions frameOptions;
        private ResponseHeadersPolicyReferrerPolicy referrerPolicy;
        private ResponseHeadersPolicyContentSecurityPolicy contentSecurityPolicy;
        private ResponseHeadersPolicyContentTypeOptions contentTypeOptions;
        private ResponseHeadersPolicyStrictTransportSecurity strictTransportSecurity;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicySecurityHeadersConfig model) {
            this.xssProtection(model.xssProtection);
            this.frameOptions(model.frameOptions);
            this.referrerPolicy(model.referrerPolicy);
            this.contentSecurityPolicy(model.contentSecurityPolicy);
            this.contentTypeOptions(model.contentTypeOptions);
            this.strictTransportSecurity(model.strictTransportSecurity);
        }

        public final ResponseHeadersPolicyXSSProtection.Builder getXssProtection() {
            return this.xssProtection != null ? this.xssProtection.toBuilder() : null;
        }

        public final void setXssProtection(ResponseHeadersPolicyXSSProtection.BuilderImpl xssProtection) {
            this.xssProtection = xssProtection != null ? xssProtection.build() : null;
        }

        @Override
        public final Builder xssProtection(ResponseHeadersPolicyXSSProtection xssProtection) {
            this.xssProtection = xssProtection;
            return this;
        }

        public final ResponseHeadersPolicyFrameOptions.Builder getFrameOptions() {
            return this.frameOptions != null ? this.frameOptions.toBuilder() : null;
        }

        public final void setFrameOptions(ResponseHeadersPolicyFrameOptions.BuilderImpl frameOptions) {
            this.frameOptions = frameOptions != null ? frameOptions.build() : null;
        }

        @Override
        public final Builder frameOptions(ResponseHeadersPolicyFrameOptions frameOptions) {
            this.frameOptions = frameOptions;
            return this;
        }

        public final ResponseHeadersPolicyReferrerPolicy.Builder getReferrerPolicy() {
            return this.referrerPolicy != null ? this.referrerPolicy.toBuilder() : null;
        }

        public final void setReferrerPolicy(ResponseHeadersPolicyReferrerPolicy.BuilderImpl referrerPolicy) {
            this.referrerPolicy = referrerPolicy != null ? referrerPolicy.build() : null;
        }

        @Override
        public final Builder referrerPolicy(ResponseHeadersPolicyReferrerPolicy referrerPolicy) {
            this.referrerPolicy = referrerPolicy;
            return this;
        }

        public final ResponseHeadersPolicyContentSecurityPolicy.Builder getContentSecurityPolicy() {
            return this.contentSecurityPolicy != null ? this.contentSecurityPolicy.toBuilder() : null;
        }

        public final void setContentSecurityPolicy(ResponseHeadersPolicyContentSecurityPolicy.BuilderImpl contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy != null ? contentSecurityPolicy.build() : null;
        }

        @Override
        public final Builder contentSecurityPolicy(ResponseHeadersPolicyContentSecurityPolicy contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy;
            return this;
        }

        public final ResponseHeadersPolicyContentTypeOptions.Builder getContentTypeOptions() {
            return this.contentTypeOptions != null ? this.contentTypeOptions.toBuilder() : null;
        }

        public final void setContentTypeOptions(ResponseHeadersPolicyContentTypeOptions.BuilderImpl contentTypeOptions) {
            this.contentTypeOptions = contentTypeOptions != null ? contentTypeOptions.build() : null;
        }

        @Override
        public final Builder contentTypeOptions(ResponseHeadersPolicyContentTypeOptions contentTypeOptions) {
            this.contentTypeOptions = contentTypeOptions;
            return this;
        }

        public final ResponseHeadersPolicyStrictTransportSecurity.Builder getStrictTransportSecurity() {
            return this.strictTransportSecurity != null ? this.strictTransportSecurity.toBuilder() : null;
        }

        public final void setStrictTransportSecurity(ResponseHeadersPolicyStrictTransportSecurity.BuilderImpl strictTransportSecurity) {
            this.strictTransportSecurity = strictTransportSecurity != null ? strictTransportSecurity.build() : null;
        }

        @Override
        public final Builder strictTransportSecurity(ResponseHeadersPolicyStrictTransportSecurity strictTransportSecurity) {
            this.strictTransportSecurity = strictTransportSecurity;
            return this;
        }

        public ResponseHeadersPolicySecurityHeadersConfig build() {
            return new ResponseHeadersPolicySecurityHeadersConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseHeadersPolicySecurityHeadersConfig> {
        public Builder xssProtection(ResponseHeadersPolicyXSSProtection var1);

        default public Builder xssProtection(Consumer<ResponseHeadersPolicyXSSProtection.Builder> xssProtection) {
            return this.xssProtection((ResponseHeadersPolicyXSSProtection)((ResponseHeadersPolicyXSSProtection.Builder)ResponseHeadersPolicyXSSProtection.builder().applyMutation(xssProtection)).build());
        }

        public Builder frameOptions(ResponseHeadersPolicyFrameOptions var1);

        default public Builder frameOptions(Consumer<ResponseHeadersPolicyFrameOptions.Builder> frameOptions) {
            return this.frameOptions((ResponseHeadersPolicyFrameOptions)((ResponseHeadersPolicyFrameOptions.Builder)ResponseHeadersPolicyFrameOptions.builder().applyMutation(frameOptions)).build());
        }

        public Builder referrerPolicy(ResponseHeadersPolicyReferrerPolicy var1);

        default public Builder referrerPolicy(Consumer<ResponseHeadersPolicyReferrerPolicy.Builder> referrerPolicy) {
            return this.referrerPolicy((ResponseHeadersPolicyReferrerPolicy)((ResponseHeadersPolicyReferrerPolicy.Builder)ResponseHeadersPolicyReferrerPolicy.builder().applyMutation(referrerPolicy)).build());
        }

        public Builder contentSecurityPolicy(ResponseHeadersPolicyContentSecurityPolicy var1);

        default public Builder contentSecurityPolicy(Consumer<ResponseHeadersPolicyContentSecurityPolicy.Builder> contentSecurityPolicy) {
            return this.contentSecurityPolicy((ResponseHeadersPolicyContentSecurityPolicy)((ResponseHeadersPolicyContentSecurityPolicy.Builder)ResponseHeadersPolicyContentSecurityPolicy.builder().applyMutation(contentSecurityPolicy)).build());
        }

        public Builder contentTypeOptions(ResponseHeadersPolicyContentTypeOptions var1);

        default public Builder contentTypeOptions(Consumer<ResponseHeadersPolicyContentTypeOptions.Builder> contentTypeOptions) {
            return this.contentTypeOptions((ResponseHeadersPolicyContentTypeOptions)((ResponseHeadersPolicyContentTypeOptions.Builder)ResponseHeadersPolicyContentTypeOptions.builder().applyMutation(contentTypeOptions)).build());
        }

        public Builder strictTransportSecurity(ResponseHeadersPolicyStrictTransportSecurity var1);

        default public Builder strictTransportSecurity(Consumer<ResponseHeadersPolicyStrictTransportSecurity.Builder> strictTransportSecurity) {
            return this.strictTransportSecurity((ResponseHeadersPolicyStrictTransportSecurity)((ResponseHeadersPolicyStrictTransportSecurity.Builder)ResponseHeadersPolicyStrictTransportSecurity.builder().applyMutation(strictTransportSecurity)).build());
        }
    }
}

