/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResponseHeadersPoliciesResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListResponseHeadersPoliciesResponse> {
    private static final SdkField<ResponseHeadersPolicyList> RESPONSE_HEADERS_POLICY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResponseHeadersPolicyList").getter(ListResponseHeadersPoliciesResponse.getter(ListResponseHeadersPoliciesResponse::responseHeadersPolicyList)).setter(ListResponseHeadersPoliciesResponse.setter(Builder::responseHeadersPolicyList)).constructor(ResponseHeadersPolicyList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicyList").unmarshallLocationName("ResponseHeadersPolicyList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSE_HEADERS_POLICY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResponseHeadersPolicyList", RESPONSE_HEADERS_POLICY_LIST_FIELD);
        }
    });
    private final ResponseHeadersPolicyList responseHeadersPolicyList;

    private ListResponseHeadersPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.responseHeadersPolicyList = builder.responseHeadersPolicyList;
    }

    public final ResponseHeadersPolicyList responseHeadersPolicyList() {
        return this.responseHeadersPolicyList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.responseHeadersPolicyList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResponseHeadersPoliciesResponse)) {
            return false;
        }
        ListResponseHeadersPoliciesResponse other = (ListResponseHeadersPoliciesResponse)((Object)obj);
        return Objects.equals(this.responseHeadersPolicyList(), other.responseHeadersPolicyList());
    }

    public final String toString() {
        return ToString.builder((String)"ListResponseHeadersPoliciesResponse").add("ResponseHeadersPolicyList", (Object)this.responseHeadersPolicyList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResponseHeadersPolicyList": {
                return Optional.ofNullable(clazz.cast(this.responseHeadersPolicyList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListResponseHeadersPoliciesResponse, T> g) {
        return obj -> g.apply((ListResponseHeadersPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private ResponseHeadersPolicyList responseHeadersPolicyList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResponseHeadersPoliciesResponse model) {
            super(model);
            this.responseHeadersPolicyList(model.responseHeadersPolicyList);
        }

        public final ResponseHeadersPolicyList.Builder getResponseHeadersPolicyList() {
            return this.responseHeadersPolicyList != null ? this.responseHeadersPolicyList.toBuilder() : null;
        }

        public final void setResponseHeadersPolicyList(ResponseHeadersPolicyList.BuilderImpl responseHeadersPolicyList) {
            this.responseHeadersPolicyList = responseHeadersPolicyList != null ? responseHeadersPolicyList.build() : null;
        }

        @Override
        public final Builder responseHeadersPolicyList(ResponseHeadersPolicyList responseHeadersPolicyList) {
            this.responseHeadersPolicyList = responseHeadersPolicyList;
            return this;
        }

        @Override
        public ListResponseHeadersPoliciesResponse build() {
            return new ListResponseHeadersPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResponseHeadersPoliciesResponse> {
        public Builder responseHeadersPolicyList(ResponseHeadersPolicyList var1);

        default public Builder responseHeadersPolicyList(Consumer<ResponseHeadersPolicyList.Builder> responseHeadersPolicyList) {
            return this.responseHeadersPolicyList((ResponseHeadersPolicyList)((ResponseHeadersPolicyList.Builder)ResponseHeadersPolicyList.builder().applyMutation(responseHeadersPolicyList)).build());
        }
    }
}

