/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Session stickiness provides the ability to define multiple requests from a single viewer as a single session. This
 * prevents the potentially inconsistent experience of sending some of a given user's requests to your staging
 * distribution, while others are sent to your primary distribution. Define the session duration using TTL values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionStickinessConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionStickinessConfig.Builder, SessionStickinessConfig> {
    private static final SdkField<Integer> IDLE_TTL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdleTTL")
            .getter(getter(SessionStickinessConfig::idleTTL))
            .setter(setter(Builder::idleTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleTTL")
                    .unmarshallLocationName("IdleTTL").build()).build();

    private static final SdkField<Integer> MAXIMUM_TTL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumTTL")
            .getter(getter(SessionStickinessConfig::maximumTTL))
            .setter(setter(Builder::maximumTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumTTL")
                    .unmarshallLocationName("MaximumTTL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDLE_TTL_FIELD,
            MAXIMUM_TTL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer idleTTL;

    private final Integer maximumTTL;

    private SessionStickinessConfig(BuilderImpl builder) {
        this.idleTTL = builder.idleTTL;
        this.maximumTTL = builder.maximumTTL;
    }

    /**
     * <p>
     * The amount of time after which you want sessions to cease if no requests are received. Allowed values are
     * 300–3600 seconds (5–60 minutes).
     * </p>
     * <p>
     * The value must be less than or equal to <code>MaximumTTL</code>.
     * </p>
     * 
     * @return The amount of time after which you want sessions to cease if no requests are received. Allowed values are
     *         300–3600 seconds (5–60 minutes).</p>
     *         <p>
     *         The value must be less than or equal to <code>MaximumTTL</code>.
     */
    public final Integer idleTTL() {
        return idleTTL;
    }

    /**
     * <p>
     * The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed values
     * are 300–3600 seconds (5–60 minutes).
     * </p>
     * <p>
     * The value must be greater than or equal to <code>IdleTTL</code>.
     * </p>
     * 
     * @return The maximum amount of time to consider requests from the viewer as being part of the same session.
     *         Allowed values are 300–3600 seconds (5–60 minutes).</p>
     *         <p>
     *         The value must be greater than or equal to <code>IdleTTL</code>.
     */
    public final Integer maximumTTL() {
        return maximumTTL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idleTTL());
        hashCode = 31 * hashCode + Objects.hashCode(maximumTTL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionStickinessConfig)) {
            return false;
        }
        SessionStickinessConfig other = (SessionStickinessConfig) obj;
        return Objects.equals(idleTTL(), other.idleTTL()) && Objects.equals(maximumTTL(), other.maximumTTL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionStickinessConfig").add("IdleTTL", idleTTL()).add("MaximumTTL", maximumTTL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdleTTL":
            return Optional.ofNullable(clazz.cast(idleTTL()));
        case "MaximumTTL":
            return Optional.ofNullable(clazz.cast(maximumTTL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionStickinessConfig, T> g) {
        return obj -> g.apply((SessionStickinessConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionStickinessConfig> {
        /**
         * <p>
         * The amount of time after which you want sessions to cease if no requests are received. Allowed values are
         * 300–3600 seconds (5–60 minutes).
         * </p>
         * <p>
         * The value must be less than or equal to <code>MaximumTTL</code>.
         * </p>
         * 
         * @param idleTTL
         *        The amount of time after which you want sessions to cease if no requests are received. Allowed values
         *        are 300–3600 seconds (5–60 minutes).</p>
         *        <p>
         *        The value must be less than or equal to <code>MaximumTTL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleTTL(Integer idleTTL);

        /**
         * <p>
         * The maximum amount of time to consider requests from the viewer as being part of the same session. Allowed
         * values are 300–3600 seconds (5–60 minutes).
         * </p>
         * <p>
         * The value must be greater than or equal to <code>IdleTTL</code>.
         * </p>
         * 
         * @param maximumTTL
         *        The maximum amount of time to consider requests from the viewer as being part of the same session.
         *        Allowed values are 300–3600 seconds (5–60 minutes).</p>
         *        <p>
         *        The value must be greater than or equal to <code>IdleTTL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumTTL(Integer maximumTTL);
    }

    static final class BuilderImpl implements Builder {
        private Integer idleTTL;

        private Integer maximumTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionStickinessConfig model) {
            idleTTL(model.idleTTL);
            maximumTTL(model.maximumTTL);
        }

        public final Integer getIdleTTL() {
            return idleTTL;
        }

        public final void setIdleTTL(Integer idleTTL) {
            this.idleTTL = idleTTL;
        }

        @Override
        public final Builder idleTTL(Integer idleTTL) {
            this.idleTTL = idleTTL;
            return this;
        }

        public final Integer getMaximumTTL() {
            return maximumTTL;
        }

        public final void setMaximumTTL(Integer maximumTTL) {
            this.maximumTTL = maximumTTL;
        }

        @Override
        public final Builder maximumTTL(Integer maximumTTL) {
            this.maximumTTL = maximumTTL;
            return this;
        }

        @Override
        public SessionStickinessConfig build() {
            return new SessionStickinessConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
