/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamingDistributionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateStreamingDistributionRequest.Builder, CreateStreamingDistributionRequest> {
    private static final SdkField<StreamingDistributionConfig> STREAMING_DISTRIBUTION_CONFIG_FIELD = SdkField
            .<StreamingDistributionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("StreamingDistributionConfig")
            .getter(getter(CreateStreamingDistributionRequest::streamingDistributionConfig))
            .setter(setter(Builder::streamingDistributionConfig))
            .constructor(StreamingDistributionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistributionConfig")
                    .unmarshallLocationName("StreamingDistributionConfig").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STREAMING_DISTRIBUTION_CONFIG_FIELD));

    private final StreamingDistributionConfig streamingDistributionConfig;

    private CreateStreamingDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
    }

    /**
     * <p>
     * The streaming distribution's configuration information.
     * </p>
     * 
     * @return The streaming distribution's configuration information.
     */
    public final StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistributionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionRequest)) {
            return false;
        }
        CreateStreamingDistributionRequest other = (CreateStreamingDistributionRequest) obj;
        return Objects.equals(streamingDistributionConfig(), other.streamingDistributionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStreamingDistributionRequest")
                .add("StreamingDistributionConfig", streamingDistributionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistributionConfig":
            return Optional.ofNullable(clazz.cast(streamingDistributionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamingDistributionRequest, T> g) {
        return obj -> g.apply((CreateStreamingDistributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStreamingDistributionRequest> {
        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        The streaming distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);

        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingDistributionConfig.Builder}
         * avoiding the need to create one manually via {@link StreamingDistributionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingDistributionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #streamingDistributionConfig(StreamingDistributionConfig)}.
         * 
         * @param streamingDistributionConfig
         *        a consumer that will call methods on {@link StreamingDistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistributionConfig(StreamingDistributionConfig)
         */
        default Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return streamingDistributionConfig(StreamingDistributionConfig.builder().applyMutation(streamingDistributionConfig)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionRequest model) {
            super(model);
            streamingDistributionConfig(model.streamingDistributionConfig);
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return streamingDistributionConfig != null ? streamingDistributionConfig.toBuilder() : null;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamingDistributionRequest build() {
            return new CreateStreamingDistributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
