/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResponseHeadersPolicyRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateResponseHeadersPolicyRequest.Builder, CreateResponseHeadersPolicyRequest> {
    private static final SdkField<ResponseHeadersPolicyConfig> RESPONSE_HEADERS_POLICY_CONFIG_FIELD = SdkField
            .<ResponseHeadersPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ResponseHeadersPolicyConfig")
            .getter(getter(CreateResponseHeadersPolicyRequest::responseHeadersPolicyConfig))
            .setter(setter(Builder::responseHeadersPolicyConfig))
            .constructor(ResponseHeadersPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicyConfig")
                    .unmarshallLocationName("ResponseHeadersPolicyConfig").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESPONSE_HEADERS_POLICY_CONFIG_FIELD));

    private final ResponseHeadersPolicyConfig responseHeadersPolicyConfig;

    private CreateResponseHeadersPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.responseHeadersPolicyConfig = builder.responseHeadersPolicyConfig;
    }

    /**
     * <p>
     * Contains metadata about the response headers policy, and a set of configurations that specify the HTTP headers.
     * </p>
     * 
     * @return Contains metadata about the response headers policy, and a set of configurations that specify the HTTP
     *         headers.
     */
    public final ResponseHeadersPolicyConfig responseHeadersPolicyConfig() {
        return responseHeadersPolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(responseHeadersPolicyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResponseHeadersPolicyRequest)) {
            return false;
        }
        CreateResponseHeadersPolicyRequest other = (CreateResponseHeadersPolicyRequest) obj;
        return Objects.equals(responseHeadersPolicyConfig(), other.responseHeadersPolicyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResponseHeadersPolicyRequest")
                .add("ResponseHeadersPolicyConfig", responseHeadersPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResponseHeadersPolicyConfig":
            return Optional.ofNullable(clazz.cast(responseHeadersPolicyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResponseHeadersPolicyRequest, T> g) {
        return obj -> g.apply((CreateResponseHeadersPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResponseHeadersPolicyRequest> {
        /**
         * <p>
         * Contains metadata about the response headers policy, and a set of configurations that specify the HTTP
         * headers.
         * </p>
         * 
         * @param responseHeadersPolicyConfig
         *        Contains metadata about the response headers policy, and a set of configurations that specify the HTTP
         *        headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig responseHeadersPolicyConfig);

        /**
         * <p>
         * Contains metadata about the response headers policy, and a set of configurations that specify the HTTP
         * headers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseHeadersPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link ResponseHeadersPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #responseHeadersPolicyConfig(ResponseHeadersPolicyConfig)}.
         * 
         * @param responseHeadersPolicyConfig
         *        a consumer that will call methods on {@link ResponseHeadersPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseHeadersPolicyConfig(ResponseHeadersPolicyConfig)
         */
        default Builder responseHeadersPolicyConfig(Consumer<ResponseHeadersPolicyConfig.Builder> responseHeadersPolicyConfig) {
            return responseHeadersPolicyConfig(ResponseHeadersPolicyConfig.builder().applyMutation(responseHeadersPolicyConfig)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private ResponseHeadersPolicyConfig responseHeadersPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResponseHeadersPolicyRequest model) {
            super(model);
            responseHeadersPolicyConfig(model.responseHeadersPolicyConfig);
        }

        public final ResponseHeadersPolicyConfig.Builder getResponseHeadersPolicyConfig() {
            return responseHeadersPolicyConfig != null ? responseHeadersPolicyConfig.toBuilder() : null;
        }

        public final void setResponseHeadersPolicyConfig(ResponseHeadersPolicyConfig.BuilderImpl responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig != null ? responseHeadersPolicyConfig.build() : null;
        }

        @Override
        public final Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResponseHeadersPolicyRequest build() {
            return new CreateResponseHeadersPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
