/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary;

public class ListStreamingDistributionsIterable
implements SdkIterable<ListStreamingDistributionsResponse> {
    private final CloudFrontClient client;
    private final ListStreamingDistributionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamingDistributionsIterable(CloudFrontClient client, ListStreamingDistributionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStreamingDistributionsResponseFetcher();
    }

    public Iterator<ListStreamingDistributionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamingDistributionSummary> items() {
        Function<ListStreamingDistributionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingDistributionList() != null && response.streamingDistributionList().items() != null) {
                return response.streamingDistributionList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamingDistributionsResponseFetcher
    implements SyncPageFetcher<ListStreamingDistributionsResponse> {
        private ListStreamingDistributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingDistributionsResponse previousPage) {
            return previousPage.streamingDistributionList().isTruncated() != null && previousPage.streamingDistributionList().isTruncated() != false;
        }

        public ListStreamingDistributionsResponse nextPage(ListStreamingDistributionsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingDistributionsIterable.this.client.listStreamingDistributions(ListStreamingDistributionsIterable.this.firstRequest);
            }
            return ListStreamingDistributionsIterable.this.client.listStreamingDistributions((ListStreamingDistributionsRequest)((Object)ListStreamingDistributionsIterable.this.firstRequest.toBuilder().marker(previousPage.streamingDistributionList().nextMarker()).build()));
        }
    }
}

