/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.waiters.CloudFrontWaiter;
import software.amazon.awssdk.services.cloudfront.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultCloudFrontWaiter
implements CloudFrontWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final CloudFrontClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetDistributionResponse> distributionDeployedWaiter;
    private final Waiter<GetInvalidationResponse> invalidationCompletedWaiter;
    private final Waiter<GetStreamingDistributionResponse> streamingDistributionDeployedWaiter;

    private DefaultCloudFrontWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CloudFrontClient)CloudFrontClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.distributionDeployedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetDistributionResponse.class).acceptors(DefaultCloudFrontWaiter.distributionDeployedWaiterAcceptors())).overrideConfiguration(DefaultCloudFrontWaiter.distributionDeployedWaiterConfig(builder.overrideConfiguration))).build();
        this.invalidationCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetInvalidationResponse.class).acceptors(DefaultCloudFrontWaiter.invalidationCompletedWaiterAcceptors())).overrideConfiguration(DefaultCloudFrontWaiter.invalidationCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.streamingDistributionDeployedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetStreamingDistributionResponse.class).acceptors(DefaultCloudFrontWaiter.streamingDistributionDeployedWaiterAcceptors())).overrideConfiguration(DefaultCloudFrontWaiter.streamingDistributionDeployedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetDistributionResponse> waitUntilDistributionDeployed(GetDistributionRequest getDistributionRequest) {
        return this.distributionDeployedWaiter.run(() -> this.client.getDistribution(this.applyWaitersUserAgent(getDistributionRequest)));
    }

    @Override
    public WaiterResponse<GetDistributionResponse> waitUntilDistributionDeployed(GetDistributionRequest getDistributionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.distributionDeployedWaiter.run(() -> this.client.getDistribution(this.applyWaitersUserAgent(getDistributionRequest)), DefaultCloudFrontWaiter.distributionDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetInvalidationResponse> waitUntilInvalidationCompleted(GetInvalidationRequest getInvalidationRequest) {
        return this.invalidationCompletedWaiter.run(() -> this.client.getInvalidation(this.applyWaitersUserAgent(getInvalidationRequest)));
    }

    @Override
    public WaiterResponse<GetInvalidationResponse> waitUntilInvalidationCompleted(GetInvalidationRequest getInvalidationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.invalidationCompletedWaiter.run(() -> this.client.getInvalidation(this.applyWaitersUserAgent(getInvalidationRequest)), DefaultCloudFrontWaiter.invalidationCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetStreamingDistributionResponse> waitUntilStreamingDistributionDeployed(GetStreamingDistributionRequest getStreamingDistributionRequest) {
        return this.streamingDistributionDeployedWaiter.run(() -> this.client.getStreamingDistribution(this.applyWaitersUserAgent(getStreamingDistributionRequest)));
    }

    @Override
    public WaiterResponse<GetStreamingDistributionResponse> waitUntilStreamingDistributionDeployed(GetStreamingDistributionRequest getStreamingDistributionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamingDistributionDeployedWaiter.run(() -> this.client.getStreamingDistribution(this.applyWaitersUserAgent(getStreamingDistributionRequest)), DefaultCloudFrontWaiter.streamingDistributionDeployedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetDistributionResponse>> distributionDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetDistributionResponse>> result = new ArrayList<WaiterAcceptor<? super GetDistributionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Distribution").field("Status").value(), "Deployed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetInvalidationResponse>> invalidationCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetInvalidationResponse>> result = new ArrayList<WaiterAcceptor<? super GetInvalidationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Invalidation").field("Status").value(), "Completed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamingDistributionResponse>> streamingDistributionDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamingDistributionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamingDistributionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("StreamingDistribution").field("Status").value(), "Deployed");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration distributionDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration invalidationCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamingDistributionDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(25);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CloudFrontWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CloudFrontRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFrontRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CloudFrontWaiter.Builder {
        private CloudFrontClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public CloudFrontWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CloudFrontWaiter.Builder client(CloudFrontClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CloudFrontWaiter build() {
            return new DefaultCloudFrontWaiter(this);
        }
    }
}

