/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.KeyGroupConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKeyGroupRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateKeyGroupRequest> {
    private static final SdkField<KeyGroupConfig> KEY_GROUP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyGroupConfig").getter(CreateKeyGroupRequest.getter(CreateKeyGroupRequest::keyGroupConfig)).setter(CreateKeyGroupRequest.setter(Builder::keyGroupConfig)).constructor(KeyGroupConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyGroupConfig").unmarshallLocationName("KeyGroupConfig").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_GROUP_CONFIG_FIELD));
    private final KeyGroupConfig keyGroupConfig;

    private CreateKeyGroupRequest(BuilderImpl builder) {
        super(builder);
        this.keyGroupConfig = builder.keyGroupConfig;
    }

    public final KeyGroupConfig keyGroupConfig() {
        return this.keyGroupConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyGroupConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyGroupRequest)) {
            return false;
        }
        CreateKeyGroupRequest other = (CreateKeyGroupRequest)((Object)obj);
        return Objects.equals(this.keyGroupConfig(), other.keyGroupConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKeyGroupRequest").add("KeyGroupConfig", (Object)this.keyGroupConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyGroupConfig": {
                return Optional.ofNullable(clazz.cast(this.keyGroupConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyGroupRequest, T> g) {
        return obj -> g.apply((CreateKeyGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private KeyGroupConfig keyGroupConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyGroupRequest model) {
            super(model);
            this.keyGroupConfig(model.keyGroupConfig);
        }

        public final KeyGroupConfig.Builder getKeyGroupConfig() {
            return this.keyGroupConfig != null ? this.keyGroupConfig.toBuilder() : null;
        }

        public final void setKeyGroupConfig(KeyGroupConfig.BuilderImpl keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig != null ? keyGroupConfig.build() : null;
        }

        @Override
        public final Builder keyGroupConfig(KeyGroupConfig keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKeyGroupRequest build() {
            return new CreateKeyGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKeyGroupRequest> {
        public Builder keyGroupConfig(KeyGroupConfig var1);

        default public Builder keyGroupConfig(Consumer<KeyGroupConfig.Builder> keyGroupConfig) {
            return this.keyGroupConfig((KeyGroupConfig)((KeyGroupConfig.Builder)KeyGroupConfig.builder().applyMutation(keyGroupConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

