/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code> element or
 * if request URLs don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements. You
 * must create exactly one default cache behavior.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultCacheBehavior implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultCacheBehavior.Builder, DefaultCacheBehavior> {
    private static final SdkField<String> TARGET_ORIGIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetOriginId")
            .getter(getter(DefaultCacheBehavior::targetOriginId))
            .setter(setter(Builder::targetOriginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOriginId")
                    .unmarshallLocationName("TargetOriginId").build()).build();

    private static final SdkField<TrustedSigners> TRUSTED_SIGNERS_FIELD = SdkField
            .<TrustedSigners> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedSigners")
            .getter(getter(DefaultCacheBehavior::trustedSigners))
            .setter(setter(Builder::trustedSigners))
            .constructor(TrustedSigners::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedSigners")
                    .unmarshallLocationName("TrustedSigners").build()).build();

    private static final SdkField<TrustedKeyGroups> TRUSTED_KEY_GROUPS_FIELD = SdkField
            .<TrustedKeyGroups> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedKeyGroups")
            .getter(getter(DefaultCacheBehavior::trustedKeyGroups))
            .setter(setter(Builder::trustedKeyGroups))
            .constructor(TrustedKeyGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedKeyGroups")
                    .unmarshallLocationName("TrustedKeyGroups").build()).build();

    private static final SdkField<String> VIEWER_PROTOCOL_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ViewerProtocolPolicy")
            .getter(getter(DefaultCacheBehavior::viewerProtocolPolicyAsString))
            .setter(setter(Builder::viewerProtocolPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerProtocolPolicy")
                    .unmarshallLocationName("ViewerProtocolPolicy").build()).build();

    private static final SdkField<AllowedMethods> ALLOWED_METHODS_FIELD = SdkField
            .<AllowedMethods> builder(MarshallingType.SDK_POJO)
            .memberName("AllowedMethods")
            .getter(getter(DefaultCacheBehavior::allowedMethods))
            .setter(setter(Builder::allowedMethods))
            .constructor(AllowedMethods::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMethods")
                    .unmarshallLocationName("AllowedMethods").build()).build();

    private static final SdkField<Boolean> SMOOTH_STREAMING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SmoothStreaming")
            .getter(getter(DefaultCacheBehavior::smoothStreaming))
            .setter(setter(Builder::smoothStreaming))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmoothStreaming")
                    .unmarshallLocationName("SmoothStreaming").build()).build();

    private static final SdkField<Boolean> COMPRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Compress")
            .getter(getter(DefaultCacheBehavior::compress))
            .setter(setter(Builder::compress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compress")
                    .unmarshallLocationName("Compress").build()).build();

    private static final SdkField<LambdaFunctionAssociations> LAMBDA_FUNCTION_ASSOCIATIONS_FIELD = SdkField
            .<LambdaFunctionAssociations> builder(MarshallingType.SDK_POJO)
            .memberName("LambdaFunctionAssociations")
            .getter(getter(DefaultCacheBehavior::lambdaFunctionAssociations))
            .setter(setter(Builder::lambdaFunctionAssociations))
            .constructor(LambdaFunctionAssociations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionAssociations")
                    .unmarshallLocationName("LambdaFunctionAssociations").build()).build();

    private static final SdkField<FunctionAssociations> FUNCTION_ASSOCIATIONS_FIELD = SdkField
            .<FunctionAssociations> builder(MarshallingType.SDK_POJO)
            .memberName("FunctionAssociations")
            .getter(getter(DefaultCacheBehavior::functionAssociations))
            .setter(setter(Builder::functionAssociations))
            .constructor(FunctionAssociations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionAssociations")
                    .unmarshallLocationName("FunctionAssociations").build()).build();

    private static final SdkField<String> FIELD_LEVEL_ENCRYPTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FieldLevelEncryptionId")
            .getter(getter(DefaultCacheBehavior::fieldLevelEncryptionId))
            .setter(setter(Builder::fieldLevelEncryptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionId")
                    .unmarshallLocationName("FieldLevelEncryptionId").build()).build();

    private static final SdkField<String> REALTIME_LOG_CONFIG_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RealtimeLogConfigArn")
            .getter(getter(DefaultCacheBehavior::realtimeLogConfigArn))
            .setter(setter(Builder::realtimeLogConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfigArn")
                    .unmarshallLocationName("RealtimeLogConfigArn").build()).build();

    private static final SdkField<String> CACHE_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CachePolicyId")
            .getter(getter(DefaultCacheBehavior::cachePolicyId))
            .setter(setter(Builder::cachePolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyId")
                    .unmarshallLocationName("CachePolicyId").build()).build();

    private static final SdkField<String> ORIGIN_REQUEST_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OriginRequestPolicyId")
            .getter(getter(DefaultCacheBehavior::originRequestPolicyId))
            .setter(setter(Builder::originRequestPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicyId")
                    .unmarshallLocationName("OriginRequestPolicyId").build()).build();

    private static final SdkField<String> RESPONSE_HEADERS_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResponseHeadersPolicyId")
            .getter(getter(DefaultCacheBehavior::responseHeadersPolicyId))
            .setter(setter(Builder::responseHeadersPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicyId")
                    .unmarshallLocationName("ResponseHeadersPolicyId").build()).build();

    private static final SdkField<ForwardedValues> FORWARDED_VALUES_FIELD = SdkField
            .<ForwardedValues> builder(MarshallingType.SDK_POJO)
            .memberName("ForwardedValues")
            .getter(getter(DefaultCacheBehavior::forwardedValues))
            .setter(setter(Builder::forwardedValues))
            .constructor(ForwardedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedValues")
                    .unmarshallLocationName("ForwardedValues").build()).build();

    private static final SdkField<Long> MIN_TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MinTTL")
            .getter(getter(DefaultCacheBehavior::minTTL))
            .setter(setter(Builder::minTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTTL")
                    .unmarshallLocationName("MinTTL").build()).build();

    private static final SdkField<Long> DEFAULT_TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("DefaultTTL")
            .getter(getter(DefaultCacheBehavior::defaultTTL))
            .setter(setter(Builder::defaultTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTTL")
                    .unmarshallLocationName("DefaultTTL").build()).build();

    private static final SdkField<Long> MAX_TTL_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MaxTTL")
            .getter(getter(DefaultCacheBehavior::maxTTL))
            .setter(setter(Builder::maxTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTTL")
                    .unmarshallLocationName("MaxTTL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ORIGIN_ID_FIELD,
            TRUSTED_SIGNERS_FIELD, TRUSTED_KEY_GROUPS_FIELD, VIEWER_PROTOCOL_POLICY_FIELD, ALLOWED_METHODS_FIELD,
            SMOOTH_STREAMING_FIELD, COMPRESS_FIELD, LAMBDA_FUNCTION_ASSOCIATIONS_FIELD, FUNCTION_ASSOCIATIONS_FIELD,
            FIELD_LEVEL_ENCRYPTION_ID_FIELD, REALTIME_LOG_CONFIG_ARN_FIELD, CACHE_POLICY_ID_FIELD,
            ORIGIN_REQUEST_POLICY_ID_FIELD, RESPONSE_HEADERS_POLICY_ID_FIELD, FORWARDED_VALUES_FIELD, MIN_TTL_FIELD,
            DEFAULT_TTL_FIELD, MAX_TTL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetOriginId;

    private final TrustedSigners trustedSigners;

    private final TrustedKeyGroups trustedKeyGroups;

    private final String viewerProtocolPolicy;

    private final AllowedMethods allowedMethods;

    private final Boolean smoothStreaming;

    private final Boolean compress;

    private final LambdaFunctionAssociations lambdaFunctionAssociations;

    private final FunctionAssociations functionAssociations;

    private final String fieldLevelEncryptionId;

    private final String realtimeLogConfigArn;

    private final String cachePolicyId;

    private final String originRequestPolicyId;

    private final String responseHeadersPolicyId;

    private final ForwardedValues forwardedValues;

    private final Long minTTL;

    private final Long defaultTTL;

    private final Long maxTTL;

    private DefaultCacheBehavior(BuilderImpl builder) {
        this.targetOriginId = builder.targetOriginId;
        this.trustedSigners = builder.trustedSigners;
        this.trustedKeyGroups = builder.trustedKeyGroups;
        this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        this.allowedMethods = builder.allowedMethods;
        this.smoothStreaming = builder.smoothStreaming;
        this.compress = builder.compress;
        this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
        this.functionAssociations = builder.functionAssociations;
        this.fieldLevelEncryptionId = builder.fieldLevelEncryptionId;
        this.realtimeLogConfigArn = builder.realtimeLogConfigArn;
        this.cachePolicyId = builder.cachePolicyId;
        this.originRequestPolicyId = builder.originRequestPolicyId;
        this.responseHeadersPolicyId = builder.responseHeadersPolicyId;
        this.forwardedValues = builder.forwardedValues;
        this.minTTL = builder.minTTL;
        this.defaultTTL = builder.defaultTTL;
        this.maxTTL = builder.maxTTL;
    }

    /**
     * <p>
     * The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they use the
     * default cache behavior.
     * </p>
     * 
     * @return The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they use
     *         the default cache behavior.
     */
    public final String targetOriginId() {
        return targetOriginId;
    }

    /**
     * <important>
     * <p>
     * We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code>.
     * </p>
     * </important>
     * <p>
     * A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or signed
     * cookies.
     * </p>
     * <p>
     * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all
     * requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront
     * key pair in a trusted signer's Amazon Web Services account. The signed URL or cookie contains information about
     * which public key CloudFront should use to verify the signature. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
     * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return <p>
     *         We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code>.
     *         </p>
     *         </important>
     *         <p>
     *         A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or
     *         signed cookies.
     *         </p>
     *         <p>
     *         When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all
     *         requests that match the cache behavior. The URLs or cookies must be signed with the private key of a
     *         CloudFront key pair in a trusted signer's Amazon Web Services account. The signed URL or cookie contains
     *         information about which public key CloudFront should use to verify the signature. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         private content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
     * </p>
     * <p>
     * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all
     * requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding
     * public key is in the key group. The signed URL or cookie contains information about which public key CloudFront
     * should use to verify the signature. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
     * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
     *         <p>
     *         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for
     *         all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose
     *         corresponding public key is in the key group. The signed URL or cookie contains information about which
     *         public key CloudFront should use to verify the signature. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         private content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final TrustedKeyGroups trustedKeyGroups() {
        return trustedKeyGroups;
    }

    /**
     * <p>
     * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when
     * a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of
     * 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the
     * new URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     * (Forbidden).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about requiring the HTTPS protocol, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html"
     * >Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never
     * to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that
     * you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will
     * return an object from the cache regardless of whether the current request protocol matches the protocol used
     * previously. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
     * Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #viewerProtocolPolicy} will return {@link ViewerProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #viewerProtocolPolicyAsString}.
     * </p>
     * 
     * @return The protocol that viewers can use to access the files in the origin specified by
     *         <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You can
     *         specify the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
     *         code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
     *         request using the new URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     *         (Forbidden).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about requiring the HTTPS protocol, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html"
     *         >Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
     *         never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
     *         recommend that you clear your objects' cache because cached objects are protocol agnostic. That means
     *         that an edge location will return an object from the cache regardless of whether the current request
     *         protocol matches the protocol used previously. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
     *         Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     * @see ViewerProtocolPolicy
     */
    public final ViewerProtocolPolicy viewerProtocolPolicy() {
        return ViewerProtocolPolicy.fromValue(viewerProtocolPolicy);
    }

    /**
     * <p>
     * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when
     * a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code of
     * 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the
     * new URL.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     * (Forbidden).
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about requiring the HTTPS protocol, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html"
     * >Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never
     * to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that
     * you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will
     * return an object from the cache regardless of whether the current request protocol matches the protocol used
     * previously. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
     * Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #viewerProtocolPolicy} will return {@link ViewerProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #viewerProtocolPolicyAsString}.
     * </p>
     * 
     * @return The protocol that viewers can use to access the files in the origin specified by
     *         <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You can
     *         specify the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allow-all</code>: Viewers can use HTTP or HTTPS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
     *         code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
     *         request using the new URL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
     *         (Forbidden).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about requiring the HTTPS protocol, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html"
     *         >Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
     *         never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
     *         recommend that you clear your objects' cache because cached objects are protocol agnostic. That means
     *         that an edge location will return an object from the cache regardless of whether the current request
     *         protocol matches the protocol used previously. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
     *         Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     * @see ViewerProtocolPolicy
     */
    public final String viewerProtocolPolicyAsString() {
        return viewerProtocolPolicy;
    }

    /**
     * Returns the value of the AllowedMethods property for this object.
     * 
     * @return The value of the AllowedMethods property for this object.
     */
    public final AllowedMethods allowedMethods() {
        return allowedMethods;
    }

    /**
     * <p>
     * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin
     * that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify <code>false</code>
     * . If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still distribute other content using
     * this cache behavior if the content matches the value of <code>PathPattern</code>.
     * </p>
     * 
     * @return Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the
     *         origin that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify
     *         <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still
     *         distribute other content using this cache behavior if the content matches the value of
     *         <code>PathPattern</code>.
     */
    public final Boolean smoothStreaming() {
        return smoothStreaming;
    }

    /**
     * <p>
     * Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify
     * <code>true</code>; if not, specify <code>false</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving
     * Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Whether you want CloudFront to automatically compress certain files for this cache behavior. If so,
     *         specify <code>true</code>; if not, specify <code>false</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html"
     *         >Serving Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final Boolean compress() {
        return compress;
    }

    /**
     * <p>
     * A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
     * </p>
     * 
     * @return A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
     */
    public final LambdaFunctionAssociations lambdaFunctionAssociations() {
        return lambdaFunctionAssociations;
    }

    /**
     * <p>
     * A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be
     * published to the <code>LIVE</code> stage to associate them with a cache behavior.
     * </p>
     * 
     * @return A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be
     *         published to the <code>LIVE</code> stage to associate them with a cache behavior.
     */
    public final FunctionAssociations functionAssociations() {
        return functionAssociations;
    }

    /**
     * <p>
     * The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for
     * encrypting specific fields of data for the default cache behavior.
     * </p>
     * 
     * @return The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use
     *         for encrypting specific fields of data for the default cache behavior.
     */
    public final String fieldLevelEncryptionId() {
        return fieldLevelEncryptionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache
     *         behavior. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time
     *         logs</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final String realtimeLogConfigArn() {
        return realtimeLogConfigArn;
    }

    /**
     * <p>
     * The unique identifier of the cache policy that is attached to the default cache behavior. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using
     * the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
     * <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
     * </p>
     * 
     * @return The unique identifier of the cache policy that is attached to the default cache behavior. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
     *         >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
     *         <p>
     *         A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
     *         <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
     */
    public final String cachePolicyId() {
        return cachePolicyId;
    }

    /**
     * <p>
     * The unique identifier of the origin request policy that is attached to the default cache behavior. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> or <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
     * >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The unique identifier of the origin request policy that is attached to the default cache behavior. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
     *         >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final String originRequestPolicyId() {
        return originRequestPolicyId;
    }

    /**
     * <p>
     * The identifier for a response headers policy.
     * </p>
     * 
     * @return The identifier for a response headers policy.
     */
    public final String responseHeadersPolicyId() {
        return responseHeadersPolicyId;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this
     * field. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with
     * policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to include values in the cache key, use a cache policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using
     * the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to send values to the origin but not include them in the cache key, use an origin request policy. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> or <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
     * >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
     * <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
     * </p>
     * <p>
     * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
     *         this field. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html"
     *         >Working with policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
     *         <p>
     *         If you want to include values in the cache key, use a cache policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
     *         >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you want to send values to the origin but not include them in the cache key, use an origin request
     *         policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
     *         >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
     *         <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
     *         </p>
     *         <p>
     *         A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
     * @deprecated
     */
    @Deprecated
    public final ForwardedValues forwardedValues() {
        return forwardedValues;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache policy instead of
     * this field. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using
     * the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another
     * request to your origin to determine whether the object has been updated. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
     * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to
     * your origin (under <code>Headers</code>, if you specify <code>1</code> for <code>Quantity</code> and
     * <code>*</code> for <code>Name</code>).
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache policy
     *         instead of this field. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
     *         >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
     *         <p>
     *         The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
     *         another request to your origin to determine whether the object has been updated. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing
     *         How Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all
     *         headers to your origin (under <code>Headers</code>, if you specify <code>1</code> for
     *         <code>Quantity</code> and <code>*</code> for <code>Name</code>).
     * @deprecated
     */
    @Deprecated
    public final Long minTTL() {
        return minTTL;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a cache policy instead
     * of this field. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using
     * the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another
     * request to your origin to determine whether the object has been updated. The value that you specify applies only
     * when your origin does not add HTTP headers such as <code>Cache-Control max-age</code>,
     * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
     * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a cache policy
     *         instead of this field. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
     *         >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
     *         <p>
     *         The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
     *         another request to your origin to determine whether the object has been updated. The value that you
     *         specify applies only when your origin does not add HTTP headers such as
     *         <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to
     *         objects. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
     *         Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @deprecated
     */
    @Deprecated
    public final Long defaultTTL() {
        return defaultTTL;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache policy instead of
     * this field. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using
     * the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another
     * request to your origin to determine whether the object has been updated. The value that you specify applies only
     * when your origin adds HTTP headers such as <code>Cache-Control max-age</code>,
     * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
     * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache policy
     *         instead of this field. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> or <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
     *         >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
     *         <p>
     *         The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
     *         another request to your origin to determine whether the object has been updated. The value that you
     *         specify applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code>,
     *         <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
     *         Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @deprecated
     */
    @Deprecated
    public final Long maxTTL() {
        return maxTTL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetOriginId());
        hashCode = 31 * hashCode + Objects.hashCode(trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(trustedKeyGroups());
        hashCode = 31 * hashCode + Objects.hashCode(viewerProtocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(allowedMethods());
        hashCode = 31 * hashCode + Objects.hashCode(smoothStreaming());
        hashCode = 31 * hashCode + Objects.hashCode(compress());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(functionAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionId());
        hashCode = 31 * hashCode + Objects.hashCode(realtimeLogConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(originRequestPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(responseHeadersPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(forwardedValues());
        hashCode = 31 * hashCode + Objects.hashCode(minTTL());
        hashCode = 31 * hashCode + Objects.hashCode(defaultTTL());
        hashCode = 31 * hashCode + Objects.hashCode(maxTTL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCacheBehavior)) {
            return false;
        }
        DefaultCacheBehavior other = (DefaultCacheBehavior) obj;
        return Objects.equals(targetOriginId(), other.targetOriginId())
                && Objects.equals(trustedSigners(), other.trustedSigners())
                && Objects.equals(trustedKeyGroups(), other.trustedKeyGroups())
                && Objects.equals(viewerProtocolPolicyAsString(), other.viewerProtocolPolicyAsString())
                && Objects.equals(allowedMethods(), other.allowedMethods())
                && Objects.equals(smoothStreaming(), other.smoothStreaming()) && Objects.equals(compress(), other.compress())
                && Objects.equals(lambdaFunctionAssociations(), other.lambdaFunctionAssociations())
                && Objects.equals(functionAssociations(), other.functionAssociations())
                && Objects.equals(fieldLevelEncryptionId(), other.fieldLevelEncryptionId())
                && Objects.equals(realtimeLogConfigArn(), other.realtimeLogConfigArn())
                && Objects.equals(cachePolicyId(), other.cachePolicyId())
                && Objects.equals(originRequestPolicyId(), other.originRequestPolicyId())
                && Objects.equals(responseHeadersPolicyId(), other.responseHeadersPolicyId())
                && Objects.equals(forwardedValues(), other.forwardedValues()) && Objects.equals(minTTL(), other.minTTL())
                && Objects.equals(defaultTTL(), other.defaultTTL()) && Objects.equals(maxTTL(), other.maxTTL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultCacheBehavior").add("TargetOriginId", targetOriginId())
                .add("TrustedSigners", trustedSigners()).add("TrustedKeyGroups", trustedKeyGroups())
                .add("ViewerProtocolPolicy", viewerProtocolPolicyAsString()).add("AllowedMethods", allowedMethods())
                .add("SmoothStreaming", smoothStreaming()).add("Compress", compress())
                .add("LambdaFunctionAssociations", lambdaFunctionAssociations())
                .add("FunctionAssociations", functionAssociations()).add("FieldLevelEncryptionId", fieldLevelEncryptionId())
                .add("RealtimeLogConfigArn", realtimeLogConfigArn()).add("CachePolicyId", cachePolicyId())
                .add("OriginRequestPolicyId", originRequestPolicyId()).add("ResponseHeadersPolicyId", responseHeadersPolicyId())
                .add("ForwardedValues", forwardedValues()).add("MinTTL", minTTL()).add("DefaultTTL", defaultTTL())
                .add("MaxTTL", maxTTL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetOriginId":
            return Optional.ofNullable(clazz.cast(targetOriginId()));
        case "TrustedSigners":
            return Optional.ofNullable(clazz.cast(trustedSigners()));
        case "TrustedKeyGroups":
            return Optional.ofNullable(clazz.cast(trustedKeyGroups()));
        case "ViewerProtocolPolicy":
            return Optional.ofNullable(clazz.cast(viewerProtocolPolicyAsString()));
        case "AllowedMethods":
            return Optional.ofNullable(clazz.cast(allowedMethods()));
        case "SmoothStreaming":
            return Optional.ofNullable(clazz.cast(smoothStreaming()));
        case "Compress":
            return Optional.ofNullable(clazz.cast(compress()));
        case "LambdaFunctionAssociations":
            return Optional.ofNullable(clazz.cast(lambdaFunctionAssociations()));
        case "FunctionAssociations":
            return Optional.ofNullable(clazz.cast(functionAssociations()));
        case "FieldLevelEncryptionId":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionId()));
        case "RealtimeLogConfigArn":
            return Optional.ofNullable(clazz.cast(realtimeLogConfigArn()));
        case "CachePolicyId":
            return Optional.ofNullable(clazz.cast(cachePolicyId()));
        case "OriginRequestPolicyId":
            return Optional.ofNullable(clazz.cast(originRequestPolicyId()));
        case "ResponseHeadersPolicyId":
            return Optional.ofNullable(clazz.cast(responseHeadersPolicyId()));
        case "ForwardedValues":
            return Optional.ofNullable(clazz.cast(forwardedValues()));
        case "MinTTL":
            return Optional.ofNullable(clazz.cast(minTTL()));
        case "DefaultTTL":
            return Optional.ofNullable(clazz.cast(defaultTTL()));
        case "MaxTTL":
            return Optional.ofNullable(clazz.cast(maxTTL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultCacheBehavior, T> g) {
        return obj -> g.apply((DefaultCacheBehavior) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultCacheBehavior> {
        /**
         * <p>
         * The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they use the
         * default cache behavior.
         * </p>
         * 
         * @param targetOriginId
         *        The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they
         *        use the default cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetOriginId(String targetOriginId);

        /**
         * <important>
         * <p>
         * We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code>.
         * </p>
         * </important>
         * <p>
         * A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or
         * signed cookies.
         * </p>
         * <p>
         * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all
         * requests that match the cache behavior. The URLs or cookies must be signed with the private key of a
         * CloudFront key pair in a trusted signer's Amazon Web Services account. The signed URL or cookie contains
         * information about which public key CloudFront should use to verify the signature. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         * private content</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param trustedSigners
         *        <p>
         *        We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code>.
         *        </p>
         *        </important>
         *        <p>
         *        A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs
         *        or signed cookies.
         *        </p>
         *        <p>
         *        When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for
         *        all requests that match the cache behavior. The URLs or cookies must be signed with the private key of
         *        a CloudFront key pair in a trusted signer's Amazon Web Services account. The signed URL or cookie
         *        contains information about which public key CloudFront should use to verify the signature. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        private content</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <important>
         * <p>
         * We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code>.
         * </p>
         * </important>
         * <p>
         * A list of Amazon Web Services account IDs whose public keys CloudFront can use to validate signed URLs or
         * signed cookies.
         * </p>
         * <p>
         * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all
         * requests that match the cache behavior. The URLs or cookies must be signed with the private key of a
         * CloudFront key pair in a trusted signer's Amazon Web Services account. The signed URL or cookie contains
         * information about which public key CloudFront should use to verify the signature. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         * private content</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustedSigners.Builder} avoiding the need
         * to create one manually via {@link TrustedSigners#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustedSigners.Builder#build()} is called immediately and its
         * result is passed to {@link #trustedSigners(TrustedSigners)}.
         * 
         * @param trustedSigners
         *        a consumer that will call methods on {@link TrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedSigners(TrustedSigners)
         */
        default Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return trustedSigners(TrustedSigners.builder().applyMutation(trustedSigners).build());
        }

        /**
         * <p>
         * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         * </p>
         * <p>
         * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all
         * requests that match the cache behavior. The URLs or cookies must be signed with a private key whose
         * corresponding public key is in the key group. The signed URL or cookie contains information about which
         * public key CloudFront should use to verify the signature. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
         * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param trustedKeyGroups
         *        A list of key groups that CloudFront can use to validate signed URLs or signed cookies.</p>
         *        <p>
         *        When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies
         *        for all requests that match the cache behavior. The URLs or cookies must be signed with a private key
         *        whose corresponding public key is in the key group. The signed URL or cookie contains information
         *        about which public key CloudFront should use to verify the signature. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        private content</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedKeyGroups(TrustedKeyGroups trustedKeyGroups);

        /**
         * <p>
         * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         * </p>
         * <p>
         * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all
         * requests that match the cache behavior. The URLs or cookies must be signed with a private key whose
         * corresponding public key is in the key group. The signed URL or cookie contains information about which
         * public key CloudFront should use to verify the signature. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
         * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrustedKeyGroups.Builder} avoiding the
         * need to create one manually via {@link TrustedKeyGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustedKeyGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #trustedKeyGroups(TrustedKeyGroups)}.
         * 
         * @param trustedKeyGroups
         *        a consumer that will call methods on {@link TrustedKeyGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedKeyGroups(TrustedKeyGroups)
         */
        default Builder trustedKeyGroups(Consumer<TrustedKeyGroups.Builder> trustedKeyGroups) {
            return trustedKeyGroups(TrustedKeyGroups.builder().applyMutation(trustedKeyGroups).build());
        }

        /**
         * <p>
         * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code>
         * when a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code
         * of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request
         * using the new URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
         * (Forbidden).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about requiring the HTTPS protocol, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html"
         * >Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
         * never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
         * recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an
         * edge location will return an object from the cache regardless of whether the current request protocol matches
         * the protocol used previously. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
         * Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param viewerProtocolPolicy
         *        The protocol that viewers can use to access the files in the origin specified by
         *        <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You
         *        can specify the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
         *        code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
         *        request using the new URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of
         *        403 (Forbidden).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about requiring the HTTPS protocol, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html"
         *        >Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS
         *        is never to use any other protocol to fetch the object. If you have recently changed from HTTP to
         *        HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic.
         *        That means that an edge location will return an object from the cache regardless of whether the
         *        current request protocol matches the protocol used previously. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing
         *        Cache Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         * @see ViewerProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewerProtocolPolicy
         */
        Builder viewerProtocolPolicy(String viewerProtocolPolicy);

        /**
         * <p>
         * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code>
         * when a request matches the path pattern in <code>PathPattern</code>. You can specify the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status code
         * of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request
         * using the new URL.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403
         * (Forbidden).
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about requiring the HTTPS protocol, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html"
         * >Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is
         * never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we
         * recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an
         * edge location will return an object from the cache regardless of whether the current request protocol matches
         * the protocol used previously. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache
         * Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * </note>
         * 
         * @param viewerProtocolPolicy
         *        The protocol that viewers can use to access the files in the origin specified by
         *        <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code>. You
         *        can specify the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allow-all</code>: Viewers can use HTTP or HTTPS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>redirect-to-https</code>: If a viewer submits an HTTP request, CloudFront returns an HTTP status
         *        code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the
         *        request using the new URL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>https-only</code>: If a viewer sends an HTTP request, CloudFront returns an HTTP status code of
         *        403 (Forbidden).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about requiring the HTTPS protocol, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html"
         *        >Requiring HTTPS Between Viewers and CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS
         *        is never to use any other protocol to fetch the object. If you have recently changed from HTTP to
         *        HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic.
         *        That means that an edge location will return an object from the cache regardless of whether the
         *        current request protocol matches the protocol used previously. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing
         *        Cache Expiration</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         * @see ViewerProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewerProtocolPolicy
         */
        Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy);

        /**
         * Sets the value of the AllowedMethods property for this object.
         *
         * @param allowedMethods
         *        The new value for the AllowedMethods property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedMethods(AllowedMethods allowedMethods);

        /**
         * Sets the value of the AllowedMethods property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AllowedMethods.Builder} avoiding the need
         * to create one manually via {@link AllowedMethods#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllowedMethods.Builder#build()} is called immediately and its
         * result is passed to {@link #allowedMethods(AllowedMethods)}.
         * 
         * @param allowedMethods
         *        a consumer that will call methods on {@link AllowedMethods.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedMethods(AllowedMethods)
         */
        default Builder allowedMethods(Consumer<AllowedMethods.Builder> allowedMethods) {
            return allowedMethods(AllowedMethods.builder().applyMutation(allowedMethods).build());
        }

        /**
         * <p>
         * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the
         * origin that is associated with this cache behavior. If so, specify <code>true</code>; if not, specify
         * <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can still
         * distribute other content using this cache behavior if the content matches the value of
         * <code>PathPattern</code>.
         * </p>
         * 
         * @param smoothStreaming
         *        Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using
         *        the origin that is associated with this cache behavior. If so, specify <code>true</code>; if not,
         *        specify <code>false</code>. If you specify <code>true</code> for <code>SmoothStreaming</code>, you can
         *        still distribute other content using this cache behavior if the content matches the value of
         *        <code>PathPattern</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smoothStreaming(Boolean smoothStreaming);

        /**
         * <p>
         * Whether you want CloudFront to automatically compress certain files for this cache behavior. If so, specify
         * <code>true</code>; if not, specify <code>false</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving
         * Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param compress
         *        Whether you want CloudFront to automatically compress certain files for this cache behavior. If so,
         *        specify <code>true</code>; if not, specify <code>false</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html"
         *        >Serving Compressed Files</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compress(Boolean compress);

        /**
         * <p>
         * A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
         * </p>
         * 
         * @param lambdaFunctionAssociations
         *        A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations);

        /**
         * <p>
         * A complex type that contains zero or more Lambda@Edge function associations for a cache behavior.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaFunctionAssociations.Builder}
         * avoiding the need to create one manually via {@link LambdaFunctionAssociations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionAssociations.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaFunctionAssociations(LambdaFunctionAssociations)}.
         * 
         * @param lambdaFunctionAssociations
         *        a consumer that will call methods on {@link LambdaFunctionAssociations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionAssociations(LambdaFunctionAssociations)
         */
        default Builder lambdaFunctionAssociations(Consumer<LambdaFunctionAssociations.Builder> lambdaFunctionAssociations) {
            return lambdaFunctionAssociations(LambdaFunctionAssociations.builder().applyMutation(lambdaFunctionAssociations)
                    .build());
        }

        /**
         * <p>
         * A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be
         * published to the <code>LIVE</code> stage to associate them with a cache behavior.
         * </p>
         * 
         * @param functionAssociations
         *        A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must
         *        be published to the <code>LIVE</code> stage to associate them with a cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionAssociations(FunctionAssociations functionAssociations);

        /**
         * <p>
         * A list of CloudFront functions that are associated with this cache behavior. CloudFront functions must be
         * published to the <code>LIVE</code> stage to associate them with a cache behavior.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionAssociations.Builder} avoiding
         * the need to create one manually via {@link FunctionAssociations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionAssociations.Builder#build()} is called immediately and
         * its result is passed to {@link #functionAssociations(FunctionAssociations)}.
         * 
         * @param functionAssociations
         *        a consumer that will call methods on {@link FunctionAssociations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionAssociations(FunctionAssociations)
         */
        default Builder functionAssociations(Consumer<FunctionAssociations.Builder> functionAssociations) {
            return functionAssociations(FunctionAssociations.builder().applyMutation(functionAssociations).build());
        }

        /**
         * <p>
         * The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for
         * encrypting specific fields of data for the default cache behavior.
         * </p>
         * 
         * @param fieldLevelEncryptionId
         *        The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to
         *        use for encrypting specific fields of data for the default cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionId(String fieldLevelEncryptionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time
         * logs</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param realtimeLogConfigArn
         *        The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache
         *        behavior. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html"
         *        >Real-time logs</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realtimeLogConfigArn(String realtimeLogConfigArn);

        /**
         * <p>
         * The unique identifier of the cache policy that is attached to the default cache behavior. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> or <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         * >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
         * <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
         * </p>
         * 
         * @param cachePolicyId
         *        The unique identifier of the cache policy that is attached to the default cache behavior. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         *        >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
         *        <p>
         *        A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
         *        <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicyId(String cachePolicyId);

        /**
         * <p>
         * The unique identifier of the origin request policy that is attached to the default cache behavior. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
         * >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param originRequestPolicyId
         *        The unique identifier of the origin request policy that is attached to the default cache behavior. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
         *        >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originRequestPolicyId(String originRequestPolicyId);

        /**
         * <p>
         * The identifier for a response headers policy.
         * </p>
         * 
         * @param responseHeadersPolicyId
         *        The identifier for a response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseHeadersPolicyId(String responseHeadersPolicyId);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working
         * with policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to include values in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> or <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         * >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send values to the origin but not include them in the cache key, use an origin request policy.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
         * >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
         * <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
         * </p>
         * <p>
         * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
         * </p>
         * 
         * @param forwardedValues
         *        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead
         *        of this field. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html"
         *        >Working with policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
         *        <p>
         *        If you want to include values in the cache key, use a cache policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         *        >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you want to send values to the origin but not include them in the cache key, use an origin request
         *        policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
         *        >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
         *        <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
         *        </p>
         *        <p>
         *        A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder forwardedValues(ForwardedValues forwardedValues);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working
         * with policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to include values in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> or <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         * >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send values to the origin but not include them in the cache key, use an origin request policy.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> or <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html"
         * >Using the managed origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or
         * <code>ForwardedValues</code>. We recommend that you use a <code>CachePolicyId</code>.
         * </p>
         * <p>
         * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ForwardedValues.Builder} avoiding the
         * need to create one manually via {@link ForwardedValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ForwardedValues.Builder#build()} is called immediately and its
         * result is passed to {@link #forwardedValues(ForwardedValues)}.
         * 
         * @param forwardedValues
         *        a consumer that will call methods on {@link ForwardedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forwardedValues(ForwardedValues)
         * @deprecated
         */
        @Deprecated
        default Builder forwardedValues(Consumer<ForwardedValues.Builder> forwardedValues) {
            return forwardedValues(ForwardedValues.builder().applyMutation(forwardedValues).build());
        }

        /**
         * <p>
         * This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache policy instead
         * of this field. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> or <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         * >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
         * another request to your origin to determine whether the object has been updated. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
         * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to
         * your origin (under <code>Headers</code>, if you specify <code>1</code> for <code>Quantity</code> and
         * <code>*</code> for <code>Name</code>).
         * </p>
         * 
         * @param minTTL
         *        This field is deprecated. We recommend that you use the <code>MinTTL</code> field in a cache policy
         *        instead of this field. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         *        >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
         *        <p>
         *        The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront
         *        forwards another request to your origin to determine whether the object has been updated. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
         *        Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all
         *        headers to your origin (under <code>Headers</code>, if you specify <code>1</code> for
         *        <code>Quantity</code> and <code>*</code> for <code>Name</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder minTTL(Long minTTL);

        /**
         * <p>
         * This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a cache policy
         * instead of this field. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> or <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         * >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
         * another request to your origin to determine whether the object has been updated. The value that you specify
         * applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code>,
         * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
         * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param defaultTTL
         *        This field is deprecated. We recommend that you use the <code>DefaultTTL</code> field in a cache
         *        policy instead of this field. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         *        >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
         *        <p>
         *        The default amount of time that you want objects to stay in CloudFront caches before CloudFront
         *        forwards another request to your origin to determine whether the object has been updated. The value
         *        that you specify applies only when your origin does not add HTTP headers such as
         *        <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to
         *        objects. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
         *        Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder defaultTTL(Long defaultTTL);

        /**
         * <p>
         * This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache policy instead
         * of this field. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> or <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         * >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards
         * another request to your origin to determine whether the object has been updated. The value that you specify
         * applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code>,
         * <code>Cache-Control s-maxage</code>, and <code>Expires</code> to objects. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long
         * Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param maxTTL
         *        This field is deprecated. We recommend that you use the <code>MaxTTL</code> field in a cache policy
         *        instead of this field. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> or <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html"
         *        >Using the managed cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.</p>
         *        <p>
         *        The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront
         *        forwards another request to your origin to determine whether the object has been updated. The value
         *        that you specify applies only when your origin adds HTTP headers such as
         *        <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and <code>Expires</code> to
         *        objects. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How
         *        Long Content Stays in an Edge Cache (Expiration)</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder maxTTL(Long maxTTL);
    }

    static final class BuilderImpl implements Builder {
        private String targetOriginId;

        private TrustedSigners trustedSigners;

        private TrustedKeyGroups trustedKeyGroups;

        private String viewerProtocolPolicy;

        private AllowedMethods allowedMethods;

        private Boolean smoothStreaming;

        private Boolean compress;

        private LambdaFunctionAssociations lambdaFunctionAssociations;

        private FunctionAssociations functionAssociations;

        private String fieldLevelEncryptionId;

        private String realtimeLogConfigArn;

        private String cachePolicyId;

        private String originRequestPolicyId;

        private String responseHeadersPolicyId;

        private ForwardedValues forwardedValues;

        private Long minTTL;

        private Long defaultTTL;

        private Long maxTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultCacheBehavior model) {
            targetOriginId(model.targetOriginId);
            trustedSigners(model.trustedSigners);
            trustedKeyGroups(model.trustedKeyGroups);
            viewerProtocolPolicy(model.viewerProtocolPolicy);
            allowedMethods(model.allowedMethods);
            smoothStreaming(model.smoothStreaming);
            compress(model.compress);
            lambdaFunctionAssociations(model.lambdaFunctionAssociations);
            functionAssociations(model.functionAssociations);
            fieldLevelEncryptionId(model.fieldLevelEncryptionId);
            realtimeLogConfigArn(model.realtimeLogConfigArn);
            cachePolicyId(model.cachePolicyId);
            originRequestPolicyId(model.originRequestPolicyId);
            responseHeadersPolicyId(model.responseHeadersPolicyId);
            forwardedValues(model.forwardedValues);
            minTTL(model.minTTL);
            defaultTTL(model.defaultTTL);
            maxTTL(model.maxTTL);
        }

        public final String getTargetOriginId() {
            return targetOriginId;
        }

        public final void setTargetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
        }

        @Override
        public final Builder targetOriginId(String targetOriginId) {
            this.targetOriginId = targetOriginId;
            return this;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return trustedSigners != null ? trustedSigners.toBuilder() : null;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final TrustedKeyGroups.Builder getTrustedKeyGroups() {
            return trustedKeyGroups != null ? trustedKeyGroups.toBuilder() : null;
        }

        public final void setTrustedKeyGroups(TrustedKeyGroups.BuilderImpl trustedKeyGroups) {
            this.trustedKeyGroups = trustedKeyGroups != null ? trustedKeyGroups.build() : null;
        }

        @Override
        public final Builder trustedKeyGroups(TrustedKeyGroups trustedKeyGroups) {
            this.trustedKeyGroups = trustedKeyGroups;
            return this;
        }

        public final String getViewerProtocolPolicy() {
            return viewerProtocolPolicy;
        }

        public final void setViewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
        }

        @Override
        public final Builder viewerProtocolPolicy(String viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        @Override
        public final Builder viewerProtocolPolicy(ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy(viewerProtocolPolicy == null ? null : viewerProtocolPolicy.toString());
            return this;
        }

        public final AllowedMethods.Builder getAllowedMethods() {
            return allowedMethods != null ? allowedMethods.toBuilder() : null;
        }

        public final void setAllowedMethods(AllowedMethods.BuilderImpl allowedMethods) {
            this.allowedMethods = allowedMethods != null ? allowedMethods.build() : null;
        }

        @Override
        public final Builder allowedMethods(AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        public final Boolean getSmoothStreaming() {
            return smoothStreaming;
        }

        public final void setSmoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
        }

        @Override
        public final Builder smoothStreaming(Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        public final Boolean getCompress() {
            return compress;
        }

        public final void setCompress(Boolean compress) {
            this.compress = compress;
        }

        @Override
        public final Builder compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        public final LambdaFunctionAssociations.Builder getLambdaFunctionAssociations() {
            return lambdaFunctionAssociations != null ? lambdaFunctionAssociations.toBuilder() : null;
        }

        public final void setLambdaFunctionAssociations(LambdaFunctionAssociations.BuilderImpl lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations != null ? lambdaFunctionAssociations.build() : null;
        }

        @Override
        public final Builder lambdaFunctionAssociations(LambdaFunctionAssociations lambdaFunctionAssociations) {
            this.lambdaFunctionAssociations = lambdaFunctionAssociations;
            return this;
        }

        public final FunctionAssociations.Builder getFunctionAssociations() {
            return functionAssociations != null ? functionAssociations.toBuilder() : null;
        }

        public final void setFunctionAssociations(FunctionAssociations.BuilderImpl functionAssociations) {
            this.functionAssociations = functionAssociations != null ? functionAssociations.build() : null;
        }

        @Override
        public final Builder functionAssociations(FunctionAssociations functionAssociations) {
            this.functionAssociations = functionAssociations;
            return this;
        }

        public final String getFieldLevelEncryptionId() {
            return fieldLevelEncryptionId;
        }

        public final void setFieldLevelEncryptionId(String fieldLevelEncryptionId) {
            this.fieldLevelEncryptionId = fieldLevelEncryptionId;
        }

        @Override
        public final Builder fieldLevelEncryptionId(String fieldLevelEncryptionId) {
            this.fieldLevelEncryptionId = fieldLevelEncryptionId;
            return this;
        }

        public final String getRealtimeLogConfigArn() {
            return realtimeLogConfigArn;
        }

        public final void setRealtimeLogConfigArn(String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
        }

        @Override
        public final Builder realtimeLogConfigArn(String realtimeLogConfigArn) {
            this.realtimeLogConfigArn = realtimeLogConfigArn;
            return this;
        }

        public final String getCachePolicyId() {
            return cachePolicyId;
        }

        public final void setCachePolicyId(String cachePolicyId) {
            this.cachePolicyId = cachePolicyId;
        }

        @Override
        public final Builder cachePolicyId(String cachePolicyId) {
            this.cachePolicyId = cachePolicyId;
            return this;
        }

        public final String getOriginRequestPolicyId() {
            return originRequestPolicyId;
        }

        public final void setOriginRequestPolicyId(String originRequestPolicyId) {
            this.originRequestPolicyId = originRequestPolicyId;
        }

        @Override
        public final Builder originRequestPolicyId(String originRequestPolicyId) {
            this.originRequestPolicyId = originRequestPolicyId;
            return this;
        }

        public final String getResponseHeadersPolicyId() {
            return responseHeadersPolicyId;
        }

        public final void setResponseHeadersPolicyId(String responseHeadersPolicyId) {
            this.responseHeadersPolicyId = responseHeadersPolicyId;
        }

        @Override
        public final Builder responseHeadersPolicyId(String responseHeadersPolicyId) {
            this.responseHeadersPolicyId = responseHeadersPolicyId;
            return this;
        }

        @Deprecated
        public final ForwardedValues.Builder getForwardedValues() {
            return forwardedValues != null ? forwardedValues.toBuilder() : null;
        }

        @Deprecated
        public final void setForwardedValues(ForwardedValues.BuilderImpl forwardedValues) {
            this.forwardedValues = forwardedValues != null ? forwardedValues.build() : null;
        }

        @Override
        @Deprecated
        public final Builder forwardedValues(ForwardedValues forwardedValues) {
            this.forwardedValues = forwardedValues;
            return this;
        }

        @Deprecated
        public final Long getMinTTL() {
            return minTTL;
        }

        @Deprecated
        public final void setMinTTL(Long minTTL) {
            this.minTTL = minTTL;
        }

        @Override
        @Deprecated
        public final Builder minTTL(Long minTTL) {
            this.minTTL = minTTL;
            return this;
        }

        @Deprecated
        public final Long getDefaultTTL() {
            return defaultTTL;
        }

        @Deprecated
        public final void setDefaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
        }

        @Override
        @Deprecated
        public final Builder defaultTTL(Long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return this;
        }

        @Deprecated
        public final Long getMaxTTL() {
            return maxTTL;
        }

        @Deprecated
        public final void setMaxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
        }

        @Override
        @Deprecated
        public final Builder maxTTL(Long maxTTL) {
            this.maxTTL = maxTTL;
            return this;
        }

        @Override
        public DefaultCacheBehavior build() {
            return new DefaultCacheBehavior(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
