/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCachePolicyRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, CreateCachePolicyRequest> {
    private static final SdkField<CachePolicyConfig> CACHE_POLICY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CachePolicyConfig").getter(CreateCachePolicyRequest.getter(CreateCachePolicyRequest::cachePolicyConfig)).setter(CreateCachePolicyRequest.setter(Builder::cachePolicyConfig)).constructor(CachePolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyConfig").unmarshallLocationName("CachePolicyConfig").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_POLICY_CONFIG_FIELD));
    private final CachePolicyConfig cachePolicyConfig;

    private CreateCachePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.cachePolicyConfig = builder.cachePolicyConfig;
    }

    public final CachePolicyConfig cachePolicyConfig() {
        return this.cachePolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePolicyConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCachePolicyRequest)) {
            return false;
        }
        CreateCachePolicyRequest other = (CreateCachePolicyRequest)((Object)obj);
        return Objects.equals(this.cachePolicyConfig(), other.cachePolicyConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCachePolicyRequest").add("CachePolicyConfig", (Object)this.cachePolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CachePolicyConfig": {
                return Optional.ofNullable(clazz.cast(this.cachePolicyConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCachePolicyRequest, T> g) {
        return obj -> g.apply((CreateCachePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private CachePolicyConfig cachePolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCachePolicyRequest model) {
            super(model);
            this.cachePolicyConfig(model.cachePolicyConfig);
        }

        public final CachePolicyConfig.Builder getCachePolicyConfig() {
            return this.cachePolicyConfig != null ? this.cachePolicyConfig.toBuilder() : null;
        }

        public final void setCachePolicyConfig(CachePolicyConfig.BuilderImpl cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig != null ? cachePolicyConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCachePolicyRequest build() {
            return new CreateCachePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCachePolicyRequest> {
        public Builder cachePolicyConfig(CachePolicyConfig var1);

        default public Builder cachePolicyConfig(Consumer<CachePolicyConfig.Builder> cachePolicyConfig) {
            return this.cachePolicyConfig((CachePolicyConfig)((CachePolicyConfig.Builder)CachePolicyConfig.builder().applyMutation(cachePolicyConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

