/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasResponse;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.FunctionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FunctionInUseException;
import software.amazon.awssdk.services.cloudfront.model.FunctionSizeLimitExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalDeleteException;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.KeyGroupAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFunctionExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchRealtimeLogConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigOwnerMismatchException;
import software.amazon.awssdk.services.cloudfront.model.ResourceInUseException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionFailedException;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCachePoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithSingleFunctionArnException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsAssociatedToDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginRequestPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysInKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyRealtimeLogConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroupDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.transform.AssociateAliasRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeletePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DescribeFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCachePolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetKeyGroupConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginRequestPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCachePoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListConflictingAliasesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByCachePolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByOriginRequestPolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionProfilesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListKeyGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListOriginRequestPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListRealtimeLogConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.PublishFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TestFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.waiters.CloudFrontAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudFrontAsyncClient
implements CloudFrontAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudFrontAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultCloudFrontAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    public final String serviceName() {
        return "cloudfront";
    }

    @Override
    public CompletableFuture<AssociateAliasResponse> associateAlias(AssociateAliasRequest associateAliasRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, associateAliasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateAlias");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(AssociateAliasResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateAlias").withMarshaller((Marshaller)new AssociateAliasRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateAliasRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateAliasRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$associateAlias$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$associateAlias$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCachePolicyResponse> createCachePolicy(CreateCachePolicyRequest createCachePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createCachePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCachePolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCachePolicy").withMarshaller((Marshaller)new CreateCachePolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCachePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createCachePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createCachePolicy$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createCachePolicy$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCloudFrontOriginAccessIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudFrontOriginAccessIdentity").withMarshaller((Marshaller)new CreateCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCloudFrontOriginAccessIdentityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createCloudFrontOriginAccessIdentity$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createCloudFrontOriginAccessIdentity$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistribution").withMarshaller((Marshaller)new CreateDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDistributionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createDistribution$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createDistribution$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDistributionWithTagsResponse> createDistributionWithTags(CreateDistributionWithTagsRequest createDistributionWithTagsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDistributionWithTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistributionWithTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateDistributionWithTagsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistributionWithTags").withMarshaller((Marshaller)new CreateDistributionWithTagsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDistributionWithTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDistributionWithTagsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createDistributionWithTags$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createDistributionWithTags$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFieldLevelEncryptionConfigResponse> createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFieldLevelEncryptionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFieldLevelEncryptionConfig").withMarshaller((Marshaller)new CreateFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFieldLevelEncryptionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createFieldLevelEncryptionConfig$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createFieldLevelEncryptionConfig$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFieldLevelEncryptionProfileResponse> createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFieldLevelEncryptionProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFieldLevelEncryptionProfile").withMarshaller((Marshaller)new CreateFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFieldLevelEncryptionProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createFieldLevelEncryptionProfile$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createFieldLevelEncryptionProfile$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFunctionResponse> createFunction(CreateFunctionRequest createFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFunction");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFunction").withMarshaller((Marshaller)new CreateFunctionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createFunction$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createFunction$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInvalidationResponse> createInvalidation(CreateInvalidationRequest createInvalidationRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createInvalidationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInvalidation");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInvalidation").withMarshaller((Marshaller)new CreateInvalidationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInvalidationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createInvalidationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createInvalidation$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createInvalidation$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateKeyGroupResponse> createKeyGroup(CreateKeyGroupRequest createKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKeyGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKeyGroup").withMarshaller((Marshaller)new CreateKeyGroupRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createKeyGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createKeyGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createKeyGroup$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createKeyGroup$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMonitoringSubscriptionResponse> createMonitoringSubscription(CreateMonitoringSubscriptionRequest createMonitoringSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createMonitoringSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMonitoringSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateMonitoringSubscriptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMonitoringSubscription").withMarshaller((Marshaller)new CreateMonitoringSubscriptionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createMonitoringSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createMonitoringSubscriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createMonitoringSubscription$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createMonitoringSubscription$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateOriginRequestPolicyResponse> createOriginRequestPolicy(CreateOriginRequestPolicyRequest createOriginRequestPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createOriginRequestPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateOriginRequestPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateOriginRequestPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateOriginRequestPolicy").withMarshaller((Marshaller)new CreateOriginRequestPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createOriginRequestPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createOriginRequestPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createOriginRequestPolicy$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createOriginRequestPolicy$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePublicKeyResponse> createPublicKey(CreatePublicKeyRequest createPublicKeyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePublicKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePublicKey").withMarshaller((Marshaller)new CreatePublicKeyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPublicKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createPublicKeyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createPublicKey$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createPublicKey$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRealtimeLogConfigResponse> createRealtimeLogConfig(CreateRealtimeLogConfigRequest createRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRealtimeLogConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRealtimeLogConfig").withMarshaller((Marshaller)new CreateRealtimeLogConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRealtimeLogConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRealtimeLogConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createRealtimeLogConfig$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createRealtimeLogConfig$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamingDistributionResponse> createStreamingDistribution(CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createStreamingDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStreamingDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamingDistribution").withMarshaller((Marshaller)new CreateStreamingDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStreamingDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStreamingDistributionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createStreamingDistribution$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createStreamingDistribution$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamingDistributionWithTagsResponse> createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, createStreamingDistributionWithTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStreamingDistributionWithTags");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateStreamingDistributionWithTagsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStreamingDistributionWithTags").withMarshaller((Marshaller)new CreateStreamingDistributionWithTagsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStreamingDistributionWithTagsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createStreamingDistributionWithTagsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$createStreamingDistributionWithTags$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$createStreamingDistributionWithTags$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCachePolicyResponse> deleteCachePolicy(DeleteCachePolicyRequest deleteCachePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteCachePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCachePolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCachePolicy").withMarshaller((Marshaller)new DeleteCachePolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCachePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteCachePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteCachePolicy$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteCachePolicy$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCloudFrontOriginAccessIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCloudFrontOriginAccessIdentity").withMarshaller((Marshaller)new DeleteCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCloudFrontOriginAccessIdentityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteCloudFrontOriginAccessIdentity$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteCloudFrontOriginAccessIdentity$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDistribution").withMarshaller((Marshaller)new DeleteDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDistributionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteDistribution$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteDistribution$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFieldLevelEncryptionConfigResponse> deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFieldLevelEncryptionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFieldLevelEncryptionConfig").withMarshaller((Marshaller)new DeleteFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFieldLevelEncryptionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteFieldLevelEncryptionConfig$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteFieldLevelEncryptionConfig$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFieldLevelEncryptionProfileResponse> deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFieldLevelEncryptionProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFieldLevelEncryptionProfile").withMarshaller((Marshaller)new DeleteFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFieldLevelEncryptionProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteFieldLevelEncryptionProfile$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteFieldLevelEncryptionProfile$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFunction");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFunction").withMarshaller((Marshaller)new DeleteFunctionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteFunction$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteFunction$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteKeyGroupResponse> deleteKeyGroup(DeleteKeyGroupRequest deleteKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKeyGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKeyGroup").withMarshaller((Marshaller)new DeleteKeyGroupRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteKeyGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteKeyGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteKeyGroup$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteKeyGroup$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMonitoringSubscriptionResponse> deleteMonitoringSubscription(DeleteMonitoringSubscriptionRequest deleteMonitoringSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteMonitoringSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMonitoringSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteMonitoringSubscriptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMonitoringSubscription").withMarshaller((Marshaller)new DeleteMonitoringSubscriptionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMonitoringSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteMonitoringSubscriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteMonitoringSubscription$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteMonitoringSubscription$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteOriginRequestPolicyResponse> deleteOriginRequestPolicy(DeleteOriginRequestPolicyRequest deleteOriginRequestPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteOriginRequestPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOriginRequestPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteOriginRequestPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOriginRequestPolicy").withMarshaller((Marshaller)new DeleteOriginRequestPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteOriginRequestPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteOriginRequestPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteOriginRequestPolicy$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteOriginRequestPolicy$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePublicKeyResponse> deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deletePublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePublicKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicKey").withMarshaller((Marshaller)new DeletePublicKeyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePublicKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deletePublicKeyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deletePublicKey$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deletePublicKey$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRealtimeLogConfigResponse> deleteRealtimeLogConfig(DeleteRealtimeLogConfigRequest deleteRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRealtimeLogConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRealtimeLogConfig").withMarshaller((Marshaller)new DeleteRealtimeLogConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRealtimeLogConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRealtimeLogConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteRealtimeLogConfig$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteRealtimeLogConfig$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStreamingDistributionResponse> deleteStreamingDistribution(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteStreamingDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStreamingDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStreamingDistribution").withMarshaller((Marshaller)new DeleteStreamingDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStreamingDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteStreamingDistributionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$deleteStreamingDistribution$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$deleteStreamingDistribution$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFunctionResponse> describeFunction(DescribeFunctionRequest describeFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFunction");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFunction").withMarshaller((Marshaller)new DescribeFunctionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$describeFunction$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$describeFunction$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCachePolicyResponse> getCachePolicy(GetCachePolicyRequest getCachePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCachePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCachePolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCachePolicy").withMarshaller((Marshaller)new GetCachePolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCachePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCachePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getCachePolicy$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getCachePolicy$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCachePolicyConfigResponse> getCachePolicyConfig(GetCachePolicyConfigRequest getCachePolicyConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCachePolicyConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCachePolicyConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCachePolicyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCachePolicyConfig").withMarshaller((Marshaller)new GetCachePolicyConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCachePolicyConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCachePolicyConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getCachePolicyConfig$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getCachePolicyConfig$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFrontOriginAccessIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFrontOriginAccessIdentity").withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCloudFrontOriginAccessIdentityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getCloudFrontOriginAccessIdentity$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getCloudFrontOriginAccessIdentity$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCloudFrontOriginAccessIdentityConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFrontOriginAccessIdentityConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFrontOriginAccessIdentityConfig").withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCloudFrontOriginAccessIdentityConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCloudFrontOriginAccessIdentityConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getCloudFrontOriginAccessIdentityConfig$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getCloudFrontOriginAccessIdentityConfig$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionResponse> getDistribution(GetDistributionRequest getDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistribution").withMarshaller((Marshaller)new GetDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getDistribution$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getDistribution$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionConfigResponse> getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDistributionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetDistributionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionConfig").withMarshaller((Marshaller)new GetDistributionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getDistributionConfig$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getDistributionConfig$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFieldLevelEncryptionResponse> getFieldLevelEncryption(GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryption");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryption").withMarshaller((Marshaller)new GetFieldLevelEncryptionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFieldLevelEncryptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFieldLevelEncryptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getFieldLevelEncryption$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getFieldLevelEncryption$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFieldLevelEncryptionConfigResponse> getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionConfig").withMarshaller((Marshaller)new GetFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFieldLevelEncryptionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getFieldLevelEncryptionConfig$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getFieldLevelEncryptionConfig$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFieldLevelEncryptionProfileResponse> getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionProfile").withMarshaller((Marshaller)new GetFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFieldLevelEncryptionProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getFieldLevelEncryptionProfile$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getFieldLevelEncryptionProfile$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFieldLevelEncryptionProfileConfigResponse> getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFieldLevelEncryptionProfileConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFieldLevelEncryptionProfileConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFieldLevelEncryptionProfileConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFieldLevelEncryptionProfileConfig").withMarshaller((Marshaller)new GetFieldLevelEncryptionProfileConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFieldLevelEncryptionProfileConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFieldLevelEncryptionProfileConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getFieldLevelEncryptionProfileConfig$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getFieldLevelEncryptionProfileConfig$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFunctionResponse> getFunction(GetFunctionRequest getFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFunction");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFunction").withMarshaller((Marshaller)new GetFunctionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getFunction$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getFunction$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInvalidationResponse> getInvalidation(GetInvalidationRequest getInvalidationRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInvalidationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInvalidation");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInvalidation").withMarshaller((Marshaller)new GetInvalidationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInvalidationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInvalidationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getInvalidation$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getInvalidation$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetKeyGroupResponse> getKeyGroup(GetKeyGroupRequest getKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyGroup").withMarshaller((Marshaller)new GetKeyGroupRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getKeyGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getKeyGroup$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getKeyGroup$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetKeyGroupConfigResponse> getKeyGroupConfig(GetKeyGroupConfigRequest getKeyGroupConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getKeyGroupConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyGroupConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetKeyGroupConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyGroupConfig").withMarshaller((Marshaller)new GetKeyGroupConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyGroupConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getKeyGroupConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getKeyGroupConfig$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getKeyGroupConfig$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMonitoringSubscriptionResponse> getMonitoringSubscription(GetMonitoringSubscriptionRequest getMonitoringSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMonitoringSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMonitoringSubscription");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMonitoringSubscriptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMonitoringSubscription").withMarshaller((Marshaller)new GetMonitoringSubscriptionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMonitoringSubscriptionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMonitoringSubscriptionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getMonitoringSubscription$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getMonitoringSubscription$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOriginRequestPolicyResponse> getOriginRequestPolicy(GetOriginRequestPolicyRequest getOriginRequestPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getOriginRequestPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOriginRequestPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetOriginRequestPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOriginRequestPolicy").withMarshaller((Marshaller)new GetOriginRequestPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOriginRequestPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getOriginRequestPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getOriginRequestPolicy$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getOriginRequestPolicy$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOriginRequestPolicyConfigResponse> getOriginRequestPolicyConfig(GetOriginRequestPolicyConfigRequest getOriginRequestPolicyConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getOriginRequestPolicyConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOriginRequestPolicyConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetOriginRequestPolicyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOriginRequestPolicyConfig").withMarshaller((Marshaller)new GetOriginRequestPolicyConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOriginRequestPolicyConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getOriginRequestPolicyConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getOriginRequestPolicyConfig$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getOriginRequestPolicyConfig$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPublicKeyResponse> getPublicKey(GetPublicKeyRequest getPublicKeyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKey").withMarshaller((Marshaller)new GetPublicKeyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPublicKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPublicKeyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getPublicKey$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getPublicKey$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPublicKeyConfigResponse> getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPublicKeyConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicKeyConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicKeyConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicKeyConfig").withMarshaller((Marshaller)new GetPublicKeyConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPublicKeyConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getPublicKeyConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getPublicKeyConfig$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getPublicKeyConfig$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRealtimeLogConfigResponse> getRealtimeLogConfig(GetRealtimeLogConfigRequest getRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRealtimeLogConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRealtimeLogConfig").withMarshaller((Marshaller)new GetRealtimeLogConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRealtimeLogConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRealtimeLogConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getRealtimeLogConfig$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getRealtimeLogConfig$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStreamingDistributionResponse> getStreamingDistribution(GetStreamingDistributionRequest getStreamingDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStreamingDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStreamingDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStreamingDistribution").withMarshaller((Marshaller)new GetStreamingDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStreamingDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStreamingDistributionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getStreamingDistribution$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getStreamingDistribution$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStreamingDistributionConfigResponse> getStreamingDistributionConfig(GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStreamingDistributionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStreamingDistributionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStreamingDistributionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStreamingDistributionConfig").withMarshaller((Marshaller)new GetStreamingDistributionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStreamingDistributionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStreamingDistributionConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$getStreamingDistributionConfig$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$getStreamingDistributionConfig$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCachePoliciesResponse> listCachePolicies(ListCachePoliciesRequest listCachePoliciesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listCachePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCachePolicies");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListCachePoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCachePolicies").withMarshaller((Marshaller)new ListCachePoliciesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCachePoliciesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listCachePoliciesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listCachePolicies$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listCachePolicies$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listCloudFrontOriginAccessIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCloudFrontOriginAccessIdentities");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListCloudFrontOriginAccessIdentitiesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCloudFrontOriginAccessIdentities").withMarshaller((Marshaller)new ListCloudFrontOriginAccessIdentitiesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCloudFrontOriginAccessIdentitiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listCloudFrontOriginAccessIdentitiesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listCloudFrontOriginAccessIdentities$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listCloudFrontOriginAccessIdentities$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListConflictingAliasesResponse> listConflictingAliases(ListConflictingAliasesRequest listConflictingAliasesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listConflictingAliasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConflictingAliases");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListConflictingAliasesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConflictingAliases").withMarshaller((Marshaller)new ListConflictingAliasesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listConflictingAliasesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listConflictingAliasesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listConflictingAliases$160(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listConflictingAliases$161((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsResponse> listDistributions(ListDistributionsRequest listDistributionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributions");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributions").withMarshaller((Marshaller)new ListDistributionsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listDistributions$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listDistributions$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsByCachePolicyIdResponse> listDistributionsByCachePolicyId(ListDistributionsByCachePolicyIdRequest listDistributionsByCachePolicyIdRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByCachePolicyIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByCachePolicyId");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByCachePolicyIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByCachePolicyId").withMarshaller((Marshaller)new ListDistributionsByCachePolicyIdRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByCachePolicyIdRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionsByCachePolicyIdRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByCachePolicyId$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByCachePolicyId$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsByKeyGroupResponse> listDistributionsByKeyGroup(ListDistributionsByKeyGroupRequest listDistributionsByKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByKeyGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByKeyGroup").withMarshaller((Marshaller)new ListDistributionsByKeyGroupRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByKeyGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionsByKeyGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByKeyGroup$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByKeyGroup$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsByOriginRequestPolicyIdResponse> listDistributionsByOriginRequestPolicyId(ListDistributionsByOriginRequestPolicyIdRequest listDistributionsByOriginRequestPolicyIdRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByOriginRequestPolicyIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByOriginRequestPolicyId");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByOriginRequestPolicyIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByOriginRequestPolicyId").withMarshaller((Marshaller)new ListDistributionsByOriginRequestPolicyIdRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByOriginRequestPolicyIdRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionsByOriginRequestPolicyIdRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByOriginRequestPolicyId$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByOriginRequestPolicyId$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsByRealtimeLogConfigResponse> listDistributionsByRealtimeLogConfig(ListDistributionsByRealtimeLogConfigRequest listDistributionsByRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByRealtimeLogConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByRealtimeLogConfig").withMarshaller((Marshaller)new ListDistributionsByRealtimeLogConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByRealtimeLogConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionsByRealtimeLogConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByRealtimeLogConfig$175(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByRealtimeLogConfig$176((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsByWebAclIdResponse> listDistributionsByWebACLId(ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDistributionsByWebAclIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDistributionsByWebACLId");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListDistributionsByWebAclIdResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDistributionsByWebACLId").withMarshaller((Marshaller)new ListDistributionsByWebAclIdRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDistributionsByWebAclIdRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDistributionsByWebAclIdRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByWebACLId$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listDistributionsByWebACLId$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFieldLevelEncryptionConfigsResponse> listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFieldLevelEncryptionConfigsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFieldLevelEncryptionConfigs");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListFieldLevelEncryptionConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFieldLevelEncryptionConfigs").withMarshaller((Marshaller)new ListFieldLevelEncryptionConfigsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFieldLevelEncryptionConfigsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFieldLevelEncryptionConfigsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listFieldLevelEncryptionConfigs$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listFieldLevelEncryptionConfigs$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFieldLevelEncryptionProfilesResponse> listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFieldLevelEncryptionProfilesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFieldLevelEncryptionProfiles");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListFieldLevelEncryptionProfilesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFieldLevelEncryptionProfiles").withMarshaller((Marshaller)new ListFieldLevelEncryptionProfilesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFieldLevelEncryptionProfilesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFieldLevelEncryptionProfilesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listFieldLevelEncryptionProfiles$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listFieldLevelEncryptionProfiles$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFunctionsResponse> listFunctions(ListFunctionsRequest listFunctionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFunctionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFunctions");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListFunctionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFunctions").withMarshaller((Marshaller)new ListFunctionsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFunctionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFunctionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listFunctions$187(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listFunctions$188((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListInvalidationsResponse> listInvalidations(ListInvalidationsRequest listInvalidationsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listInvalidationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInvalidations");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListInvalidationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInvalidations").withMarshaller((Marshaller)new ListInvalidationsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listInvalidationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listInvalidationsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listInvalidations$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listInvalidations$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListKeyGroupsResponse> listKeyGroups(ListKeyGroupsRequest listKeyGroupsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listKeyGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyGroups");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListKeyGroupsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyGroups").withMarshaller((Marshaller)new ListKeyGroupsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listKeyGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listKeyGroupsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listKeyGroups$193(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listKeyGroups$194((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListOriginRequestPoliciesResponse> listOriginRequestPolicies(ListOriginRequestPoliciesRequest listOriginRequestPoliciesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listOriginRequestPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOriginRequestPolicies");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListOriginRequestPoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOriginRequestPolicies").withMarshaller((Marshaller)new ListOriginRequestPoliciesRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listOriginRequestPoliciesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listOriginRequestPoliciesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listOriginRequestPolicies$196(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listOriginRequestPolicies$197((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPublicKeysResponse> listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listPublicKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPublicKeys");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListPublicKeysResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPublicKeys").withMarshaller((Marshaller)new ListPublicKeysRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPublicKeysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPublicKeysRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listPublicKeys$199(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listPublicKeys$200((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRealtimeLogConfigsResponse> listRealtimeLogConfigs(ListRealtimeLogConfigsRequest listRealtimeLogConfigsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRealtimeLogConfigsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRealtimeLogConfigs");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListRealtimeLogConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRealtimeLogConfigs").withMarshaller((Marshaller)new ListRealtimeLogConfigsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRealtimeLogConfigsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listRealtimeLogConfigsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listRealtimeLogConfigs$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listRealtimeLogConfigs$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions(ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStreamingDistributionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStreamingDistributions");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListStreamingDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreamingDistributions").withMarshaller((Marshaller)new ListStreamingDistributionsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStreamingDistributionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listStreamingDistributionsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listStreamingDistributions$205(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listStreamingDistributions$206((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$listTagsForResource$208(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$listTagsForResource$209((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PublishFunctionResponse> publishFunction(PublishFunctionRequest publishFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, publishFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PublishFunction");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PublishFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PublishFunction").withMarshaller((Marshaller)new PublishFunctionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)publishFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = publishFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$publishFunction$211(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$publishFunction$212((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(TagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$tagResource$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$tagResource$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestFunctionResponse> testFunction(TestFunctionRequest testFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, testFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestFunction");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(TestFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestFunction").withMarshaller((Marshaller)new TestFunctionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)testFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = testFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$testFunction$217(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$testFunction$218((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UntagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$untagResource$220(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$untagResource$221((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCachePolicyResponse> updateCachePolicy(UpdateCachePolicyRequest updateCachePolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateCachePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCachePolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCachePolicy").withMarshaller((Marshaller)new UpdateCachePolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCachePolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateCachePolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateCachePolicy$223(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateCachePolicy$224((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCloudFrontOriginAccessIdentity");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateCloudFrontOriginAccessIdentityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCloudFrontOriginAccessIdentity").withMarshaller((Marshaller)new UpdateCloudFrontOriginAccessIdentityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCloudFrontOriginAccessIdentityRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateCloudFrontOriginAccessIdentity$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateCloudFrontOriginAccessIdentity$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistribution").withMarshaller((Marshaller)new UpdateDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDistributionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateDistribution$229(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateDistribution$230((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFieldLevelEncryptionConfigResponse> updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFieldLevelEncryptionConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateFieldLevelEncryptionConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFieldLevelEncryptionConfig").withMarshaller((Marshaller)new UpdateFieldLevelEncryptionConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFieldLevelEncryptionConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateFieldLevelEncryptionConfig$232(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateFieldLevelEncryptionConfig$233((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFieldLevelEncryptionProfileResponse> updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFieldLevelEncryptionProfile");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateFieldLevelEncryptionProfileResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFieldLevelEncryptionProfile").withMarshaller((Marshaller)new UpdateFieldLevelEncryptionProfileRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFieldLevelEncryptionProfileRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateFieldLevelEncryptionProfile$235(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateFieldLevelEncryptionProfile$236((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest updateFunctionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFunctionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFunction");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFunction").withMarshaller((Marshaller)new UpdateFunctionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFunctionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFunctionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateFunction$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateFunction$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateKeyGroupResponse> updateKeyGroup(UpdateKeyGroupRequest updateKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateKeyGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateKeyGroup");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateKeyGroup").withMarshaller((Marshaller)new UpdateKeyGroupRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateKeyGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateKeyGroupRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateKeyGroup$241(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateKeyGroup$242((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateOriginRequestPolicyResponse> updateOriginRequestPolicy(UpdateOriginRequestPolicyRequest updateOriginRequestPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateOriginRequestPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOriginRequestPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateOriginRequestPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOriginRequestPolicy").withMarshaller((Marshaller)new UpdateOriginRequestPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateOriginRequestPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateOriginRequestPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateOriginRequestPolicy$244(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateOriginRequestPolicy$245((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePublicKeyResponse> updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updatePublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePublicKey");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePublicKey").withMarshaller((Marshaller)new UpdatePublicKeyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePublicKeyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePublicKeyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updatePublicKey$247(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updatePublicKey$248((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRealtimeLogConfigResponse> updateRealtimeLogConfig(UpdateRealtimeLogConfigRequest updateRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRealtimeLogConfig");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateRealtimeLogConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRealtimeLogConfig").withMarshaller((Marshaller)new UpdateRealtimeLogConfigRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRealtimeLogConfigRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRealtimeLogConfigRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateRealtimeLogConfig$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateRealtimeLogConfig$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStreamingDistributionResponse> updateStreamingDistribution(UpdateStreamingDistributionRequest updateStreamingDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudFrontAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateStreamingDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStreamingDistribution");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateStreamingDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStreamingDistribution").withMarshaller((Marshaller)new UpdateStreamingDistributionRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateStreamingDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateStreamingDistributionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudFrontAsyncClient.lambda$updateStreamingDistribution$253(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudFrontAsyncClient.lambda$updateStreamingDistribution$254((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("StreamingDistributionAlreadyExists").exceptionBuilderSupplier(StreamingDistributionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchInvalidation").exceptionBuilderSupplier(NoSuchInvalidationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionConfig").exceptionBuilderSupplier(NoSuchFieldLevelEncryptionConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OriginRequestPolicyAlreadyExists").exceptionBuilderSupplier(OriginRequestPolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyKeyGroupsAssociatedToDistribution").exceptionBuilderSupplier(TooManyKeyGroupsAssociatedToDistributionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMinimumProtocolVersion").exceptionBuilderSupplier(InvalidMinimumProtocolVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyInvalidationsInProgress").exceptionBuilderSupplier(TooManyInvalidationsInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionConfigs").exceptionBuilderSupplier(TooManyFieldLevelEncryptionConfigsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPublicKeys").exceptionBuilderSupplier(TooManyPublicKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCacheBehaviors").exceptionBuilderSupplier(TooManyCacheBehaviorsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityInUse").exceptionBuilderSupplier(CloudFrontOriginAccessIdentityInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileAlreadyExists").exceptionBuilderSupplier(FieldLevelEncryptionProfileAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingBody").exceptionBuilderSupplier(MissingBodyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOrigins").exceptionBuilderSupplier(TooManyOriginsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FunctionSizeLimitExceeded").exceptionBuilderSupplier(FunctionSizeLimitExceededException::builder).httpStatusCode(Integer.valueOf(413)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperation").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchTooLarge").exceptionBuilderSupplier(BatchTooLargeException::builder).httpStatusCode(Integer.valueOf(413)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RealtimeLogConfigInUse").exceptionBuilderSupplier(RealtimeLogConfigInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResponseCode").exceptionBuilderSupplier(InvalidResponseCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigAlreadyExists").exceptionBuilderSupplier(FieldLevelEncryptionConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginKeepaliveTimeout").exceptionBuilderSupplier(InvalidOriginKeepaliveTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyStreamingDistributionCNAMEs").exceptionBuilderSupplier(TooManyStreamingDistributionCnamEsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StreamingDistributionNotDisabled").exceptionBuilderSupplier(StreamingDistributionNotDisabledException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionCNAMEs").exceptionBuilderSupplier(TooManyDistributionCnamEsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyQueryStringParameters").exceptionBuilderSupplier(TooManyQueryStringParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionEncryptionEntities").exceptionBuilderSupplier(TooManyFieldLevelEncryptionEncryptionEntitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigInUse").exceptionBuilderSupplier(FieldLevelEncryptionConfigInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityAlreadyExists").exceptionBuilderSupplier(CloudFrontOriginAccessIdentityAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchRealtimeLogConfig").exceptionBuilderSupplier(NoSuchRealtimeLogConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidProtocolSettings").exceptionBuilderSupplier(InvalidProtocolSettingsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUse").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidForwardCookies").exceptionBuilderSupplier(InvalidForwardCookiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyPublicKeysInKeyGroup").exceptionBuilderSupplier(TooManyPublicKeysInKeyGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginAccessIdentity").exceptionBuilderSupplier(InvalidOriginAccessIdentityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalUpdate").exceptionBuilderSupplier(IllegalUpdateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCookieNamesInWhiteList").exceptionBuilderSupplier(TooManyCookieNamesInWhiteListException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrustedKeyGroupDoesNotExist").exceptionBuilderSupplier(TrustedKeyGroupDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchDistribution").exceptionBuilderSupplier(NoSuchDistributionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CNAMEAlreadyExists").exceptionBuilderSupplier(CnameAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTTLOrder").exceptionBuilderSupplier(InvalidTtlOrderException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FunctionInUse").exceptionBuilderSupplier(FunctionInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidViewerCertificate").exceptionBuilderSupplier(InvalidViewerCertificateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCachePolicies").exceptionBuilderSupplier(TooManyCachePoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyQueryStringsInCachePolicy").exceptionBuilderSupplier(TooManyQueryStringsInCachePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FunctionAlreadyExists").exceptionBuilderSupplier(FunctionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CachePolicyInUse").exceptionBuilderSupplier(CachePolicyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDefaultRootObject").exceptionBuilderSupplier(InvalidDefaultRootObjectException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCloudFrontOriginAccessIdentities").exceptionBuilderSupplier(TooManyCloudFrontOriginAccessIdentitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionContentTypeProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionContentTypeProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRelativePath").exceptionBuilderSupplier(InvalidRelativePathException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsWithLambdaAssociations").exceptionBuilderSupplier(TooManyDistributionsWithLambdaAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidHeadersForS3Origin").exceptionBuilderSupplier(InvalidHeadersForS3OriginException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RealtimeLogConfigAlreadyExists").exceptionBuilderSupplier(RealtimeLogConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributions").exceptionBuilderSupplier(TooManyDistributionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToOriginRequestPolicy").exceptionBuilderSupplier(TooManyDistributionsAssociatedToOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotChangeImmutablePublicKeyFields").exceptionBuilderSupplier(CannotChangeImmutablePublicKeyFieldsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionQueryArgProfiles").exceptionBuilderSupplier(TooManyFieldLevelEncryptionQueryArgProfilesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCookiesInOriginRequestPolicy").exceptionBuilderSupplier(TooManyCookiesInOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalDelete").exceptionBuilderSupplier(IllegalDeleteException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOrigin").exceptionBuilderSupplier(InvalidOriginException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TestFunctionFailed").exceptionBuilderSupplier(TestFunctionFailedException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidGeoRestrictionParameter").exceptionBuilderSupplier(InvalidGeoRestrictionParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrustedSignerDoesNotExist").exceptionBuilderSupplier(TrustedSignerDoesNotExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHeadersInForwardedValues").exceptionBuilderSupplier(TooManyHeadersInForwardedValuesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidOriginReadTimeout").exceptionBuilderSupplier(InvalidOriginReadTimeoutException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OriginRequestPolicyInUse").exceptionBuilderSupplier(OriginRequestPolicyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToKeyGroup").exceptionBuilderSupplier(TooManyDistributionsAssociatedToKeyGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidErrorCode").exceptionBuilderSupplier(InvalidErrorCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionFieldPatterns").exceptionBuilderSupplier(TooManyFieldLevelEncryptionFieldPatternsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior").exceptionBuilderSupplier(IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequiredProtocol").exceptionBuilderSupplier(InvalidRequiredProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchOriginRequestPolicy").exceptionBuilderSupplier(NoSuchOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchOrigin").exceptionBuilderSupplier(NoSuchOriginException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyQueryStringsInOriginRequestPolicy").exceptionBuilderSupplier(TooManyQueryStringsInOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrustedSigners").exceptionBuilderSupplier(TooManyTrustedSignersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFunctions").exceptionBuilderSupplier(TooManyFunctionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsWithFunctionAssociations").exceptionBuilderSupplier(TooManyDistributionsWithFunctionAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyStreamingDistributions").exceptionBuilderSupplier(TooManyStreamingDistributionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsWithSingleFunctionARN").exceptionBuilderSupplier(TooManyDistributionsWithSingleFunctionArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicKeyInUse").exceptionBuilderSupplier(PublicKeyInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PreconditionFailed").exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(Integer.valueOf(412)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyKeyGroups").exceptionBuilderSupplier(TooManyKeyGroupsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DistributionAlreadyExists").exceptionBuilderSupplier(DistributionAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CachePolicyAlreadyExists").exceptionBuilderSupplier(CachePolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginCustomHeaders").exceptionBuilderSupplier(TooManyOriginCustomHeadersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLocationCode").exceptionBuilderSupplier(InvalidLocationCodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyFunctionAssociations").exceptionBuilderSupplier(TooManyFunctionAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileSizeExceeded").exceptionBuilderSupplier(FieldLevelEncryptionProfileSizeExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCertificates").exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryArgProfileEmpty").exceptionBuilderSupplier(QueryArgProfileEmptyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRealtimeLogConfigs").exceptionBuilderSupplier(TooManyRealtimeLogConfigsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidQueryStringParameters").exceptionBuilderSupplier(InvalidQueryStringParametersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFunctionExists").exceptionBuilderSupplier(NoSuchFunctionExistsException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHeadersInCachePolicy").exceptionBuilderSupplier(TooManyHeadersInCachePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RealtimeLogConfigOwnerMismatch").exceptionBuilderSupplier(RealtimeLogConfigOwnerMismatchException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionProfile").exceptionBuilderSupplier(NoSuchFieldLevelEncryptionProfileException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchResource").exceptionBuilderSupplier(NoSuchResourceException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InconsistentQuantities").exceptionBuilderSupplier(InconsistentQuantitiesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFunctionAssociation").exceptionBuilderSupplier(InvalidFunctionAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionAssociation").exceptionBuilderSupplier(InvalidLambdaFunctionAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLambdaFunctionAssociations").exceptionBuilderSupplier(TooManyLambdaFunctionAssociationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DistributionNotDisabled").exceptionBuilderSupplier(DistributionNotDisabledException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginGroupsPerDistribution").exceptionBuilderSupplier(TooManyOriginGroupsPerDistributionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDenied").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCookiesInCachePolicy").exceptionBuilderSupplier(TooManyCookiesInCachePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgument").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyOriginRequestPolicies").exceptionBuilderSupplier(TooManyOriginRequestPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCachePolicy").exceptionBuilderSupplier(NoSuchCachePolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KeyGroupAlreadyExists").exceptionBuilderSupplier(KeyGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchStreamingDistribution").exceptionBuilderSupplier(NoSuchStreamingDistributionException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicKey").exceptionBuilderSupplier(NoSuchPublicKeyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidWebACLId").exceptionBuilderSupplier(InvalidWebAclIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToFieldLevelEncryptionConfig").exceptionBuilderSupplier(TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToCachePolicy").exceptionBuilderSupplier(TooManyDistributionsAssociatedToCachePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicKeyAlreadyExists").exceptionBuilderSupplier(PublicKeyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileInUse").exceptionBuilderSupplier(FieldLevelEncryptionProfileInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIfMatchVersion").exceptionBuilderSupplier(InvalidIfMatchVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagging").exceptionBuilderSupplier(InvalidTaggingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHeadersInOriginRequestPolicy").exceptionBuilderSupplier(TooManyHeadersInOriginRequestPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCloudFrontOriginAccessIdentity").exceptionBuilderSupplier(NoSuchCloudFrontOriginAccessIdentityException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudFrontException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends CloudFrontRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.7").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFrontRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public CloudFrontAsyncWaiter waiter() {
        return CloudFrontAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    private static /* synthetic */ void lambda$updateStreamingDistribution$254(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStreamingDistribution$253(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateStreamingDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRealtimeLogConfig$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRealtimeLogConfig$250(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRealtimeLogConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePublicKey$248(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePublicKey$247(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePublicKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateOriginRequestPolicy$245(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateOriginRequestPolicy$244(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateOriginRequestPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateKeyGroup$242(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateKeyGroup$241(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateKeyGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFunction$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFunction$238(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFieldLevelEncryptionProfile$236(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFieldLevelEncryptionProfile$235(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFieldLevelEncryptionProfileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFieldLevelEncryptionConfig$233(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFieldLevelEncryptionConfig$232(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFieldLevelEncryptionConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDistribution$230(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistribution$229(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCloudFrontOriginAccessIdentity$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCloudFrontOriginAccessIdentity$226(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCloudFrontOriginAccessIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCachePolicy$224(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCachePolicy$223(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCachePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$221(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$220(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$testFunction$218(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testFunction$217(List metricPublishers, MetricCollector apiCallMetricCollector, TestFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$214(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$publishFunction$212(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$publishFunction$211(List metricPublishers, MetricCollector apiCallMetricCollector, PublishFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$208(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStreamingDistributions$206(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStreamingDistributions$205(List metricPublishers, MetricCollector apiCallMetricCollector, ListStreamingDistributionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRealtimeLogConfigs$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRealtimeLogConfigs$202(List metricPublishers, MetricCollector apiCallMetricCollector, ListRealtimeLogConfigsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPublicKeys$200(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPublicKeys$199(List metricPublishers, MetricCollector apiCallMetricCollector, ListPublicKeysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listOriginRequestPolicies$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOriginRequestPolicies$196(List metricPublishers, MetricCollector apiCallMetricCollector, ListOriginRequestPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listKeyGroups$194(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyGroups$193(List metricPublishers, MetricCollector apiCallMetricCollector, ListKeyGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listInvalidations$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInvalidations$190(List metricPublishers, MetricCollector apiCallMetricCollector, ListInvalidationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFunctions$188(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFunctions$187(List metricPublishers, MetricCollector apiCallMetricCollector, ListFunctionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFieldLevelEncryptionProfiles$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFieldLevelEncryptionProfiles$184(List metricPublishers, MetricCollector apiCallMetricCollector, ListFieldLevelEncryptionProfilesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFieldLevelEncryptionConfigs$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFieldLevelEncryptionConfigs$181(List metricPublishers, MetricCollector apiCallMetricCollector, ListFieldLevelEncryptionConfigsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDistributionsByWebACLId$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByWebACLId$178(List metricPublishers, MetricCollector apiCallMetricCollector, ListDistributionsByWebAclIdResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDistributionsByRealtimeLogConfig$176(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByRealtimeLogConfig$175(List metricPublishers, MetricCollector apiCallMetricCollector, ListDistributionsByRealtimeLogConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDistributionsByOriginRequestPolicyId$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByOriginRequestPolicyId$172(List metricPublishers, MetricCollector apiCallMetricCollector, ListDistributionsByOriginRequestPolicyIdResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDistributionsByKeyGroup$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByKeyGroup$169(List metricPublishers, MetricCollector apiCallMetricCollector, ListDistributionsByKeyGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDistributionsByCachePolicyId$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributionsByCachePolicyId$166(List metricPublishers, MetricCollector apiCallMetricCollector, ListDistributionsByCachePolicyIdResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDistributions$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDistributions$163(List metricPublishers, MetricCollector apiCallMetricCollector, ListDistributionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listConflictingAliases$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConflictingAliases$160(List metricPublishers, MetricCollector apiCallMetricCollector, ListConflictingAliasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCloudFrontOriginAccessIdentities$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCloudFrontOriginAccessIdentities$157(List metricPublishers, MetricCollector apiCallMetricCollector, ListCloudFrontOriginAccessIdentitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCachePolicies$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCachePolicies$154(List metricPublishers, MetricCollector apiCallMetricCollector, ListCachePoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStreamingDistributionConfig$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStreamingDistributionConfig$151(List metricPublishers, MetricCollector apiCallMetricCollector, GetStreamingDistributionConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStreamingDistribution$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStreamingDistribution$148(List metricPublishers, MetricCollector apiCallMetricCollector, GetStreamingDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRealtimeLogConfig$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRealtimeLogConfig$145(List metricPublishers, MetricCollector apiCallMetricCollector, GetRealtimeLogConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPublicKeyConfig$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicKeyConfig$142(List metricPublishers, MetricCollector apiCallMetricCollector, GetPublicKeyConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPublicKey$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicKey$139(List metricPublishers, MetricCollector apiCallMetricCollector, GetPublicKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOriginRequestPolicyConfig$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOriginRequestPolicyConfig$136(List metricPublishers, MetricCollector apiCallMetricCollector, GetOriginRequestPolicyConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOriginRequestPolicy$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOriginRequestPolicy$133(List metricPublishers, MetricCollector apiCallMetricCollector, GetOriginRequestPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMonitoringSubscription$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMonitoringSubscription$130(List metricPublishers, MetricCollector apiCallMetricCollector, GetMonitoringSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getKeyGroupConfig$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyGroupConfig$127(List metricPublishers, MetricCollector apiCallMetricCollector, GetKeyGroupConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getKeyGroup$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyGroup$124(List metricPublishers, MetricCollector apiCallMetricCollector, GetKeyGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInvalidation$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInvalidation$121(List metricPublishers, MetricCollector apiCallMetricCollector, GetInvalidationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFunction$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFunction$118(List metricPublishers, MetricCollector apiCallMetricCollector, GetFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionProfileConfig$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionProfileConfig$115(List metricPublishers, MetricCollector apiCallMetricCollector, GetFieldLevelEncryptionProfileConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionProfile$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionProfile$112(List metricPublishers, MetricCollector apiCallMetricCollector, GetFieldLevelEncryptionProfileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionConfig$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryptionConfig$109(List metricPublishers, MetricCollector apiCallMetricCollector, GetFieldLevelEncryptionConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryption$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFieldLevelEncryption$106(List metricPublishers, MetricCollector apiCallMetricCollector, GetFieldLevelEncryptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributionConfig$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionConfig$103(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistribution$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistribution$100(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCloudFrontOriginAccessIdentityConfig$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudFrontOriginAccessIdentityConfig$97(List metricPublishers, MetricCollector apiCallMetricCollector, GetCloudFrontOriginAccessIdentityConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCloudFrontOriginAccessIdentity$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudFrontOriginAccessIdentity$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetCloudFrontOriginAccessIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCachePolicyConfig$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCachePolicyConfig$91(List metricPublishers, MetricCollector apiCallMetricCollector, GetCachePolicyConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCachePolicy$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCachePolicy$88(List metricPublishers, MetricCollector apiCallMetricCollector, GetCachePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFunction$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFunction$85(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStreamingDistribution$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStreamingDistribution$82(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStreamingDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRealtimeLogConfig$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRealtimeLogConfig$79(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRealtimeLogConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePublicKey$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePublicKey$76(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePublicKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteOriginRequestPolicy$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteOriginRequestPolicy$73(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteOriginRequestPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMonitoringSubscription$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMonitoringSubscription$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMonitoringSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteKeyGroup$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKeyGroup$67(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteKeyGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFunction$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFunction$64(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFieldLevelEncryptionProfile$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFieldLevelEncryptionProfile$61(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFieldLevelEncryptionProfileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFieldLevelEncryptionConfig$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFieldLevelEncryptionConfig$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFieldLevelEncryptionConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDistribution$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDistribution$55(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCloudFrontOriginAccessIdentity$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCloudFrontOriginAccessIdentity$52(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCloudFrontOriginAccessIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCachePolicy$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCachePolicy$49(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCachePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createStreamingDistributionWithTags$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStreamingDistributionWithTags$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateStreamingDistributionWithTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createStreamingDistribution$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStreamingDistribution$43(List metricPublishers, MetricCollector apiCallMetricCollector, CreateStreamingDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRealtimeLogConfig$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRealtimeLogConfig$40(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRealtimeLogConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPublicKey$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPublicKey$37(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePublicKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createOriginRequestPolicy$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createOriginRequestPolicy$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateOriginRequestPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createMonitoringSubscription$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMonitoringSubscription$31(List metricPublishers, MetricCollector apiCallMetricCollector, CreateMonitoringSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createKeyGroup$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKeyGroup$28(List metricPublishers, MetricCollector apiCallMetricCollector, CreateKeyGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInvalidation$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInvalidation$25(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInvalidationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFunction$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFunction$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFunctionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFieldLevelEncryptionProfile$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFieldLevelEncryptionProfile$19(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFieldLevelEncryptionProfileResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFieldLevelEncryptionConfig$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFieldLevelEncryptionConfig$16(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFieldLevelEncryptionConfigResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDistributionWithTags$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDistributionWithTags$13(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDistributionWithTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDistribution$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDistribution$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCloudFrontOriginAccessIdentity$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCloudFrontOriginAccessIdentity$7(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCloudFrontOriginAccessIdentityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCachePolicy$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCachePolicy$4(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCachePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateAlias$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateAlias$1(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateAliasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

